"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogTypeService = void 0;
var _constants = require("../utils/constants");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class LogTypeService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "createLogType", async (context, request, response) => {
      try {
        const logType = request.body;
        const client = this.getClient(request, context);
        const createLogTypeResponse = await client(_constants.CLIENT_LOGTYPE_METHODS.CREATE_LOGTYPE, {
          body: logType
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: createLogTypeResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - LogTypeService - createLogType:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "searchLogTypes", async (context, request, response) => {
      try {
        const query = request.body;
        const client = this.getClient(request, context);
        const searchLogTypesResponse = await client(_constants.CLIENT_LOGTYPE_METHODS.SEARCH_LOGTYPES, {
          body: {
            size: 10000,
            query: query !== null && query !== void 0 ? query : {
              match_all: {}
            }
          }
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: searchLogTypesResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - LogTypeService - searchLogTypes:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "updateLogType", async (context, request, response) => {
      try {
        const logType = request.body;
        const {
          logTypeId
        } = request.params;
        const params = {
          body: logType,
          logTypeId
        };
        const client = this.getClient(request, context);
        const updateLogTypeResponse = await client(_constants.CLIENT_LOGTYPE_METHODS.UPDATE_LOGTYPE, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: updateLogTypeResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - LogTypeService - updateLogType:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "deleteLogType", async (context, request, response) => {
      try {
        const {
          logTypeId
        } = request.params;
        const params = {
          logTypeId
        };
        const client = this.getClient(request, context);
        const deleteLogTypeResponse = await client(_constants.CLIENT_LOGTYPE_METHODS.DELETE_LOGTYPE, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: deleteLogTypeResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - DetectorsService - deleteDetector:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
  }
}
exports.LogTypeService = LogTypeService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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