"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.retrieveQueryById = exports.retrieveLiveQueries = void 0;
var _apiendpoints = require("./apiendpoints");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// Utility function to fetch query by id and time range
const retrieveQueryById = async (core, dataSourceId, start, end, id, verbose) => {
  const nullResponse = {
    response: {
      top_queries: []
    }
  };
  const params = {
    query: {
      dataSourceId,
      from: start,
      to: end,
      id,
      verbose
    }
  };
  const fetchMetric = async endpoint => {
    try {
      var _response$response;
      const response = await core.http.get(endpoint, params);
      return {
        response: {
          top_queries: Array.isArray(response === null || response === void 0 || (_response$response = response.response) === null || _response$response === void 0 ? void 0 : _response$response.top_queries) ? response.response.top_queries : []
        }
      };
    } catch (error) {
      console.error('Error occurred while fetching the data:', error);
      return nullResponse;
    }
  };
  try {
    const endpoints = [`/api/top_queries/latency`, `/api/top_queries/cpu`, `/api/top_queries/memory`];
    for (const endpoint of endpoints) {
      const result = await fetchMetric(endpoint);
      if (result.response.top_queries.length > 0) {
        return result.response.top_queries[0];
      }
    }
    return null;
  } catch (error) {
    console.error('Error retrieving query details:', error);
    return null;
  }
};
exports.retrieveQueryById = retrieveQueryById;
const retrieveLiveQueries = async (core, dataSourceId) => {
  const nullResponse = {
    ok: true,
    response: {
      live_queries: []
    }
  };
  const errorResponse = {
    ok: false,
    response: {
      live_queries: []
    }
  };
  try {
    var _core$data, _response$response2;
    const http = dataSourceId && (_core$data = core.data) !== null && _core$data !== void 0 && _core$data.dataSources ? core.data.dataSources.get(dataSourceId) : core.http;
    const response = await http.get(_apiendpoints.API_ENDPOINTS.LIVE_QUERIES);
    const liveQueries = response === null || response === void 0 || (_response$response2 = response.response) === null || _response$response2 === void 0 ? void 0 : _response$response2.live_queries;
    if (Array.isArray(liveQueries)) {
      return response;
    } else {
      console.warn('No live queries found in response');
      return nullResponse;
    }
  } catch (error) {
    console.error('Error retrieving live queries:', error);
    return errorResponse;
  }
};
exports.retrieveLiveQueries = retrieveLiveQueries;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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