"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _constants = require("../../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled = false) {
  const {
    aliasService
  } = services;
  let getAliasesQueryParam = {
    search: _configSchema.schema.maybe(_configSchema.schema.string())
  };
  if (dataSourceEnabled) {
    getAliasesQueryParam = {
      ...getAliasesQueryParam,
      dataSourceId: _configSchema.schema.string()
    };
  }
  router.get({
    path: _constants.NODE_API._ALIASES,
    validate: {
      query: _configSchema.schema.object(getAliasesQueryParam)
    }
  }, aliasService.getAliases);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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