/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.util;

import java.util.Objects;
import java.util.Properties;
import net.wimpi.modbus.util.SerialParameterValidator;

public class SerialParameters {
    public static int DEFAULT_RECEIVE_TIMEOUT_MILLIS = 1500;
    private String m_PortName;
    private int m_BaudRate;
    private int m_FlowControlIn;
    private int m_FlowControlOut;
    private int m_Databits;
    private int m_Stopbits;
    private int m_Parity;
    private String m_Encoding;
    private boolean m_Echo;
    private int m_ReceiveTimeoutMillis;

    public SerialParameters() {
        this("", 9600, 0, 0, 8, 1, 0, "ascii", false, DEFAULT_RECEIVE_TIMEOUT_MILLIS);
    }

    public SerialParameters(String portName, int baudRate, int flowControlIn, int flowControlOut, int databits, int stopbits, int parity, String encoding, boolean echo, int receiveTimeoutMillis) {
        this.setPortName(portName);
        this.setBaudRate(baudRate);
        this.setFlowControlIn(flowControlIn);
        this.setFlowControlOut(flowControlOut);
        this.setDatabits(databits);
        this.setStopbits(stopbits);
        this.setParity(parity);
        this.setEncoding(encoding);
        this.setEcho(echo);
        this.setReceiveTimeoutMillis(receiveTimeoutMillis);
    }

    public String toString() {
        return "SerialParameters [m_PortName=" + this.m_PortName + ", m_BaudRate=" + this.m_BaudRate + ", m_FlowControlIn=" + this.m_FlowControlIn + ", m_FlowControlOut=" + this.m_FlowControlOut + ", m_Databits=" + this.m_Databits + ", m_Stopbits=" + this.m_Stopbits + ", m_Parity=" + this.m_Parity + ", m_Encoding=" + this.m_Encoding + ", m_Echo=" + this.m_Echo + ", m_ReceiveTimeoutMillis=" + this.m_ReceiveTimeoutMillis + "]";
    }

    public int hashCode() {
        return Objects.hash(this.m_BaudRate, this.m_Databits, this.m_Echo, this.m_Encoding, this.m_FlowControlIn, this.m_FlowControlOut, this.m_Parity, this.m_PortName, this.m_ReceiveTimeoutMillis, this.m_Stopbits);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SerialParameters rhs = (SerialParameters)obj;
        return this.m_BaudRate == rhs.m_BaudRate && this.m_Databits == rhs.m_Databits && this.m_Echo == rhs.m_Echo && Objects.equals(this.m_Encoding, rhs.m_Encoding) && this.m_FlowControlIn == rhs.m_FlowControlIn && this.m_FlowControlOut == rhs.m_FlowControlOut && this.m_Parity == rhs.m_Parity && Objects.equals(this.m_PortName, rhs.m_PortName) && this.m_ReceiveTimeoutMillis == rhs.m_ReceiveTimeoutMillis && this.m_Stopbits == rhs.m_Stopbits;
    }

    public SerialParameters(Properties props, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        this.setPortName(props.getProperty(prefix + "portName", ""));
        this.setBaudRate(props.getProperty(prefix + "baudRate", "9600"));
        this.setFlowControlIn(props.getProperty(prefix + "flowControlIn", "0"));
        this.setFlowControlOut(props.getProperty(prefix + "flowControlOut", "0"));
        this.setParity(props.getProperty(prefix + "parity", "0"));
        this.setDatabits(props.getProperty(prefix + "databits", "8"));
        this.setStopbits(props.getProperty(prefix + "stopbits", "1"));
        this.setEncoding(props.getProperty(prefix + "encoding", "ascii"));
        this.setEcho("true".equals(props.getProperty(prefix + "echo")));
        this.setReceiveTimeoutMillis(props.getProperty(prefix + "timeout", "500"));
    }

    public void setPortName(String name) {
        this.m_PortName = name;
    }

    public String getPortName() {
        return this.m_PortName;
    }

    public void setBaudRate(int rate) throws IllegalArgumentException {
        if (!SerialParameterValidator.isBaudRateValid(rate)) {
            throw new IllegalArgumentException("invalid baud rate: " + Integer.toString(rate));
        }
        this.m_BaudRate = rate;
    }

    public void setBaudRate(String rate) throws IllegalArgumentException {
        int intBaudRate = 0;
        try {
            intBaudRate = Integer.parseInt(rate);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("baudString '" + rate + "' can not be converted to a number: " + e.getMessage());
        }
        this.setBaudRate(intBaudRate);
    }

    public int getBaudRate() {
        return this.m_BaudRate;
    }

    public String getBaudRateString() {
        return Integer.toString(this.m_BaudRate);
    }

    public void setFlowControlIn(int flowcontrol) throws IllegalArgumentException {
        if (!SerialParameterValidator.isFlowControlValid(flowcontrol)) {
            throw new IllegalArgumentException("flowcontrol int '" + flowcontrol + "' invalid");
        }
        this.m_FlowControlIn = flowcontrol;
    }

    public void setFlowControlIn(String flowcontrol) throws IllegalArgumentException {
        if (!SerialParameterValidator.isFlowControlValid(flowcontrol)) {
            throw new IllegalArgumentException("flowcontrolIn string '" + flowcontrol + "' unknown");
        }
        this.setFlowControlIn(this.stringToFlow(flowcontrol));
    }

    public int getFlowControlIn() {
        return this.m_FlowControlIn;
    }

    public String getFlowControlInString() {
        return this.flowToString(this.m_FlowControlIn);
    }

    public void setFlowControlOut(int flowControlOut) throws IllegalArgumentException {
        if (!SerialParameterValidator.isFlowControlValid(flowControlOut)) {
            throw new IllegalArgumentException("flowcontrol int '" + flowControlOut + "' unknown");
        }
        this.m_FlowControlOut = flowControlOut;
    }

    public void setFlowControlOut(String flowControlOut) throws IllegalArgumentException {
        if (!SerialParameterValidator.isFlowControlValid(flowControlOut)) {
            throw new IllegalArgumentException("flowcontrol string '" + flowControlOut + "' unknown");
        }
        this.m_FlowControlOut = this.stringToFlow(flowControlOut);
    }

    public int getFlowControlOut() {
        return this.m_FlowControlOut;
    }

    public String getFlowControlOutString() {
        return this.flowToString(this.m_FlowControlOut);
    }

    public void setDatabits(int databits) throws IllegalArgumentException {
        if (!SerialParameterValidator.isDataBitsValid(databits)) {
            throw new IllegalArgumentException("Databit '" + databits + "' invalid");
        }
        switch (databits) {
            case 5: {
                this.m_Databits = 5;
                break;
            }
            case 6: {
                this.m_Databits = 6;
                break;
            }
            case 7: {
                this.m_Databits = 7;
                break;
            }
            case 8: {
                this.m_Databits = 8;
                break;
            }
            default: {
                this.m_Databits = 8;
            }
        }
    }

    public void setDatabits(String databits) throws IllegalArgumentException {
        int intDataBits = 0;
        try {
            intDataBits = Integer.parseInt(databits);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("databitsString '" + databits + "' can not be converted to a number: " + e.getMessage());
        }
        this.setDatabits(intDataBits);
    }

    public int getDatabits() {
        return this.m_Databits;
    }

    public String getDatabitsString() {
        switch (this.m_Databits) {
            case 5: {
                return "5";
            }
            case 6: {
                return "6";
            }
            case 7: {
                return "7";
            }
            case 8: {
                return "8";
            }
        }
        return "8";
    }

    public void setStopbits(double stopbits) throws IllegalArgumentException {
        if (!SerialParameterValidator.isStopbitsValid(stopbits)) {
            throw new IllegalArgumentException("stopbit value '" + stopbits + "' not valid");
        }
        this.m_Stopbits = stopbits == 1.0 ? 1 : (stopbits == 1.5 ? 3 : (stopbits == 2.0 ? 2 : 1));
    }

    public void setStopbits(String stopbits) throws IllegalArgumentException {
        double doubleStopBits = 1.0;
        try {
            doubleStopBits = Double.parseDouble(stopbits);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("stopbitsString '" + stopbits + "' can not be converted to a number: " + e.getMessage());
        }
        this.setStopbits(doubleStopBits);
    }

    public int getStopbits() {
        return this.m_Stopbits;
    }

    public String getStopbitsString() {
        switch (this.m_Stopbits) {
            case 1: {
                return "1";
            }
            case 3: {
                return "1.5";
            }
            case 2: {
                return "2";
            }
        }
        return "1";
    }

    public void setParity(int parity) {
        if (!SerialParameterValidator.isParityValid(parity)) {
            throw new IllegalArgumentException("parity value '" + parity + "' not valid");
        }
        this.m_Parity = parity;
    }

    public void setParity(String parity) throws IllegalArgumentException {
        parity = parity.toLowerCase();
        int intParity = 0;
        if (parity.equals("none") || parity.equals("n")) {
            intParity = 0;
        } else if (parity.equals("even") || parity.equals("e")) {
            intParity = 2;
        } else if (parity.equals("odd") || parity.equals("o")) {
            intParity = 1;
        } else {
            throw new IllegalArgumentException("unknown parity string '" + parity + "'");
        }
        this.setParity(intParity);
    }

    public int getParity() {
        return this.m_Parity;
    }

    public String getParityString() {
        switch (this.m_Parity) {
            case 0: {
                return "none";
            }
            case 2: {
                return "even";
            }
            case 1: {
                return "odd";
            }
        }
        return "none";
    }

    public void setEncoding(String enc) throws IllegalArgumentException {
        if (!SerialParameterValidator.isEncodingValid(enc = enc.toLowerCase())) {
            throw new IllegalArgumentException("encoding value '" + enc + "' not valid");
        }
        this.m_Encoding = enc;
    }

    public String getEncoding() {
        return this.m_Encoding;
    }

    public boolean isEcho() {
        return this.m_Echo;
    }

    public void setEcho(boolean newEcho) {
        this.m_Echo = newEcho;
    }

    public int getReceiveTimeoutMillis() {
        return this.m_ReceiveTimeoutMillis;
    }

    public void setReceiveTimeoutMillis(int receiveTimeout) {
        if (!SerialParameterValidator.isReceiveTimeoutValid(receiveTimeout)) {
            throw new IllegalArgumentException("negative values like '" + receiveTimeout + "' invalid as timeout");
        }
        this.m_ReceiveTimeoutMillis = receiveTimeout;
    }

    public void setReceiveTimeoutMillis(String str) {
        this.setReceiveTimeoutMillis(Integer.parseInt(str));
    }

    private int stringToFlow(String flowcontrol) {
        if ((flowcontrol = flowcontrol.toLowerCase()).equals("none")) {
            return 0;
        }
        if (flowcontrol.equals("xon/xoff out")) {
            return 8;
        }
        if (flowcontrol.equals("xon/xoff in")) {
            return 4;
        }
        if (flowcontrol.equals("rts/cts in")) {
            return 1;
        }
        if (flowcontrol.equals("rts/cts out")) {
            return 2;
        }
        return 0;
    }

    private String flowToString(int flowcontrol) {
        switch (flowcontrol) {
            case 0: {
                return "none";
            }
            case 8: {
                return "xon/xoff out";
            }
            case 4: {
                return "xon/xoff in";
            }
            case 1: {
                return "rts/cts in";
            }
            case 2: {
                return "rts/cts out";
            }
        }
        return "none";
    }
}

