/*
 * Decompiled with CFR 0.152.
 */
package org.kamranzafar.commons.cloner;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.kamranzafar.commons.cloner.CloningException;
import org.kamranzafar.commons.cloner.CloningStrategy;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public class ReflectionCloningStrategy<T>
implements CloningStrategy<T> {
    private final Objenesis objenesis;
    private final Set<Class<?>> ignoredClasses = new HashSet();
    private final Map<Object, Boolean> ignoredInstances = new IdentityHashMap<Object, Boolean>();
    private final ConcurrentHashMap<Class<?>, List<Field>> fieldsMap = new ConcurrentHashMap();

    public ReflectionCloningStrategy() {
        this.objenesis = new ObjenesisStd();
        this.init();
    }

    protected void init() {
        this.ignoreKnownJdkImmutableClasses();
    }

    protected void ignoreConstant(Class<?> c, String privateFieldName) {
        try {
            final Field field = c.getDeclaredField(privateFieldName);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    field.setAccessible(true);
                    return null;
                }
            });
            Object v = field.get(null);
            this.ignoredInstances.put(v, true);
        }
        catch (Throwable e) {
            throw new CloningException(e.getMessage(), e);
        }
    }

    protected void ignoreKnownJdkImmutableClasses() {
        this.ignoreClass(Integer.class, Long.class, Boolean.class, Class.class, Float.class, Double.class, Character.class, Byte.class, Short.class, Void.class, BigDecimal.class, BigInteger.class, URI.class, URL.class, UUID.class, Pattern.class);
    }

    protected void ignoreClass(Class<?> ... clazz) {
        for (Class<?> c : clazz) {
            this.ignoredClasses.add(c);
        }
    }

    protected <T> T newInstance(Class<T> c) {
        return this.objenesis.newInstance(c);
    }

    @Override
    public T deepClone(T original) {
        if (original == null) {
            return null;
        }
        IdentityHashMap<Object, Object> clones = new IdentityHashMap<Object, Object>();
        try {
            return this.clone(original, clones);
        }
        catch (IllegalAccessException e) {
            throw new CloningException("Error during cloning of " + original, e);
        }
    }

    @Override
    public T shallowClone(T original) {
        if (original == null) {
            return null;
        }
        try {
            return this.clone(original, null);
        }
        catch (IllegalAccessException e) {
            throw new CloningException("Error during cloning of " + original, e);
        }
    }

    protected <T> T clone(T original, Map<Object, Object> clones) throws IllegalAccessException {
        if (original == null) {
            return null;
        }
        Class<?> clz = original.getClass();
        if (this.ignoredInstances.containsKey(original) || clz.isEnum() || this.ignoredClasses.contains(clz)) {
            return original;
        }
        if (clones != null && clones.get(original) != null) {
            return (T)clones.get(original);
        }
        if (clz.isArray()) {
            int length = Array.getLength(original);
            Object newInstance = Array.newInstance(clz.getComponentType(), length);
            clones.put(original, newInstance);
            for (int i = 0; i < length; ++i) {
                Object v = Array.get(original, i);
                Object clone = clones != null ? this.clone(v, clones) : v;
                Array.set(newInstance, i, clone);
            }
            return (T)newInstance;
        }
        Object newInstance = this.newInstance(clz);
        if (clones != null) {
            clones.put(original, newInstance);
        }
        List<Field> fields2 = this.allFields(clz);
        for (Field field : fields2) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            Object fieldObject = field.get(original);
            Object fieldObjectClone = clones != null ? this.clone(fieldObject, clones) : fieldObject;
            field.set(newInstance, fieldObjectClone);
        }
        return (T)newInstance;
    }

    protected void addAll(List<Field> l, Field[] fields2) {
        for (Field field : fields2) {
            l.add(field);
        }
    }

    protected List<Field> allFields(Class<?> c) {
        List<Field> l = this.fieldsMap.get(c);
        if (l == null) {
            l = new LinkedList<Field>();
            Field[] fields2 = c.getDeclaredFields();
            this.addAll(l, fields2);
            Class<?> sc = c;
            while ((sc = sc.getSuperclass()) != Object.class && sc != null) {
                this.addAll(l, sc.getDeclaredFields());
            }
            this.fieldsMap.putIfAbsent(c, l);
        }
        return l;
    }
}

