/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.xml.splitter;

import java.io.IOException;
import org.jxmpp.xml.splitter.XmlPrinter;
import org.jxmpp.xml.splitter.XmlSplitter;

public class XmlPrettyPrinter
extends XmlPrinter {
    private final int indent;
    private final int attributeIndent;
    private final int tabWidth;
    private final PrettyPrintedXmlChunkWithCurrentPartCallback newChunkCallback;
    private final PrettyPrintedXmlPartCallback newPartCallback;
    private final PrettyPrintedXmlChunkSink prettyWriter;
    private StringBuilder currentPart;
    private StringBuilder currentChunk;
    private StringBuilder currentChunkWithCurrentPart;

    public XmlPrettyPrinter(PrettyPrintedXmlPartCallback partCallback) {
        this(XmlPrettyPrinter.builder().setPartCallback(partCallback));
    }

    public XmlPrettyPrinter(PrettyPrintedXmlChunkSink prettyWriter) {
        this(XmlPrettyPrinter.builder().setPrettyWriter(prettyWriter));
    }

    private XmlPrettyPrinter(Builder builder) {
        this.indent = builder.indent;
        this.attributeIndent = builder.attributeIndent;
        this.tabWidth = builder.tabWidth;
        this.newChunkCallback = builder.newChunkCallback;
        this.newPartCallback = builder.newPartCallback;
        this.prettyWriter = builder.prettyWriter;
    }

    @Override
    void onChunkStart() {
        if (this.newChunkCallback != null) {
            this.currentChunkWithCurrentPart = new StringBuilder(this.currentPart.length() + 1024);
            this.currentChunkWithCurrentPart.append((CharSequence)this.currentPart);
            this.currentChunkWithCurrentPart.append('[');
        }
        if (this.prettyWriter != null) {
            this.currentChunk = new StringBuilder(1024);
        }
    }

    @Override
    void onChunkEnd() {
        if (this.newChunkCallback != null) {
            this.currentChunkWithCurrentPart.append(']');
            this.newChunkCallback.onPrettyPrintedXmlChunk(this.currentChunkWithCurrentPart);
            this.currentChunkWithCurrentPart = null;
        }
        if (this.prettyWriter != null) {
            this.prettyWriter.sink(this.currentChunk);
            this.currentChunk = null;
        }
    }

    @Override
    void onNextChar(char c, int depth, XmlSplitter.State initialState, XmlSplitter.State currentState) throws IOException {
        boolean stateChange = initialState != currentState;
        StringBuilder sb = new StringBuilder(stateChange ? 16 : 1);
        if (stateChange) {
            boolean deferredLeftAngle = false;
            int indent = 0;
            switch (currentState) {
                case TAG_LEFT_ANGLE_BRACKET: {
                    return;
                }
                case END_TAG_SOLIDUS: {
                    indent = this.getElementIndent(depth - 1);
                    deferredLeftAngle = true;
                    break;
                }
                case IN_TAG_NAME: {
                    indent = this.getElementIndent(depth);
                    deferredLeftAngle = true;
                    break;
                }
                case IN_ATTRIBUTE_NAME: {
                    if (this.attributeIndent <= 0) break;
                    indent = this.getAttributeIndent(depth);
                    break;
                }
                case START: {
                    indent = this.getElementIndent(depth);
                }
            }
            if (indent > 0 || deferredLeftAngle) {
                sb.append('\n');
            }
            this.appendIndent(sb, indent);
            if (deferredLeftAngle) {
                sb.append('<');
            }
        }
        sb.append(c);
        if (this.currentChunkWithCurrentPart != null) {
            this.currentChunkWithCurrentPart.append((CharSequence)sb);
        }
        if (this.newPartCallback != null) {
            if (this.currentPart == null) {
                this.currentPart = new StringBuilder(1024);
            }
            this.currentPart.append((CharSequence)sb);
        }
        if (this.prettyWriter != null) {
            this.currentChunk.append((CharSequence)sb);
        }
    }

    @Override
    void onCompleteElement() {
        if (this.newPartCallback == null) {
            return;
        }
        if (this.currentPart.charAt(0) == '\n') {
            this.currentPart.deleteCharAt(0);
        }
        this.newPartCallback.onPrettyPrintedXmlPart(this.currentPart);
        this.currentPart = null;
    }

    private int getElementIndent(int depth) {
        return this.indent * depth;
    }

    private int getAttributeIndent(int depth) {
        return this.getElementIndent(depth) + this.attributeIndent;
    }

    private void appendIndent(StringBuilder sb, int indent) {
        int spaces = indent;
        if (this.tabWidth > 0) {
            spaces = indent % this.tabWidth;
            int tabs = indent / this.tabWidth;
            for (int i = 0; i < tabs; ++i) {
                sb.append('\t');
            }
        }
        for (int i = 0; i < spaces; ++i) {
            sb.append(' ');
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int indent = 2;
        private int attributeIndent;
        private int tabWidth;
        private PrettyPrintedXmlChunkWithCurrentPartCallback newChunkCallback;
        private PrettyPrintedXmlPartCallback newPartCallback;
        private PrettyPrintedXmlChunkSink prettyWriter;

        private Builder() {
        }

        public Builder setIndent(int indent) {
            Builder.ensureNotNegative(indent);
            this.indent = indent;
            return this;
        }

        public Builder setAttributeIndent(int attributeIndent) {
            Builder.ensureNotNegative(attributeIndent);
            this.attributeIndent = attributeIndent;
            return this;
        }

        public Builder setTabWidth(int tabWidth) {
            Builder.ensureNotNegative(tabWidth);
            this.tabWidth = tabWidth;
            return this;
        }

        public Builder setChunkCallback(PrettyPrintedXmlChunkWithCurrentPartCallback chunkCallback) {
            this.newChunkCallback = chunkCallback;
            return this;
        }

        public Builder setPartCallback(PrettyPrintedXmlPartCallback partCallback) {
            this.newPartCallback = partCallback;
            return this;
        }

        public Builder setPrettyWriter(PrettyPrintedXmlChunkSink prettyWriter) {
            this.prettyWriter = prettyWriter;
            return this;
        }

        public XmlPrettyPrinter build() {
            return new XmlPrettyPrinter(this);
        }

        private static void ensureNotNegative(int i) {
            if (i < 0) {
                throw new IllegalArgumentException();
            }
        }
    }

    public static interface PrettyPrintedXmlChunkSink {
        public void sink(StringBuilder var1);
    }

    public static interface PrettyPrintedXmlPartCallback {
        public void onPrettyPrintedXmlPart(StringBuilder var1);
    }

    public static interface PrettyPrintedXmlChunkWithCurrentPartCallback {
        public void onPrettyPrintedXmlChunk(StringBuilder var1);
    }
}

