/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.xdata.provider.DescriptionProvider;
import org.jivesoftware.smackx.xdata.provider.FormFieldChildElementProviderManager;
import org.jxmpp.jid.Jid;

public final class XDataManager
extends Manager {
    public static final String NAMESPACE = "jabber:x:data";
    private static final Map<XMPPConnection, XDataManager> INSTANCES;

    public static synchronized XDataManager getInstanceFor(XMPPConnection connection) {
        XDataManager xDataManager = INSTANCES.get(connection);
        if (xDataManager == null) {
            xDataManager = new XDataManager(connection);
            INSTANCES.put(connection, xDataManager);
        }
        return xDataManager;
    }

    private XDataManager(XMPPConnection connection) {
        super(connection);
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        serviceDiscoveryManager.addFeature(NAMESPACE);
    }

    public boolean isSupported(Jid jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(jid, NAMESPACE);
    }

    static {
        FormFieldChildElementProviderManager.addFormFieldChildElementProvider(new DescriptionProvider());
        XMPPConnectionRegistry.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection connection) {
                XDataManager.getInstanceFor(connection);
            }
        });
        INSTANCES = new WeakHashMap<XMPPConnection, XDataManager>();
    }
}

