/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.usertune.element;

import java.net.URI;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.util.XmlStringBuilder;

public final class UserTuneElement
implements ExtensionElement {
    public static final String NAMESPACE = "http://jabber.org/protocol/tune";
    public static final String ELEMENT = "tune";
    public static final QName QNAME = new QName("http://jabber.org/protocol/tune", "tune");
    private final String artist;
    private final UInt16 length;
    private final Integer rating;
    private final String source;
    private final String title;
    private final String track;
    private final URI uri;
    public static final UserTuneElement EMPTY_USER_TUNE = null;

    private UserTuneElement(Builder builder) {
        this.artist = builder.artist;
        this.length = builder.length;
        this.rating = builder.rating;
        this.source = builder.source;
        this.title = builder.title;
        this.track = builder.track;
        this.uri = builder.uri;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    public String getArtist() {
        return this.artist;
    }

    public UInt16 getLength() {
        return this.length;
    }

    public Integer getRating() {
        return this.rating;
    }

    public String getSource() {
        return this.source;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTrack() {
        return this.track;
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        XmlStringBuilder xml = new XmlStringBuilder(this);
        if (this.isEmptyUserTune()) {
            return xml.closeEmptyElement();
        }
        xml.rightAngleBracket();
        xml.optElement("artist", this.artist);
        xml.optElement("length", this.length);
        xml.optElement("rating", this.rating);
        xml.optElement("source", this.source);
        xml.optElement("title", this.title);
        xml.optElement("track", this.track);
        xml.optElement("uri", this.uri);
        return xml.closeElement(this.getElementName());
    }

    private boolean isEmptyUserTune() {
        return this.equals(EMPTY_USER_TUNE);
    }

    public static boolean hasUserTuneElement(Message message) {
        return message.hasExtension(UserTuneElement.class);
    }

    public static UserTuneElement from(Message message) {
        return message.getExtension(UserTuneElement.class);
    }

    public int hashCode() {
        return HashCode.builder().append(this.artist).append(this.length).append(this.rating).append(this.source).append(this.title).append(this.track).append(this.uri).build();
    }

    public boolean equals(Object obj) {
        return EqualsUtil.equals(this, obj, (equalsBuilder, otherTune) -> equalsBuilder.append(this.artist, otherTune.artist).append(this.length, otherTune.length).append(this.rating, otherTune.rating).append(this.source, otherTune.source).append(this.title, otherTune.title).append(this.track, otherTune.track).append(this.uri, otherTune.uri));
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String artist;
        private UInt16 length;
        private Integer rating;
        private String source;
        private String title;
        private String track;
        private URI uri;

        private Builder() {
        }

        public Builder setArtist(String artist) {
            this.artist = artist;
            return this;
        }

        public Builder setLength(int length) {
            return this.setLength(UInt16.from(length));
        }

        public Builder setLength(UInt16 length) {
            this.length = length;
            return this;
        }

        public Builder setRating(int rating) {
            this.rating = rating;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setTrack(String track) {
            this.track = track;
            return this;
        }

        public Builder setUri(URI uri) {
            this.uri = uri;
            return this;
        }

        public UserTuneElement build() {
            return new UserTuneElement(this);
        }
    }
}

