/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mediaelement.element;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.FormFieldChildElement;

public class MediaElement
implements FormFieldChildElement {
    public static final String ELEMENT = "media";
    public static final String NAMESPACE = "urn:xmpp:media-element";
    public static final QName QNAME = new QName("urn:xmpp:media-element", "media");
    private final UInt16 height;
    private final UInt16 width;
    private final List<Uri> uris;

    public MediaElement(Builder builder) {
        this.height = builder.height;
        this.width = builder.width;
        this.uris = Collections.unmodifiableList(builder.uris);
    }

    public UInt16 getHeight() {
        return this.height;
    }

    public UInt16 getWidth() {
        return this.width;
    }

    public List<Uri> getUris() {
        return this.uris;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public QName getQName() {
        return QNAME;
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        XmlStringBuilder xml = new XmlStringBuilder(this, xmlEnvironment);
        xml.optAttributeCs("height", this.height).optAttributeCs("width", this.width).rightAngleBracket();
        xml.append(this.uris);
        xml.closeElement(this);
        return xml;
    }

    public MediaElement from(FormField formField) {
        return (MediaElement)formField.getFormFieldChildElement(QNAME);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Uri
    implements FullyQualifiedElement {
        public static final String ELEMENT = "uri";
        public static final QName QNAME = new QName("urn:xmpp:media-element", "uri");
        private final URI uri;
        private final String type;

        public Uri(URI uri, String type2) {
            this.uri = Objects.requireNonNull(uri);
            this.type = StringUtils.requireNotNullNorEmpty(type2, "The 'type' argument must not be null or empty");
        }

        public URI getUri() {
            return this.uri;
        }

        public String getType() {
            return this.type;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }

        @Override
        public String getNamespace() {
            return MediaElement.NAMESPACE;
        }

        @Override
        public QName getQName() {
            return QNAME;
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xml = new XmlStringBuilder(this, xmlEnvironment);
            xml.attribute("type", this.type).rightAngleBracket();
            xml.escape(this.uri.toString());
            xml.closeElement(this);
            return xml;
        }
    }

    public static final class Builder {
        private UInt16 height;
        private UInt16 width;
        private List<Uri> uris = new ArrayList<Uri>();

        public Builder setHeightAndWidth(int height, int width) {
            return this.setHeightAndWidth(UInt16.from(height), UInt16.from(width));
        }

        public Builder setHeightAndWidth(UInt16 height, UInt16 width) {
            this.height = height;
            this.width = width;
            return this;
        }

        public Builder addUri(URI uri, String type2) {
            return this.addUri(new Uri(uri, type2));
        }

        public Builder addUri(Uri uri) {
            this.uris.add(uri);
            return this;
        }

        public MediaElement build() {
            return new MediaElement(this);
        }
    }
}

