/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp.muc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.auth.AuthenticationAuthority;
import org.jitsi.jicofo.auth.AuthenticationListener;
import org.jitsi.jicofo.xmpp.muc.ChatRoom;
import org.jitsi.jicofo.xmpp.muc.ChatRoomMember;
import org.jitsi.jicofo.xmpp.muc.ChatRoomRoleManager;
import org.jitsi.jicofo.xmpp.muc.MemberRole;
import org.jitsi.jicofo.xmpp.muc.MemberRoleKt;
import org.jitsi.utils.OrderedJsonObject;
import org.jxmpp.jid.Jid;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jitsi/jicofo/xmpp/muc/AuthenticationRoleManager;", "Lorg/jitsi/jicofo/xmpp/muc/ChatRoomRoleManager;", "chatRoom", "Lorg/jitsi/jicofo/xmpp/muc/ChatRoom;", "authenticationAuthority", "Lorg/jitsi/jicofo/auth/AuthenticationAuthority;", "(Lorg/jitsi/jicofo/xmpp/muc/ChatRoom;Lorg/jitsi/jicofo/auth/AuthenticationAuthority;)V", "authenticationListener", "Lorg/jitsi/jicofo/auth/AuthenticationListener;", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "getDebugState", "()Lorg/jitsi/utils/OrderedJsonObject;", "grantOwnerToAuthenticatedUsers", "", "grantOwnership", "localRoleChanged", "newRole", "Lorg/jitsi/jicofo/xmpp/muc/MemberRole;", "memberJoined", "member", "Lorg/jitsi/jicofo/xmpp/muc/ChatRoomMember;", "stop", "jicofo"})
@SourceDebugExtension(value={"SMAP\nChatRoomRoleManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatRoomRoleManager.kt\norg/jitsi/jicofo/xmpp/muc/AuthenticationRoleManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n766#2:172\n857#2,2:173\n1855#2,2:175\n1#3:177\n*S KotlinDebug\n*F\n+ 1 ChatRoomRoleManager.kt\norg/jitsi/jicofo/xmpp/muc/AuthenticationRoleManager\n*L\n138#1:172\n138#1:173,2\n140#1:175,2\n*E\n"})
public final class AuthenticationRoleManager
extends ChatRoomRoleManager {
    @NotNull
    private final AuthenticationAuthority authenticationAuthority;
    @NotNull
    private final AuthenticationListener authenticationListener;
    @NotNull
    private final OrderedJsonObject debugState;

    /*
     * WARNING - void declaration
     */
    public AuthenticationRoleManager(@NotNull ChatRoom chatRoom, @NotNull AuthenticationAuthority authenticationAuthority) {
        void $this$debugState_u24lambda_u249;
        OrderedJsonObject orderedJsonObject;
        Intrinsics.checkNotNullParameter(chatRoom, "chatRoom");
        Intrinsics.checkNotNullParameter(authenticationAuthority, "authenticationAuthority");
        super(chatRoom, null);
        this.authenticationAuthority = authenticationAuthority;
        this.authenticationListener = (arg_0, arg_1, arg_2) -> AuthenticationRoleManager.authenticationListener$lambda$3(chatRoom, this, arg_0, arg_1, arg_2);
        this.authenticationAuthority.addAuthenticationListener(this.authenticationListener);
        OrderedJsonObject orderedJsonObject2 = orderedJsonObject = new OrderedJsonObject();
        AuthenticationRoleManager authenticationRoleManager = this;
        boolean bl = false;
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string, "getSimpleName(...)");
        $this$debugState_u24lambda_u249.put("class", string);
        authenticationRoleManager.debugState = orderedJsonObject;
    }

    @Override
    public void grantOwnership() {
        this.getQueue().add(() -> AuthenticationRoleManager.grantOwnership$lambda$4(this));
    }

    /*
     * WARNING - void declaration
     */
    private final void grantOwnerToAuthenticatedUsers() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getChatRoom().getMembers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ChatRoomMember it = (ChatRoomMember)element$iv$iv;
            boolean bl = false;
            if (!(!MemberRoleKt.hasOwnerRights(it.getRole()) && this.authenticationAuthority.getSessionForJid(it.getJid()) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatRoomMember it = (ChatRoomMember)element$iv;
            boolean bl = false;
            this.getChatRoom().grantOwnership(it);
        }
    }

    @Override
    public void localRoleChanged(@NotNull MemberRole newRole) {
        Intrinsics.checkNotNullParameter((Object)newRole, "newRole");
        if (!MemberRoleKt.hasOwnerRights(newRole)) {
            this.getLogger().error("Local role has no owner rights, can not manage roles.");
            return;
        }
        this.getQueue().add(() -> AuthenticationRoleManager.localRoleChanged$lambda$7(this));
    }

    @Override
    public void memberJoined(@NotNull ChatRoomMember member) {
        Intrinsics.checkNotNullParameter(member, "member");
        if (member.getRole() != MemberRole.OWNER && this.authenticationAuthority.getSessionForJid(member.getJid()) != null) {
            this.getQueue().add(() -> AuthenticationRoleManager.memberJoined$lambda$8(this, member));
        }
    }

    @Override
    public void stop() {
        this.authenticationAuthority.removeAuthenticationListener(this.authenticationListener);
    }

    @Override
    @NotNull
    public OrderedJsonObject getDebugState() {
        return this.debugState;
    }

    private static final void authenticationListener$lambda$3$lambda$2$lambda$1(AuthenticationRoleManager this$0, ChatRoomMember $it, ChatRoom $chatRoom) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($it, "$it");
        Intrinsics.checkNotNullParameter($chatRoom, "$chatRoom");
        this$0.getLogger().info("Granting ownership to " + $it + ".");
        $chatRoom.grantOwnership($it);
    }

    private static final void authenticationListener$lambda$3(ChatRoom $chatRoom, AuthenticationRoleManager this$0, Jid userJid, String string, String string2) {
        block2: {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter($chatRoom, "$chatRoom");
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                Iterable iterable = $chatRoom.getMembers();
                for (Object t : iterable) {
                    ChatRoomMember it = (ChatRoomMember)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getJid(), userJid)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            ChatRoomMember chatRoomMember = v0;
            if (chatRoomMember == null) break block2;
            ChatRoomMember it = chatRoomMember;
            boolean bl = false;
            this$0.getQueue().add(() -> AuthenticationRoleManager.authenticationListener$lambda$3$lambda$2$lambda$1(this$0, it, $chatRoom));
        }
    }

    private static final void grantOwnership$lambda$4(AuthenticationRoleManager this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.grantOwnerToAuthenticatedUsers();
    }

    private static final void localRoleChanged$lambda$7(AuthenticationRoleManager this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.grantOwnerToAuthenticatedUsers();
    }

    private static final void memberJoined$lambda$8(AuthenticationRoleManager this$0, ChatRoomMember $member) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($member, "$member");
        this$0.getChatRoom().grantOwnership($member);
    }
}

