/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.ExplodedDirectoryModuleExtension;
import org.jetbrains.jps.model.java.JavaModuleIndex;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JdkVersionDetector;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaDependencyExtension;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaModuleExtension;
import org.jetbrains.jps.model.java.JpsJavaProjectExtension;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.JpsJavaSdkTypeWrapper;
import org.jetbrains.jps.model.java.JpsProductionModuleOutputPackagingElement;
import org.jetbrains.jps.model.java.JpsProductionModuleSourcePackagingElement;
import org.jetbrains.jps.model.java.JpsTestModuleOutputPackagingElement;
import org.jetbrains.jps.model.java.LanguageLevel;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.impl.ExplodedDirectoryModuleExtensionImpl;
import org.jetbrains.jps.model.java.impl.JavaModuleExtensionRole;
import org.jetbrains.jps.model.java.impl.JavaModuleIndexRole;
import org.jetbrains.jps.model.java.impl.JavaProjectExtensionRole;
import org.jetbrains.jps.model.java.impl.JavaSdkUtil;
import org.jetbrains.jps.model.java.impl.JpsJavaAwareProject;
import org.jetbrains.jps.model.java.impl.JpsJavaDependenciesEnumeratorImpl;
import org.jetbrains.jps.model.java.impl.JpsJavaDependencyExtensionRole;
import org.jetbrains.jps.model.java.impl.JpsProductionModuleOutputPackagingElementImpl;
import org.jetbrains.jps.model.java.impl.JpsProductionModuleSourcePackagingElementImpl;
import org.jetbrains.jps.model.java.impl.JpsTestModuleOutputPackagingElementImpl;
import org.jetbrains.jps.model.java.impl.JpsWrappedJavaSdkReferenceImpl;
import org.jetbrains.jps.model.java.impl.compiler.JpsJavaCompilerConfigurationImpl;
import org.jetbrains.jps.model.java.impl.runConfiguration.JpsApplicationRunConfigurationPropertiesImpl;
import org.jetbrains.jps.model.java.runConfiguration.JpsApplicationRunConfigurationProperties;
import org.jetbrains.jps.model.java.runConfiguration.JpsApplicationRunConfigurationState;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsTestModuleProperties;
import org.jetbrains.jps.model.module.impl.JpsTestModulePropertiesImpl;
import org.jetbrains.jps.util.JpsPathUtil;

@ApiStatus.Internal
public class JpsJavaExtensionServiceImpl
extends JpsJavaExtensionService {
    @Override
    @NotNull
    public JpsJavaProjectExtension getOrCreateProjectExtension(@NotNull JpsProject project) {
        if (project == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(0);
        }
        JpsJavaProjectExtension jpsJavaProjectExtension = (JpsJavaProjectExtension)project.getContainer().getOrSetChild(JavaProjectExtensionRole.INSTANCE);
        if (jpsJavaProjectExtension == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(1);
        }
        return jpsJavaProjectExtension;
    }

    @Override
    @Nullable
    public JpsJavaProjectExtension getProjectExtension(@NotNull JpsProject project) {
        if (project == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(2);
        }
        return project.getContainer().getChild(JavaProjectExtensionRole.INSTANCE);
    }

    @Override
    @NotNull
    public JpsJavaModuleExtension getOrCreateModuleExtension(@NotNull JpsModule module) {
        if (module == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(3);
        }
        JpsJavaModuleExtension jpsJavaModuleExtension = (JpsJavaModuleExtension)module.getContainer().getOrSetChild(JavaModuleExtensionRole.INSTANCE);
        if (jpsJavaModuleExtension == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(4);
        }
        return jpsJavaModuleExtension;
    }

    @Override
    @NotNull
    public JpsJavaDependencyExtension getOrCreateDependencyExtension(@NotNull JpsDependencyElement dependency) {
        if (dependency == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(5);
        }
        JpsJavaDependencyExtension jpsJavaDependencyExtension = (JpsJavaDependencyExtension)dependency.getContainer().getOrSetChild(JpsJavaDependencyExtensionRole.INSTANCE);
        if (jpsJavaDependencyExtension == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(6);
        }
        return jpsJavaDependencyExtension;
    }

    @Override
    public JpsJavaDependencyExtension getDependencyExtension(@NotNull JpsDependencyElement dependency) {
        JpsModule module;
        if (dependency == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(7);
        }
        if ((module = dependency.getContainingModule()).getProject() instanceof JpsJavaAwareProject) {
            return ((JpsJavaAwareProject)module.getProject()).getJavaDependencyExtension(dependency);
        }
        return dependency.getContainer().getChild(JpsJavaDependencyExtensionRole.INSTANCE);
    }

    @Override
    @Nullable
    public JpsJavaModuleExtension getModuleExtension(@NotNull JpsModule module) {
        if (module == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(8);
        }
        if (module.getProject() instanceof JpsJavaAwareProject) {
            return ((JpsJavaAwareProject)module.getProject()).getJavaModuleExtension(module);
        }
        return module.getContainer().getChild(JavaModuleExtensionRole.INSTANCE);
    }

    @Override
    @NotNull
    public ExplodedDirectoryModuleExtension getOrCreateExplodedDirectoryExtension(@NotNull JpsModule module) {
        if (module == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(9);
        }
        ExplodedDirectoryModuleExtension explodedDirectoryModuleExtension = (ExplodedDirectoryModuleExtension)module.getContainer().getOrSetChild(ExplodedDirectoryModuleExtensionImpl.ExplodedDirectoryModuleExtensionRole.INSTANCE);
        if (explodedDirectoryModuleExtension == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(10);
        }
        return explodedDirectoryModuleExtension;
    }

    @Override
    @Nullable
    public ExplodedDirectoryModuleExtension getExplodedDirectoryExtension(@NotNull JpsModule module) {
        if (module == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(11);
        }
        return module.getContainer().getChild(ExplodedDirectoryModuleExtensionImpl.ExplodedDirectoryModuleExtensionRole.INSTANCE);
    }

    @Override
    @NotNull
    public List<JpsDependencyElement> getDependencies(JpsModule module, JpsJavaClasspathKind classpathKind, boolean exportedOnly) {
        ArrayList<JpsDependencyElement> result = new ArrayList<JpsDependencyElement>();
        for (JpsDependencyElement dependencyElement : module.getDependenciesList().getDependencies()) {
            JpsJavaDependencyExtension extension = this.getDependencyExtension(dependencyElement);
            if (extension != null && (!extension.getScope().isIncludedIn(classpathKind) || exportedOnly && !extension.isExported())) continue;
            result.add(dependencyElement);
        }
        ArrayList<JpsDependencyElement> arrayList = result;
        if (arrayList == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @Override
    public LanguageLevel getLanguageLevel(JpsModule module) {
        JpsJavaModuleExtension moduleExtension = this.getModuleExtension(module);
        if (moduleExtension == null) {
            return null;
        }
        LanguageLevel languageLevel = moduleExtension.getLanguageLevel();
        if (languageLevel != null) {
            return languageLevel;
        }
        JpsJavaProjectExtension projectExtension = this.getProjectExtension(module.getProject());
        return projectExtension != null ? projectExtension.getLanguageLevel() : null;
    }

    @Override
    public String getOutputUrl(JpsModule module, boolean forTests) {
        JpsJavaModuleExtension extension = this.getModuleExtension(module);
        if (extension == null) {
            return null;
        }
        if (extension.isInheritOutput()) {
            JpsJavaProjectExtension projectExtension = this.getProjectExtension(module.getProject());
            if (projectExtension == null) {
                return null;
            }
            String url = projectExtension.getOutputUrl();
            if (url == null) {
                return null;
            }
            return url + "/" + (forTests ? "test" : "production") + "/" + module.getName();
        }
        return forTests ? extension.getTestOutputUrl() : extension.getOutputUrl();
    }

    @Override
    @Nullable
    public File getOutputDirectory(JpsModule module, boolean forTests) {
        String url = this.getOutputUrl(module, forTests);
        return url != null ? JpsPathUtil.urlToFile(url) : null;
    }

    @Override
    @Nullable
    public Path getOutputDirectoryPath(JpsModule module, boolean forTests) {
        String url = this.getOutputUrl(module, forTests);
        return url != null ? JpsPathUtil.urlToNioPath(url) : null;
    }

    @Override
    @Nullable
    public Path findSourceFile(@NotNull JpsModuleSourceRoot root, @NotNull String relativePath) {
        Path result;
        String normalizedRelativePath;
        JpsElement properties;
        String prefix;
        Object normalizedPrefix;
        if (root == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(13);
        }
        if (relativePath == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(14);
        }
        if (!((String)(normalizedPrefix = StringUtil.trimStart((String)(prefix = (properties = root.getProperties()) instanceof JavaSourceRootProperties ? ((JavaSourceRootProperties)properties).getPackagePrefix().replace('.', '/') : (properties instanceof JavaResourceRootProperties ? ((JavaResourceRootProperties)properties).getRelativeOutputPath() : "")), (String)"/"))).isEmpty() && !((String)normalizedPrefix).endsWith("/")) {
            normalizedPrefix = (String)normalizedPrefix + "/";
        }
        if ((normalizedRelativePath = StringUtil.trimStart((String)relativePath, (String)"/")).startsWith((String)normalizedPrefix) && Files.exists(result = root.getPath().resolve(normalizedRelativePath.substring(((String)normalizedPrefix).length())), new LinkOption[0])) {
            return result;
        }
        return null;
    }

    @Override
    @Nullable
    public Path findSourceFileInProductionRoots(@NotNull JpsModule module, @NotNull String relativePath) {
        if (module == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(15);
        }
        if (relativePath == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(16);
        }
        for (JpsModuleSourceRoot root : module.getSourceRoots()) {
            Path file;
            if (root.getRootType().isForTests() || (file = this.findSourceFile(root, relativePath)) == null) continue;
            return file;
        }
        return null;
    }

    @Override
    public JpsTypedLibrary<JpsSdk<JpsDummyElement>> addJavaSdk(@NotNull JpsGlobal global, @NotNull String name, @NotNull String homePath) {
        if (global == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(17);
        }
        if (name == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(18);
        }
        if (homePath == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(19);
        }
        JdkVersionDetector.JdkVersionInfo jdkInfo = JdkVersionDetector.getInstance().detectJdkVersionInfo(homePath);
        assert (jdkInfo != null) : homePath;
        String version = JdkVersionDetector.formatVersionString(jdkInfo.version);
        JpsTypedLibrary<JpsSdk<JpsDummyElement>> sdk = global.addSdk(name, homePath, version, JpsJavaSdkType.INSTANCE);
        List<Path> roots = JavaSdkUtil.getJdkClassesRoots(Path.of(homePath, new String[0]), false);
        for (Path root : roots) {
            sdk.addRoot(root.toFile(), JpsOrderRootType.COMPILED);
        }
        return sdk;
    }

    @Override
    @NotNull
    public JpsJavaCompilerConfiguration getCompilerConfiguration(@NotNull JpsProject project) {
        if (project == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(20);
        }
        JpsJavaCompilerConfiguration jpsJavaCompilerConfiguration = (JpsJavaCompilerConfiguration)project.getContainer().getOrSetChild(JpsJavaCompilerConfigurationImpl.ROLE);
        if (jpsJavaCompilerConfiguration == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(21);
        }
        return jpsJavaCompilerConfiguration;
    }

    @Override
    @Nullable
    public JpsTestModuleProperties getTestModuleProperties(@NotNull JpsModule module) {
        if (module == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(22);
        }
        if (module.getProject() instanceof JpsJavaAwareProject) {
            return ((JpsJavaAwareProject)module.getProject()).getTestModuleProperties(module);
        }
        return module.getContainer().getChild(JpsTestModulePropertiesImpl.ROLE);
    }

    @Override
    public void setTestModuleProperties(@NotNull JpsModule module, @NotNull JpsModuleReference productionModuleReference) {
        if (module == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(23);
        }
        if (productionModuleReference == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(24);
        }
        module.getContainer().setChild(JpsTestModulePropertiesImpl.ROLE, new JpsTestModulePropertiesImpl(productionModuleReference));
    }

    @Override
    @NotNull
    public JpsSdkReference<JpsDummyElement> createWrappedJavaSdkReference(@NotNull JpsJavaSdkTypeWrapper sdkType, @NotNull JpsSdkReference<?> wrapperReference) {
        if (sdkType == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(25);
        }
        if (wrapperReference == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(26);
        }
        return new JpsWrappedJavaSdkReferenceImpl(sdkType, wrapperReference);
    }

    @Override
    @NotNull
    public JpsApplicationRunConfigurationProperties createRunConfigurationProperties(JpsApplicationRunConfigurationState state) {
        return new JpsApplicationRunConfigurationPropertiesImpl(state);
    }

    @Override
    @NotNull
    public JavaSourceRootProperties createSourceRootProperties(@NotNull String packagePrefix, boolean isGenerated) {
        if (packagePrefix == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(27);
        }
        return new JavaSourceRootProperties(packagePrefix, isGenerated);
    }

    @Override
    @NotNull
    public JavaSourceRootProperties createSourceRootProperties(@NotNull String packagePrefix) {
        if (packagePrefix == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(28);
        }
        JavaSourceRootProperties javaSourceRootProperties = this.createSourceRootProperties(packagePrefix, false);
        if (javaSourceRootProperties == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(29);
        }
        return javaSourceRootProperties;
    }

    @Override
    @NotNull
    public JavaResourceRootProperties createResourceRootProperties(@NotNull String relativeOutputPath, boolean forGeneratedResource) {
        if (relativeOutputPath == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(30);
        }
        return new JavaResourceRootProperties(relativeOutputPath, forGeneratedResource);
    }

    @Override
    @NotNull
    public JpsProductionModuleOutputPackagingElement createProductionModuleOutput(@NotNull JpsModuleReference moduleReference) {
        if (moduleReference == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(31);
        }
        return new JpsProductionModuleOutputPackagingElementImpl(moduleReference);
    }

    @Override
    @NotNull
    public JpsProductionModuleSourcePackagingElement createProductionModuleSource(@NotNull JpsModuleReference moduleReference) {
        if (moduleReference == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(32);
        }
        return new JpsProductionModuleSourcePackagingElementImpl(moduleReference);
    }

    @Override
    @NotNull
    public JpsTestModuleOutputPackagingElement createTestModuleOutput(@NotNull JpsModuleReference moduleReference) {
        if (moduleReference == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(33);
        }
        return new JpsTestModuleOutputPackagingElementImpl(moduleReference);
    }

    @Override
    public JpsJavaDependenciesEnumerator enumerateDependencies(Collection<JpsModule> modules) {
        return new JpsJavaDependenciesEnumeratorImpl(modules);
    }

    @Override
    protected JpsJavaDependenciesEnumerator enumerateDependencies(JpsProject project) {
        return new JpsJavaDependenciesEnumeratorImpl(project.getModules());
    }

    @Override
    protected JpsJavaDependenciesEnumerator enumerateDependencies(JpsModule module) {
        return new JpsJavaDependenciesEnumeratorImpl(Collections.singleton(module));
    }

    @Override
    @NotNull
    public JavaModuleIndex getJavaModuleIndex(@NotNull JpsProject project) {
        if (project == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(34);
        }
        JavaModuleIndex javaModuleIndex = (JavaModuleIndex)project.getContainer().getOrSetChild(JavaModuleIndexRole.INSTANCE, () -> this.getCompilerConfiguration(project).getCompilerExcludes());
        if (javaModuleIndex == null) {
            JpsJavaExtensionServiceImpl.$$$reportNull$$$0(35);
        }
        return javaModuleIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 10: 
            case 12: 
            case 21: 
            case 29: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 10: 
            case 12: 
            case 21: 
            case 29: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 10: 
            case 12: 
            case 21: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "global";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "productionModuleReference";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapperReference";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagePrefix";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeOutputPath";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/java/impl/JpsJavaExtensionServiceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateProjectExtension";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateModuleExtension";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDependencyExtension";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateExplodedDirectoryExtension";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerConfiguration";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createSourceRootProperties";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaModuleIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateProjectExtension";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 10: 
            case 12: 
            case 21: 
            case 29: 
            case 35: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProjectExtension";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateModuleExtension";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDependencyExtension";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyExtension";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getModuleExtension";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateExplodedDirectoryExtension";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getExplodedDirectoryExtension";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findSourceFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findSourceFileInProductionRoots";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addJavaSdk";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerConfiguration";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTestModuleProperties";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setTestModuleProperties";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createWrappedJavaSdkReference";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createSourceRootProperties";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createResourceRootProperties";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createProductionModuleOutput";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createProductionModuleSource";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createTestModuleOutput";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getJavaModuleIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 10: 
            case 12: 
            case 21: 
            case 29: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

