/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlDeclareIdInCommentAction
implements LocalQuickFix {
    private final String myId;

    public XmlDeclareIdInCommentAction(@NotNull String id) {
        if (id == null) {
            XmlDeclareIdInCommentAction.$$$reportNull$$$0(0);
        }
        this.myId = id;
    }

    @NotNull
    public String getFamilyName() {
        String string = XmlAnalysisBundle.message("xml.quickfix.declare.id.in.comment", new Object[0]);
        if (string == null) {
            XmlDeclareIdInCommentAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static String getImplicitlyDeclaredId(@NotNull PsiComment comment) {
        String text;
        if (comment == null) {
            XmlDeclareIdInCommentAction.$$$reportNull$$$0(2);
        }
        if ((text = XmlDeclareIdInCommentAction.getUncommentedText(comment)) == null) {
            return null;
        }
        if (text.startsWith("@declare id=\"")) {
            String result = text.substring("@declare id=\"".length() - 1);
            return StringUtil.unquoteString((String)result);
        }
        return null;
    }

    @Nullable
    private static String getUncommentedText(@NotNull PsiComment comment) {
        PsiFile psiFile;
        Language language;
        Commenter commenter;
        if (comment == null) {
            XmlDeclareIdInCommentAction.$$$reportNull$$$0(3);
        }
        if ((commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language = (psiFile = comment.getContainingFile()).getViewProvider().getBaseLanguage())) != null) {
            String text = comment.getText();
            String prefix = commenter.getBlockCommentPrefix();
            if (prefix != null && text.startsWith(prefix)) {
                text = text.substring(prefix.length());
                String suffix = commenter.getBlockCommentSuffix();
                if (suffix != null && text.length() > suffix.length()) {
                    return text.substring(0, text.length() - suffix.length()).trim();
                }
            }
        }
        return null;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            XmlDeclareIdInCommentAction.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            XmlDeclareIdInCommentAction.$$$reportNull$$$0(5);
        }
        PsiElement psiElement = descriptor.getPsiElement();
        PsiFile psiFile = psiElement.getContainingFile();
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{psiFile}).run(() -> {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class);
            if (tag == null) {
                return;
            }
            Language language = psiFile.getViewProvider().getBaseLanguage();
            Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
            if (commenter == null) {
                return;
            }
            String commentText = commenter.getBlockCommentPrefix() + "@declare id=\"" + this.myId + "\"" + commenter.getBlockCommentSuffix();
            XmlTag parent = tag.getParentTag();
            if (parent != null) {
                Document document = Objects.requireNonNull(psiFile.getViewProvider().getDocument());
                document.insertString(parent.getSubTags()[0].getTextRange().getStartOffset(), (CharSequence)commentText);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/XmlDeclareIdInCommentAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/XmlDeclareIdInCommentAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitlyDeclaredId";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUncommentedText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

