/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.ui.sunburst;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.ui.ProfilerUIUtilsKt;
import com.intellij.profiler.ui.sunburst.Sunburst;
import com.intellij.profiler.ui.sunburst.SunburstModel;
import com.intellij.profiler.ui.sunburst.SunburstSection;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.hprof.api.MuiInstance;
import com.intellij.profiler.ultimate.hprof.api.MuiSnapshot;
import com.intellij.profiler.ultimate.hprof.api.MuiType;
import com.intellij.profiler.ultimate.hprof.ui.sunburst.MyRenderer;
import com.intellij.profiler.ultimate.hprof.ui.sunburst.NavigationHistorySupport;
import com.intellij.profiler.ultimate.hprof.ui.sunburst.SunburstPanel;
import com.intellij.profiler.ultimate.hprof.ui.sunburst.SunburstPanelElement;
import com.intellij.profiler.ultimate.hprof.ui.sunburst.SunburstPanelModel;
import com.intellij.profiler.ultimate.hprof.ui.sunburst.SunburstZoomableViewport;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.components.ZoomableViewport;
import com.intellij.ui.components.breadcrumbs.Breadcrumbs;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.ui.hover.ListHoverListener;
import com.intellij.util.animation.Animation;
import com.intellij.util.animation.Animations;
import com.intellij.util.animation.Easing;
import com.intellij.util.animation.JBAnimator;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 $*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0005:\u0002$%B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u000eH\u0002J\u001a\u0010\u001c\u001a\u00020\u00162\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001eJ\u001c\u0010\u001f\u001a\u00020 2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001eH&J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u0017\u001a\u00020\u000eH\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/profiler/ultimate/hprof/ui/sunburst/SunburstPanel;", "T", "Lcom/intellij/profiler/ultimate/hprof/api/MuiType;", "I", "Lcom/intellij/profiler/ultimate/hprof/api/MuiInstance;", "Lcom/intellij/ui/components/JBPanelWithEmptyText;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "sunburst", "Lcom/intellij/profiler/ui/sunburst/Sunburst;", "Lcom/intellij/profiler/ultimate/hprof/ui/sunburst/SunburstPanelElement;", "breadcrumbs", "Lcom/intellij/ui/components/breadcrumbs/Breadcrumbs;", "list", "Lcom/intellij/ui/components/JBList;", "history", "Lcom/intellij/profiler/ultimate/hprof/ui/sunburst/NavigationHistorySupport;", "updateList", "", "element", "createActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "updateCrumbs", "value", "updateDiagram", "dump", "Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;", "doCalculate", "Lcom/intellij/profiler/ultimate/hprof/ui/sunburst/SunburstPanelModel;", "createPopupActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "Companion", "MyListener", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nSunburstPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SunburstPanel.kt\ncom/intellij/profiler/ultimate/hprof/ui/sunburst/SunburstPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,539:1\n1#2:540\n*E\n"})
public abstract class SunburstPanel<T extends MuiType, I extends MuiInstance>
extends JBPanelWithEmptyText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Sunburst<SunburstPanelElement> sunburst;
    @NotNull
    private final Breadcrumbs breadcrumbs;
    @NotNull
    private final JBList<SunburstPanelElement> list;
    @NotNull
    private final NavigationHistorySupport<SunburstPanelElement> history;
    public static final double DEFAULT_SIZE = 20.0;

    /*
     * WARNING - void declaration
     */
    public SunburstPanel(@NotNull Project project) {
        ActionToolbar actionToolbar;
        void $this$_init__u24lambda_u244;
        JScrollPane it;
        JScrollPane jScrollPane;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super((LayoutManager)new BorderLayout());
        this.project = project;
        this.sunburst = new Sunburst();
        this.breadcrumbs = new Breadcrumbs(){

            protected TextAttributes getAttributes(Crumb crumb) {
                Intrinsics.checkNotNullParameter((Object)crumb, (String)"crumb");
                TextAttributesKey key = this.getKey(crumb);
                return key == null ? null : EditorColorsManager.getInstance().getGlobalScheme().getAttributes(key);
            }

            private final TextAttributesKey getKey(Crumb crumb) {
                if (this.isHovered(crumb)) {
                    return EditorColors.BREADCRUMBS_HOVERED;
                }
                if (this.isSelected(crumb)) {
                    return EditorColors.BREADCRUMBS_CURRENT;
                }
                return this.isAfterSelected(crumb) ? EditorColors.BREADCRUMBS_INACTIVE : EditorColors.BREADCRUMBS_DEFAULT;
            }
        };
        this.list = new JBList();
        this.history = new NavigationHistorySupport(0, 1, null);
        this.sunburst.setThickness(20.0);
        this.sunburst.setBackground((Color)new JBColor(SunburstPanel::_init_$lambda$0));
        this.list.setCellRenderer((ListCellRenderer)new MyRenderer());
        this.list.setSelectionModel((ListSelectionModel)new DefaultListSelectionModel(){

            @Override
            public void setAnchorSelectionIndex(int anchorIndex) {
            }

            @Override
            public void setLeadAnchorNotificationEnabled(boolean flag) {
            }

            @Override
            public void setLeadSelectionIndex(int leadIndex) {
            }

            @Override
            public void setSelectionInterval(int index0, int index1) {
            }
        });
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SunburstPanelElement target;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getButton() != 1) {
                    return;
                }
                int index = ListHoverListener.getHoveredIndex((JList)((JList)list));
                if (index < 0 || index >= list.getModel().getSize()) {
                    v0 = null;
                } else if (index == 0) {
                    SunburstPanelElement sunburstPanelElement = (SunburstPanelElement)sunburst.getCenter();
                    v0 = sunburstPanelElement != null ? sunburstPanelElement.getParent() : null;
                } else if (index > 0) {
                    SunburstPanelElement sunburstPanelElement = (SunburstPanelElement)list.getModel().getElementAt(index);
                    if (sunburstPanelElement != null) {
                        SunburstPanelElement sunburstPanelElement2;
                        SunburstPanelElement it = sunburstPanelElement2 = sunburstPanelElement;
                        boolean bl = false;
                        v0 = it.getParent() != null ? sunburstPanelElement2 : null;
                    } else {
                        v0 = null;
                    }
                } else {
                    v0 = target = null;
                }
                if (target != null) {
                    sunburst.setCenter(target);
                    this.updateCrumbs(target);
                    this.updateList(target);
                    history.add(target);
                }
            }
        });
        ListHoverListener.DEFAULT.addTo((JComponent)this.list);
        OnePixelSplitter splitter = new OnePixelSplitter(false);
        splitter.getDivider().setOpaque(false);
        splitter.setFirstComponent((JComponent)new SunburstZoomableViewport<SunburstPanelElement>(this.sunburst));
        JScrollPane jScrollPane2 = jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)this.list), (boolean)true);
        Object object = splitter;
        boolean bl = false;
        it.setHorizontalScrollBarPolicy(31);
        object.setSecondComponent((JComponent)jScrollPane);
        splitter.setProportion(0.6f);
        this.add((Component)splitter, "Center");
        this.breadcrumbs.onSelect((arg_0, arg_1) -> SunburstPanel._init_$lambda$3((arg_0, arg_1) -> SunburstPanel._init_$lambda$2(this, arg_0, arg_1), arg_0, arg_1));
        this.breadcrumbs.setBorder(JBUI.Borders.customLineTop((Color)NamedColorUtil.getBoundsColor()));
        it = jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)this.breadcrumbs), (boolean)true);
        object = this;
        boolean bl2 = false;
        $this$_init__u24lambda_u244.setVerticalScrollBarPolicy(21);
        $this$_init__u24lambda_u244.getHorizontalScrollBar().setEnabled(false);
        object.add((Component)jScrollPane, (Object)"South");
        this.sunburst.onHover((arg_0, arg_1) -> SunburstPanel._init_$lambda$5(this, arg_0, arg_1));
        this.sunburst.onSelect((arg_0, arg_1) -> SunburstPanel._init_$lambda$7(this, arg_0, arg_1));
        ActionToolbar it2 = actionToolbar = ActionManager.getInstance().createActionToolbar("ProfilerSunburst", (ActionGroup)this.createActions(), false);
        boolean bl3 = false;
        it2.setTargetComponent((JComponent)((Object)this));
        it2.getComponent().setBorder(JBUI.Borders.compound((Border)IdeBorderFactory.createBorder((int)4), (Border)it2.getComponent().getBorder()));
        ActionToolbar actionToolbar2 = actionToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"also(...)");
        ActionToolbar toolbar = actionToolbar2;
        this.add(toolbar.getComponent(), "West");
        MyListener listener = new MyListener();
        listener.addTo((JComponent)this.list);
        this.sunburst.addMouseListener((MouseListener)listener);
        this.sunburst.addMouseMotionListener((MouseMotionListener)listener);
        this.sunburst.addMouseWheelListener((MouseWheelListener)listener);
        this.sunburst.putClientProperty((Object)Magnificator.CLIENT_PROPERTY_KEY, (Object)listener);
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000/\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001BA\u00128\u0010\u0002\u001a4\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0016RC\u0010\u0002\u001a4\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"com/intellij/profiler/ultimate/hprof/ui/sunburst/SunburstPanel$MyPopup", "Lcom/intellij/ui/PopupHandler;", "producer", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "x", "y", "Lcom/intellij/profiler/ultimate/hprof/ui/sunburst/SunburstPanelElement;", "<init>", "(Lcom/intellij/profiler/ultimate/hprof/ui/sunburst/SunburstPanel;Lkotlin/jvm/functions/Function2;)V", "getProducer", "()Lkotlin/jvm/functions/Function2;", "invokePopup", "", "comp", "Ljava/awt/Component;", "intellij.profiler.ultimate"})
        public final class MyPopup
        extends PopupHandler {
            private final Function2<Integer, Integer, SunburstPanelElement> producer;
            final /* synthetic */ SunburstPanel<T, I> this$0;

            public MyPopup(SunburstPanel<T, I> $receiver, Function2<? super Integer, ? super Integer, ? extends SunburstPanelElement> producer) {
                Intrinsics.checkNotNullParameter(producer, (String)"producer");
                this.this$0 = $receiver;
                this.producer = producer;
            }

            public final Function2<Integer, Integer, SunburstPanelElement> getProducer() {
                return this.producer;
            }

            public void invokePopup(Component comp, int x, int y) {
                List<AnAction> actions;
                Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                SunburstPanelElement element = (SunburstPanelElement)this.producer.invoke((Object)x, (Object)y);
                if (element != null && !((Collection)(actions = this.this$0.createPopupActions(element))).isEmpty()) {
                    JPopupMenu jPopupMenu;
                    JPopupMenu $this$invokePopup_u24lambda_u240 = jPopupMenu = ActionManager.getInstance().createActionPopupMenu("SunburstPanel", (ActionGroup)new DefaultActionGroup(actions)).getComponent();
                    boolean bl = false;
                    $this$invokePopup_u24lambda_u240.show(comp, x, y);
                }
            }
        }
        this.sunburst.addMouseListener((MouseListener)((Object)new MyPopup(this, (Function2<? super Integer, ? super Integer, ? extends SunburstPanelElement>)((Function2)(arg_0, arg_1) -> SunburstPanel._init_$lambda$9(this, arg_0, arg_1)))));
        this.list.addMouseListener((MouseListener)((Object)new MyPopup(this, (Function2<? super Integer, ? super Integer, ? extends SunburstPanelElement>)((Function2)(arg_0, arg_1) -> SunburstPanel._init_$lambda$10(this, arg_0, arg_1)))));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateList(SunburstPanelElement element) {
        if (element != null) {
            List<Object> values = null;
            Object[] objectArray = new SunburstPanelElement[]{element};
            values = CollectionsKt.mutableListOf((Object[])objectArray);
            SunburstModel model2 = this.sunburst.getModel();
            int count = model2.getChildCount((Object)element);
            for (int i = 0; i < count; ++i) {
                values.add(model2.getChild((Object)element, i));
            }
            Comparator comparator2 = ((Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    SunburstPanelElement p0 = (SunburstPanelElement)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(p0.getSize());
                    p0 = (SunburstPanelElement)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(p0.getSize()));
                }
            }).reversed();
            Intrinsics.checkNotNullExpressionValue(comparator2, (String)"reversed(...)");
            CollectionsKt.sortWith((List)values, comparator2);
            int limit = 12;
            if (values.size() > limit) {
                long l;
                SunburstPanelElement smaller = new SunburstPanelElement(UltimateProfilerBundleKt.profilerMessage("hprof.sunburst.tree.others", new Object[0]), null, 2, null);
                Iterable iterable = (Iterable)RangesKt.until((int)limit, (int)count);
                SunburstPanelElement sunburstPanelElement = smaller;
                long l2 = 0L;
                Iterator iterator2 = iterable.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    int n;
                    int n2 = n = ((IntIterator)iterator2).nextInt();
                    l = l2;
                    boolean bl = false;
                    long l3 = ((SunburstPanelElement)values.get((int)it)).getSize();
                    l2 = l + l3;
                }
                l = l2;
                sunburstPanelElement.setSize(l);
                values.add(limit - 1, smaller);
                values = values.subList(0, limit);
            }
            this.list.setModel((ListModel)JBList.createDefaultListModel((Iterable)values));
        } else {
            this.list.setModel((ListModel)JBList.createDefaultListModel((Object[])new SunburstPanelElement[0]));
        }
    }

    private final DefaultActionGroup createActions() {
        DefaultActionGroup defaultActionGroup;
        DefaultActionGroup $this$createActions_u24lambda_u2413 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        JBAnimator animator = new JBAnimator();
        Easing curve = SunburstPanel::createActions$lambda$13$lambda$12;
        Object object = AllIcons.General.Reset;
        $this$createActions_u24lambda_u2413.add((AnAction)new DumbAwareAction(this, (Icon)object){
            final /* synthetic */ SunburstPanel<T, I> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    SunburstPanelElement sunburstPanelElement = (SunburstPanelElement)SunburstPanel.access$getSunburst$p(this.this$0).getModel().getRoot();
                    if (sunburstPanelElement == null) break block0;
                    SunburstPanelElement sunburstPanelElement2 = sunburstPanelElement;
                    SunburstPanel<T, I> sunburstPanel = this.this$0;
                    SunburstPanelElement it = sunburstPanelElement2;
                    boolean bl = false;
                    SunburstPanel.access$getSunburst$p(sunburstPanel).setCenter((Object)it);
                    SunburstPanel.access$updateCrumbs(sunburstPanel, it);
                    SunburstPanel.access$updateList(sunburstPanel, it);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void update(AnActionEvent e) {
                void it;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Object[] objectArray = SunburstPanel.access$getSunburst$p(this.this$0).getModel();
                SunburstPanel<T, I> sunburstPanel = this.this$0;
                Object[] objectArray2 = objectArray;
                Presentation presentation = e.getPresentation();
                boolean bl = false;
                boolean bl2 = it.getRoot() != null && !Intrinsics.areEqual((Object)it.getRoot(), (Object)SunburstPanel.access$getSunburst$p(sunburstPanel).getCenter());
                presentation.setEnabled(bl2);
                Presentation presentation2 = e.getPresentation();
                objectArray = new Object[1];
                Object object = (SunburstPanelElement)SunburstPanel.access$getSunburst$p(this.this$0).getModel().getRoot();
                if (object == null || (object = ((SunburstPanelElement)object).getShortName()) == null) {
                    object = UltimateProfilerBundleKt.profilerMessage("hprof.object.view.na", new Object[0]);
                }
                objectArray[0] = object;
                presentation2.setText(UltimateProfilerBundleKt.profilerMessage("hprof.action.sunburst.history.home", objectArray));
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }
        });
        object = UltimateProfilerBundleKt.profilerMessage("hprof.action.sunburst.history.back", new Object[0]);
        Icon icon = AllIcons.Actions.Back;
        $this$createActions_u24lambda_u2413.add((AnAction)new DumbAwareAction(this, (String)object, icon){
            final /* synthetic */ SunburstPanel<T, I> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(AnActionEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    SunburstPanelElement sunburstPanelElement = (SunburstPanelElement)SunburstPanel.access$getHistory$p(this.this$0).getPrev();
                    if (sunburstPanelElement == null) break block0;
                    SunburstPanelElement sunburstPanelElement2 = sunburstPanelElement;
                    SunburstPanel<T, I> sunburstPanel = this.this$0;
                    SunburstPanelElement it = sunburstPanelElement2;
                    boolean bl = false;
                    SunburstPanel.access$getSunburst$p(sunburstPanel).setCenter((Object)it);
                    SunburstPanel.access$updateCrumbs(sunburstPanel, it);
                    SunburstPanel.access$updateList(sunburstPanel, it);
                }
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(SunburstPanel.access$getHistory$p(this.this$0).hasPrev());
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }
        });
        object = UltimateProfilerBundleKt.profilerMessage("hprof.action.sunburst.history.forward", new Object[0]);
        icon = AllIcons.Actions.Forward;
        $this$createActions_u24lambda_u2413.add((AnAction)new DumbAwareAction(this, (String)object, icon){
            final /* synthetic */ SunburstPanel<T, I> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(AnActionEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    SunburstPanelElement sunburstPanelElement = (SunburstPanelElement)SunburstPanel.access$getHistory$p(this.this$0).getNext();
                    if (sunburstPanelElement == null) break block0;
                    SunburstPanelElement sunburstPanelElement2 = sunburstPanelElement;
                    SunburstPanel<T, I> sunburstPanel = this.this$0;
                    SunburstPanelElement it = sunburstPanelElement2;
                    boolean bl = false;
                    SunburstPanel.access$getSunburst$p(sunburstPanel).setCenter((Object)it);
                    SunburstPanel.access$updateCrumbs(sunburstPanel, it);
                    SunburstPanel.access$updateList(sunburstPanel, it);
                }
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(SunburstPanel.access$getHistory$p(this.this$0).hasNext());
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }
        });
        object = UltimateProfilerBundleKt.profilerMessage("hprof.action.sunburst.restore", new Object[0]);
        icon = AllIcons.General.ActualZoom;
        $this$createActions_u24lambda_u2413.add((AnAction)new DumbAwareAction(this, animator, curve, (String)object, icon){
            private final Point zero;
            final /* synthetic */ SunburstPanel<T, I> this$0;
            final /* synthetic */ JBAnimator $animator;
            final /* synthetic */ Easing $curve;
            {
                this.this$0 = $receiver;
                this.$animator = $animator;
                this.$curve = $curve;
                super($super_call_param$1, null, $super_call_param$2);
                this.zero = new Point(0, 0);
            }

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(AnActionEvent e) {
                void $this$actionPerformed_u24lambda_u242;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Point from = SunburstPanel.access$getSunburst$p(this.this$0).shift();
                double thickness = SunburstPanel.access$getSunburst$p(this.this$0).getThickness();
                Animation[] animationArray = new Animation[1];
                Animation animation = new Animation(arg_0 -> createActions.1.4.actionPerformed$lambda$0(from, this.this$0, thickness, arg_0));
                Easing easing = this.$curve;
                SunburstPanel<T, I> sunburstPanel = this.this$0;
                Animation animation2 = animation;
                int n = 0;
                Animation[] animationArray2 = animationArray;
                JBAnimator jBAnimator = this.$animator;
                boolean bl = false;
                $this$actionPerformed_u24lambda_u242.setDuration(150);
                $this$actionPerformed_u24lambda_u242.setEasing(easing);
                $this$actionPerformed_u24lambda_u242.runWhenExpired(() -> createActions.1.4.actionPerformed$lambda$2$lambda$1(sunburstPanel));
                Unit unit = Unit.INSTANCE;
                animationArray2[n] = animation;
                jBAnimator.animate(animationArray);
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(!Intrinsics.areEqual((Object)this.zero, (Object)SunburstPanel.access$getSunburst$p(this.this$0).shift()) || !(SunburstPanel.access$getSunburst$p(this.this$0).getThickness() == 20.0));
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            private static final void actionPerformed$lambda$0(Point $from, SunburstPanel this$0, double $thickness, double it) {
                double x = (double)$from.x * (1.0 - it);
                double y = (double)$from.y * (1.0 - it);
                SunburstPanel.access$getSunburst$p(this$0).setThickness($thickness + it * (20.0 - $thickness));
                SunburstPanel.access$getSunburst$p(this$0).shift(MathKt.roundToInt((double)x), MathKt.roundToInt((double)y));
            }

            private static final void actionPerformed$lambda$2$lambda$1(SunburstPanel this$0) {
                SunburstPanel.access$getSunburst$p(this$0).shift(0, 0);
            }
        });
        object = CommonProfilerBundleKt.commonProfilerMessage((String)"ui.flamechart.actions.zoomIn", (Object[])new Object[0]);
        icon = AllIcons.General.ZoomIn;
        $this$createActions_u24lambda_u2413.add((AnAction)new DumbAwareAction(animator, this, curve, (String)object, icon){
            final /* synthetic */ JBAnimator $animator;
            final /* synthetic */ SunburstPanel<T, I> this$0;
            final /* synthetic */ Easing $curve;
            {
                this.$animator = $animator;
                this.this$0 = $receiver;
                this.$curve = $curve;
                super($super_call_param$1, null, $super_call_param$2);
            }

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(AnActionEvent e) {
                void $this$actionPerformed_u24lambda_u241;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Animation[] animationArray = new Animation[1];
                Animation animation = Animations.animation((double)SunburstPanel.access$getSunburst$p(this.this$0).getThickness(), (double)(SunburstPanel.access$getSunburst$p(this.this$0).getThickness() * 1.2), arg_0 -> createActions.1.5.actionPerformed$lambda$0(this.this$0, arg_0));
                Easing easing = this.$curve;
                Animation animation2 = animation;
                int n = 0;
                Animation[] animationArray2 = animationArray;
                JBAnimator jBAnimator = this.$animator;
                boolean bl = false;
                $this$actionPerformed_u24lambda_u241.setDuration(100);
                $this$actionPerformed_u24lambda_u241.setEasing(easing);
                Unit unit = Unit.INSTANCE;
                animationArray2[n] = animation;
                jBAnimator.animate(animationArray);
            }

            private static final void actionPerformed$lambda$0(SunburstPanel this$0, double it) {
                SunburstPanel.access$getSunburst$p(this$0).setThickness(it);
            }
        });
        object = CommonProfilerBundleKt.commonProfilerMessage((String)"ui.flamechart.actions.zoomOut", (Object[])new Object[0]);
        icon = AllIcons.General.ZoomOut;
        $this$createActions_u24lambda_u2413.add((AnAction)new DumbAwareAction(animator, this, curve, (String)object, icon){
            final /* synthetic */ JBAnimator $animator;
            final /* synthetic */ SunburstPanel<T, I> this$0;
            final /* synthetic */ Easing $curve;
            {
                this.$animator = $animator;
                this.this$0 = $receiver;
                this.$curve = $curve;
                super($super_call_param$1, null, $super_call_param$2);
            }

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(AnActionEvent e) {
                void $this$actionPerformed_u24lambda_u241;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Animation[] animationArray = new Animation[1];
                Animation animation = Animations.animation((double)SunburstPanel.access$getSunburst$p(this.this$0).getThickness(), (double)(SunburstPanel.access$getSunburst$p(this.this$0).getThickness() / 1.2), arg_0 -> createActions.1.6.actionPerformed$lambda$0(this.this$0, arg_0));
                Easing easing = this.$curve;
                Animation animation2 = animation;
                int n = 0;
                Animation[] animationArray2 = animationArray;
                JBAnimator jBAnimator = this.$animator;
                boolean bl = false;
                $this$actionPerformed_u24lambda_u241.setDuration(100);
                $this$actionPerformed_u24lambda_u241.setEasing(easing);
                Unit unit = Unit.INSTANCE;
                animationArray2[n] = animation;
                jBAnimator.animate(animationArray);
            }

            private static final void actionPerformed$lambda$0(SunburstPanel this$0, double it) {
                SunburstPanel.access$getSunburst$p(this$0).setThickness(it);
            }
        });
        return defaultActionGroup;
    }

    private final void updateCrumbs(SunburstPanelElement value) {
        EDT.assertIsEdt();
        JBIterable jBIterable = JBIterable.generate((Object)value, arg_0 -> SunburstPanel.updateCrumbs$lambda$15(SunburstPanel::updateCrumbs$lambda$14, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"generate(...)");
        this.breadcrumbs.setCrumbs((Iterable)CollectionsKt.reversed((Iterable)((Iterable)jBIterable)));
    }

    public final void updateDiagram(@NotNull MuiSnapshot<T, I> dump) {
        Intrinsics.checkNotNullParameter(dump, (String)"dump");
        ApplicationManager.getApplication().executeOnPooledThread(() -> SunburstPanel.updateDiagram$lambda$18(this, dump));
    }

    @NotNull
    public abstract SunburstPanelModel doCalculate(@NotNull MuiSnapshot<T, I> var1);

    @NotNull
    protected List<AnAction> createPopupActions(@NotNull SunburstPanelElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return CollectionsKt.emptyList();
    }

    private static final Color _init_$lambda$0() {
        return UIUtil.getEditorPaneBackground();
    }

    private static final Unit _init_$lambda$2(SunburstPanel this$0, Crumb crumb, InputEvent inputEvent) {
        if (crumb instanceof SunburstPanelElement) {
            this$0.sunburst.setCenter((Object)crumb);
            this$0.updateList((SunburstPanelElement)crumb);
            this$0.updateCrumbs((SunburstPanelElement)crumb);
            this$0.history.add((SunburstPanelElement)crumb);
        }
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void _init_$lambda$5(SunburstPanel this$0, SunburstSection section, InputEvent inputEvent) {
        Intrinsics.checkNotNullParameter((Object)inputEvent, (String)"<unused var>");
        Object object = section;
        if (object == null || (object = (SunburstPanelElement)object.getContent()) == null) {
            object = (SunburstPanelElement)this$0.sunburst.getCenter();
        }
        this$0.updateList((SunburstPanelElement)object);
    }

    private static final void _init_$lambda$7(SunburstPanel this$0, SunburstSection section, InputEvent event) {
        block0: {
            SunburstPanelElement sunburstPanelElement;
            Intrinsics.checkNotNullParameter((Object)section, (String)"section");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            SunburstPanelElement sunburstPanelElement2 = this$0.sunburst.getCenter() != section.getContent() ? (SunburstPanelElement)section.getContent() : (sunburstPanelElement = ((SunburstPanelElement)section.getContent()).getParent() != null ? ((SunburstPanelElement)section.getContent()).getParent() : null);
            if (sunburstPanelElement == null) break block0;
            SunburstPanelElement element = sunburstPanelElement;
            boolean bl = false;
            this$0.sunburst.setCenter((Object)element);
            this$0.updateCrumbs(element);
            event.consume();
            this$0.history.add(element);
        }
    }

    private static final SunburstPanelElement _init_$lambda$9(SunburstPanel this$0, int x, int y) {
        SunburstSection sunburstSection = this$0.sunburst.findSection(x, y);
        return sunburstSection != null ? (SunburstPanelElement)sunburstSection.getContent() : null;
    }

    private static final SunburstPanelElement _init_$lambda$10(SunburstPanel this$0, int x, int y) {
        SunburstPanelElement sunburstPanelElement;
        int index = this$0.list.locationToIndex(new Point(x, y));
        if (index >= 0 && index < this$0.list.getModel().getSize()) {
            SunburstPanelElement element = (SunburstPanelElement)this$0.list.getModel().getElementAt(index);
            sunburstPanelElement = index == 0 || element.getParent() != null ? element : null;
        } else {
            sunburstPanelElement = null;
        }
        return sunburstPanelElement;
    }

    private static final double createActions$lambda$13$lambda$12(double x) {
        return x < 0.5 ? (double)2 * x * x : 1.0 - Math.pow((double)-2 * x + (double)2, 2.0) / (double)2;
    }

    private static final SunburstPanelElement updateCrumbs$lambda$14(SunburstPanelElement it) {
        return it.getParent();
    }

    private static final SunburstPanelElement updateCrumbs$lambda$15(Function1 $tmp0, Object p0) {
        return (SunburstPanelElement)$tmp0.invoke(p0);
    }

    private static final void updateDiagram$lambda$18$lambda$17(SunburstPanel this$0, SunburstPanelModel $model) {
        block0: {
            this$0.sunburst.setModel((SunburstModel)$model);
            this$0.sunburst.repaint();
            this$0.updateCrumbs((SunburstPanelElement)this$0.sunburst.getCenter());
            this$0.updateList((SunburstPanelElement)this$0.sunburst.getCenter());
            this$0.history.clear();
            SunburstPanelElement sunburstPanelElement = (SunburstPanelElement)this$0.sunburst.getCenter();
            if (sunburstPanelElement == null) break block0;
            SunburstPanelElement sunburstPanelElement2 = sunburstPanelElement;
            NavigationHistorySupport<SunburstPanelElement> navigationHistorySupport = this$0.history;
            SunburstPanelElement p0 = sunburstPanelElement2;
            boolean bl = false;
            navigationHistorySupport.add(p0);
        }
    }

    private static final void updateDiagram$lambda$18(SunburstPanel this$0, MuiSnapshot $dump) {
        SunburstPanelModel model2 = this$0.doCalculate($dump);
        ApplicationManager.getApplication().invokeLater(() -> SunburstPanel.updateDiagram$lambda$18$lambda$17(this$0, model2));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JN\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\u0007\"\b\b\u0002\u0010\b*\u00020\n\"\b\b\u0003\u0010\t*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u001e\u0010\u000e\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\u0010\u0012\u0004\u0012\u00020\u00110\u000fJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/profiler/ultimate/hprof/ui/sunburst/SunburstPanel$Companion;", "", "<init>", "()V", "DEFAULT_SIZE", "", "withModel", "Lcom/intellij/profiler/ultimate/hprof/ui/sunburst/SunburstPanel;", "T", "I", "Lcom/intellij/profiler/ultimate/hprof/api/MuiType;", "Lcom/intellij/profiler/ultimate/hprof/api/MuiInstance;", "project", "Lcom/intellij/openapi/project/Project;", "block", "Lkotlin/Function1;", "Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;", "Lcom/intellij/profiler/ultimate/hprof/ui/sunburst/SunburstPanelModel;", "getColor", "Ljava/awt/Color;", "name", "", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T extends MuiType, I extends MuiInstance> SunburstPanel<T, I> withModel(@NotNull Project project, @NotNull Function1<? super MuiSnapshot<T, I>, SunburstPanelModel> block) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            return new SunburstPanel<T, I>(project, block){
                final /* synthetic */ Function1<MuiSnapshot<T, I>, SunburstPanelModel> $block;
                {
                    this.$block = $block;
                    super($project);
                }

                public SunburstPanelModel doCalculate(MuiSnapshot<T, I> dump) {
                    Intrinsics.checkNotNullParameter(dump, (String)"dump");
                    return (SunburstPanelModel)this.$block.invoke(dump);
                }
            };
        }

        @NotNull
        public final Color getColor(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            JBColor color = new JBColor(16571797, 12558179);
            JBColor java = new JBColor(11196658, 8563912);
            return StringsKt.startsWith$default((String)name, (String)"java", (boolean)false, (int)2, null) ? (Color)java : (StringsKt.startsWith$default((String)name, (String)"sun.", (boolean)false, (int)2, null) ? (Color)java : (StringsKt.startsWith$default((String)name, (String)"jdk.", (boolean)false, (int)2, null) ? (Color)java : (StringsKt.startsWith$default((String)name, (String)"byte[]", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"short[]", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"int[]", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"long[]", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"float[]", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"double[]", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"boolean[]", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"char[]", (boolean)false, (int)2, null) ? (Color)java : (Color)color)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/profiler/ultimate/hprof/ui/sunburst/SunburstPanel$MyListener;", "Lcom/intellij/ui/hover/ListHoverListener;", "Ljava/awt/event/MouseListener;", "Ljava/awt/event/MouseMotionListener;", "Ljava/awt/event/MouseWheelListener;", "<init>", "(Lcom/intellij/profiler/ultimate/hprof/ui/sunburst/SunburstPanel;)V", "onHover", "", "list", "Ljavax/swing/JList;", "index", "", "startPoint", "Ljava/awt/Point;", "mousePressed", "e", "Ljava/awt/event/MouseEvent;", "mouseDragged", "mouseReleased", "mouseWheelMoved", "Ljava/awt/event/MouseWheelEvent;", "mouseClicked", "mouseEntered", "mouseExited", "mouseMoved", "intellij.profiler.ultimate"})
    private final class MyListener
    extends ListHoverListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        @Nullable
        private Point startPoint;

        public void onHover(@NotNull JList<?> list, int index) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            if (index < 0) {
                SunburstPanel.this.sunburst.setHovered(null);
                list.setCursor(Cursor.getDefaultCursor());
            } else {
                Object element = list.getModel().getElementAt(index);
                if (element instanceof SunburstPanelElement) {
                    SunburstPanel.this.sunburst.setHovered(SunburstPanel.this.sunburst.findSection(element));
                    list.setCursor(Cursor.getPredefinedCursor(12));
                }
            }
            SunburstPanel.this.sunburst.repaint();
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.getButton() == 1) {
                Point shift = SunburstPanel.this.sunburst.shift();
                this.startPoint = new Point(e.getX() + shift.x, e.getY() + shift.y);
            }
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Point pressed = this.startPoint;
                if (pressed == null) break block1;
                SunburstPanel.this.sunburst.shift(pressed.x - e.getX(), pressed.y - e.getY());
                Container container = SunburstPanel.this.sunburst.getParent();
                if (container != null) {
                    container.repaint();
                }
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.startPoint = null;
        }

        @Override
        public void mouseWheelMoved(@NotNull MouseWheelEvent e) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.isShiftDown() || e.getUnitsToScroll() == 0 || !ProfilerUIUtilsKt.isZoomKeyDown((MouseEvent)e)) break block1;
                Component component = ComponentUtil.findParentByCondition((Component)((Component)SunburstPanel.this.sunburst), arg_0 -> MyListener.mouseWheelMoved$lambda$1(MyListener::mouseWheelMoved$lambda$0, arg_0));
                ZoomableViewport zoomableViewport = component instanceof ZoomableViewport ? (ZoomableViewport)component : null;
                if (zoomableViewport != null) {
                    ZoomableViewport zv = zoomableViewport;
                    boolean bl = false;
                    zv.magnificationStarted(e.getPoint());
                    zv.magnificationFinished(e.getUnitsToScroll() < 0 ? 0.1 : -0.1);
                }
            }
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }

        private static final boolean mouseWheelMoved$lambda$0(Component it) {
            return it instanceof ZoomableViewport;
        }

        private static final boolean mouseWheelMoved$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

