/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.util;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotFacets;
import org.jetbrains.letsPlot.core.plot.builder.presentation.Defaults;
import org.jetbrains.letsPlot.core.spec.FigKind;
import org.jetbrains.letsPlot.core.spec.config.CompositeFigureConfig;
import org.jetbrains.letsPlot.core.spec.config.OptionsAccessor;
import org.jetbrains.letsPlot.core.spec.config.PlotConfig;
import org.jetbrains.letsPlot.core.spec.front.PlotConfigFrontend;
import org.jetbrains.letsPlot.core.util.PlotSizeHelper;
import org.jetbrains.letsPlot.core.util.sizing.SizingPolicy;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u001a\u0010\u000f\u001a\u00020\u00042\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00010\u0011J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u0014\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0011H\u0002J8\u0010\u0015\u001a\u00020\u00042\u000e\u0010\u0016\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00112\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ&\u0010\u001b\u001a\u00020\u00042\u000e\u0010\u0016\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/util/PlotSizeHelper;", "", "()V", "compositeFigureSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "config", "Lorg/jetbrains/letsPlot/core/spec/config/CompositeFigureConfig;", "containerSize", "sizingPolicy", "Lorg/jetbrains/letsPlot/core/util/sizing/SizingPolicy;", "compositeFigureSizeDefault", "defaultFacetedPlotSize", "ncol", "", "nrow", "figureSizeDefault", "figureSpec", "", "", "getSizeOptionOrNull", "singlePlotSpec", "singlePlotSize", "plotSpec", "facets", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets;", "containsLiveMap", "", "singlePlotSizeDefault", "plot-stem"})
public final class PlotSizeHelper {
    @NotNull
    public static final PlotSizeHelper INSTANCE = new PlotSizeHelper();

    private PlotSizeHelper() {
    }

    @NotNull
    public final DoubleVector singlePlotSize(@NotNull Map<?, ?> plotSpec, @Nullable DoubleVector containerSize, @NotNull SizingPolicy sizingPolicy, @NotNull PlotFacets facets, boolean containsLiveMap) {
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter((Object)sizingPolicy, (String)"sizingPolicy");
        Intrinsics.checkNotNullParameter((Object)facets, (String)"facets");
        if (sizingPolicy.isFixedSize()) {
            return sizingPolicy.getFixedSize();
        }
        DoubleVector defaultSize = this.singlePlotSizeDefault(plotSpec, facets, containsLiveMap);
        return sizingPolicy.resize(defaultSize, containerSize);
    }

    @NotNull
    public final DoubleVector singlePlotSizeDefault(@NotNull Map<?, ?> plotSpec, @NotNull PlotFacets facets, boolean containsLiveMap) {
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter((Object)facets, (String)"facets");
        DoubleVector doubleVector = this.getSizeOptionOrNull(plotSpec);
        if (doubleVector == null) {
            doubleVector = facets.isDefined() ? this.defaultFacetedPlotSize(facets.getColCount(), facets.getRowCount()) : (containsLiveMap ? Defaults.INSTANCE.getDEF_LARGE_PLOT_SIZE() : Defaults.INSTANCE.getDEF_PLOT_SIZE());
        }
        return doubleVector;
    }

    @NotNull
    public final DoubleVector compositeFigureSize(@NotNull CompositeFigureConfig config2, @Nullable DoubleVector containerSize, @NotNull SizingPolicy sizingPolicy) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)sizingPolicy, (String)"sizingPolicy");
        if (sizingPolicy.isFixedSize()) {
            return sizingPolicy.getFixedSize();
        }
        DoubleVector defaultSize = this.compositeFigureSizeDefault(config2);
        return sizingPolicy.resize(defaultSize, containerSize);
    }

    @NotNull
    public final DoubleVector compositeFigureSizeDefault(@NotNull CompositeFigureConfig config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        DoubleVector specifiedFigureSize = this.getSizeOptionOrNull(config2.toMap());
        DoubleVector doubleVector = specifiedFigureSize;
        if (doubleVector == null) {
            doubleVector = config2.getLayout$plot_stem().defaultSize();
        }
        return doubleVector;
    }

    private final DoubleVector defaultFacetedPlotSize(int ncol, int nrow) {
        double panelWidth = Defaults.INSTANCE.getDEF_PLOT_SIZE().getX() * (0.5 + 0.5 / (double)ncol);
        double panelHeight = Defaults.INSTANCE.getDEF_PLOT_SIZE().getY() * (0.5 + 0.5 / (double)nrow);
        return new DoubleVector(panelWidth * (double)ncol, panelHeight * (double)nrow);
    }

    private final DoubleVector getSizeOptionOrNull(Map<?, ?> singlePlotSpec) {
        if (!singlePlotSpec.containsKey("ggsize")) {
            return null;
        }
        Intrinsics.checkNotNull(singlePlotSpec, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        Map<String, Object> map2 = new OptionsAccessor(singlePlotSpec, null, 2, null).getMap("ggsize");
        OptionsAccessor sizeSpec = OptionsAccessor.Companion.over(map2);
        Double width2 = sizeSpec.getDouble("width");
        Double height = sizeSpec.getDouble("height");
        if (width2 == null || height == null) {
            return null;
        }
        return new DoubleVector(width2, height);
    }

    @NotNull
    public final DoubleVector figureSizeDefault(@NotNull Map<String, ? extends Object> figureSpec) {
        DoubleVector doubleVector;
        Intrinsics.checkNotNullParameter(figureSpec, (String)"figureSpec");
        if (PlotConfig.Companion.isFailure(figureSpec)) {
            return Defaults.INSTANCE.getDEF_PLOT_SIZE();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[PlotConfig.Companion.figSpecKind(figureSpec).ordinal()]) {
            case 1: {
                PlotConfigFrontend config2 = PlotConfigFrontend.Companion.create(figureSpec, null, (Function1<? super List<String>, Unit>)((Function1)figureSizeDefault.config.1.INSTANCE));
                doubleVector = INSTANCE.singlePlotSizeDefault(figureSpec, config2.getFacets(), config2.getContainsLiveMap());
                break;
            }
            case 2: {
                CompositeFigureConfig compositeFigureConfig2 = new CompositeFigureConfig(figureSpec, null, (Function1<? super List<String>, Unit>)((Function1)figureSizeDefault.compositeFigureConfig.1.INSTANCE));
                doubleVector = INSTANCE.compositeFigureSizeDefault(compositeFigureConfig2);
                break;
            }
            case 3: {
                throw new IllegalStateException("Unsupported: GGBunch");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return doubleVector;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FigKind.values().length];
            try {
                nArray[FigKind.PLOT_SPEC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FigKind.SUBPLOTS_SPEC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FigKind.GG_BUNCH_SPEC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

