/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.ui.problemsView.tree.ui;

import com.intellij.analysis.problemsView.Problem;
import com.intellij.analysis.problemsView.toolWindow.Node;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewPanel;
import com.intellij.analysis.problemsView.toolWindow.Root;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.ui.problemsView.QodanaProblemsViewPanel;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeNode;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeRoot;
import org.jetbrains.qodana.ui.problemsView.tree.ui.PresentationKt;
import org.jetbrains.qodana.ui.problemsView.tree.ui.QodanaUiTreeNode;
import org.jetbrains.qodana.vcs.RevisionKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00170\u0016H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020#H\u0016J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0096\u0002J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001b0)H\u0016J\b\u0010*\u001a\u00020#H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020,0)H\u0016J\u0010\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020,H\u0016J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u0002000)2\u0006\u0010.\u001a\u00020,H\u0016J\b\u00101\u001a\u00020#H\u0016J\u000e\u00102\u001a\b\u0012\u0004\u0012\u0002000)H\u0016R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00063"}, d2={"Lorg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeRoot;", "Lcom/intellij/analysis/problemsView/toolWindow/Root;", "Lorg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeNode;", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeRoot;", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeRoot$PrimaryData;", "panel", "Lorg/jetbrains/qodana/ui/problemsView/QodanaProblemsViewPanel;", "modelRootProvider", "Lkotlin/Function0;", "<init>", "(Lorg/jetbrains/qodana/ui/problemsView/QodanaProblemsViewPanel;Lkotlin/jvm/functions/Function0;)V", "parent", "getParent", "()Lorg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeNode;", "primaryData", "getPrimaryData", "()Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeRoot$PrimaryData;", "modelTreeNode", "getModelTreeNode", "()Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeRoot;", "computeModelTreeNode", "computeAncestorsAndThisModelNodes", "", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeNode;", "getExcludeActionsDescriptors", "Lorg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeNode$ExcludeActionDescriptor;", "asViewNode", "Lcom/intellij/analysis/problemsView/toolWindow/Node;", "update", "", "project", "Lcom/intellij/openapi/project/Project;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "hashCode", "", "equals", "", "other", "", "getChildren", "", "getProblemCount", "getProblemFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFileProblemCount", "file", "getFileProblems", "Lcom/intellij/analysis/problemsView/Problem;", "getOtherProblemCount", "getOtherProblems", "intellij.qodana"})
public final class QodanaUiTreeRoot
extends Root
implements QodanaUiTreeNode<QodanaTreeRoot, QodanaTreeRoot.PrimaryData> {
    @NotNull
    private final Function0<QodanaTreeRoot> modelRootProvider;
    @Nullable
    private final QodanaUiTreeNode<?, ?> parent;

    public QodanaUiTreeRoot(@NotNull QodanaProblemsViewPanel panel, @NotNull Function0<? extends QodanaTreeRoot> modelRootProvider) {
        Intrinsics.checkNotNullParameter((Object)((Object)panel), (String)"panel");
        Intrinsics.checkNotNullParameter(modelRootProvider, (String)"modelRootProvider");
        super((ProblemsViewPanel)panel);
        this.modelRootProvider = modelRootProvider;
    }

    @Override
    @Nullable
    public QodanaUiTreeNode<?, ?> getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public QodanaTreeRoot.PrimaryData getPrimaryData() {
        Object object = this.getModelTreeNode();
        if (object == null || (object = (QodanaTreeRoot.PrimaryData)object.getPrimaryData()) == null) {
            object = new QodanaTreeRoot.PrimaryData("", null, null, null);
        }
        return object;
    }

    @Override
    @Nullable
    public QodanaTreeRoot getModelTreeNode() {
        return (QodanaTreeRoot)this.modelRootProvider.invoke();
    }

    @Override
    @Nullable
    public QodanaTreeRoot computeModelTreeNode() {
        return this.getModelTreeNode();
    }

    @Override
    @NotNull
    public List<QodanaTreeNode<?, ?, ?>> computeAncestorsAndThisModelNodes() {
        return CollectionsKt.listOfNotNull((Object)this.getModelTreeNode());
    }

    @Override
    @NotNull
    public List<QodanaUiTreeNode.ExcludeActionDescriptor> getExcludeActionsDescriptors() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Node asViewNode() {
        return (Node)this;
    }

    protected void update(@NotNull Project project, @NotNull PresentationData presentation) {
        String firstElement;
        StringBuilder stringBuilder;
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        String reportName = this.getPrimaryData().getReportName();
        String branch = this.getPrimaryData().getBranch();
        String string2 = this.getPrimaryData().getRevision();
        String revision = string2 != null ? RevisionKt.trimRevisionString(string2) : null;
        Instant instant = this.getPrimaryData().getCreatedAt();
        if (instant != null) {
            Instant it = instant;
            boolean bl = false;
            string = DateTimeFormatter.ofPattern("dd/MM/yy, HH:mm").format(it.atZone(ZoneId.systemDefault()));
        } else {
            string = null;
        }
        String formattedDate = string;
        StringBuilder $this$update_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String string3 = branch;
        if (string3 == null && (string3 = revision) == null) {
            string3 = formattedDate;
        }
        if ((firstElement = string3) != null) {
            $this$update_u24lambda_u241.append(firstElement);
        }
        if (revision != null && firstElement != revision) {
            $this$update_u24lambda_u241.append(" " + revision);
        }
        if (formattedDate != null && firstElement != formattedDate) {
            $this$update_u24lambda_u241.append(", " + formattedDate);
        }
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        String additionalDescriptionText = string4;
        presentation.addText(reportName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        PresentationKt.appendGrayedText(presentation, additionalDescriptionText);
        PresentationKt.appendProblemsCount(presentation, this.getProblemCount());
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other;
    }

    @NotNull
    public Collection<Node> getChildren() {
        Object object = this.computeModelTreeNode();
        return object != null && (object = (QodanaTreeRoot.Children)object.getChildren()) != null && (object = object.getNodesSequence()) != null && (object = SequencesKt.mapNotNull(object, arg_0 -> QodanaUiTreeRoot.getChildren$lambda$2(this, arg_0))) != null && (object = SequencesKt.toList((Sequence)object)) != null ? (Collection)object : (Collection)CollectionsKt.emptyList();
    }

    public int getProblemCount() {
        QodanaTreeRoot qodanaTreeRoot = this.getModelTreeNode();
        return qodanaTreeRoot != null ? qodanaTreeRoot.getProblemsCount() : 0;
    }

    @NotNull
    public Collection<VirtualFile> getProblemFiles() {
        return CollectionsKt.emptyList();
    }

    public int getFileProblemCount(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return 0;
    }

    @NotNull
    public Collection<Problem> getFileProblems(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return CollectionsKt.emptyList();
    }

    public int getOtherProblemCount() {
        return 0;
    }

    @NotNull
    public Collection<Problem> getOtherProblems() {
        return CollectionsKt.emptyList();
    }

    private static final Node getChildren$lambda$2(QodanaUiTreeRoot this$0, QodanaTreeNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        QodanaUiTreeNode qodanaUiTreeNode = it.toUiNode(this$0);
        return qodanaUiTreeNode != null ? qodanaUiTreeNode.asViewNode() : null;
    }
}

