/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir.convertors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.wasm.ir.WasmInstr;
import org.jetbrains.kotlin.wasm.ir.convertors.InstructionsFlowOptimizersKt;
import org.jetbrains.kotlin.wasm.ir.convertors.MacroOpHandlersKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0000\u00a8\u0006\u0004"}, d2={"processInstructionsFlow", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/wasm/ir/WasmInstr;", "input", "wasm.ir"})
public final class InstructionsFlowConverterKt {
    @NotNull
    public static final Sequence<WasmInstr> processInstructionsFlow(@NotNull Sequence<? extends WasmInstr> input) {
        Intrinsics.checkNotNullParameter(input, "input");
        Sequence<WasmInstr> macroTableHandled = MacroOpHandlersKt.handleMacroTable(input);
        Sequence<WasmInstr> macroIfHandled = MacroOpHandlersKt.handleMacroIf(macroTableHandled);
        Sequence<WasmInstr> removedUnreachableCode = InstructionsFlowOptimizersKt.removeUnreachableInstructions(macroIfHandled);
        Sequence<WasmInstr> mergedWithDrop = InstructionsFlowOptimizersKt.removeInstructionPriorDrop(removedUnreachableCode);
        Sequence<WasmInstr> mergedWithUnreachable = InstructionsFlowOptimizersKt.removeInstructionPriorUnreachable(mergedWithDrop);
        Sequence<WasmInstr> mergedWithTee = InstructionsFlowOptimizersKt.mergeSetAndGetIntoTee(mergedWithUnreachable);
        return mergedWithTee;
    }
}

