/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.completion.trigger.model;

import com.intellij.ml.inline.completion.impl.control.ControlModel;
import com.intellij.ml.inline.completion.impl.control.ControlModelLoadingState;
import com.intellij.ml.inline.completion.impl.control.ControlModelParameters;
import com.intellij.ml.inline.completion.impl.control.ControlModelService;
import com.intellij.ml.llm.completion.trigger.model.MLApiControlModel;
import com.intellij.ml.llm.completion.trigger.model.MLApiControlModelService;
import com.intellij.ml.llm.completion.trigger.model.NanAndEmptyStringCleaner;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.util.Version;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.ml.tools.model.ClassesProbabilities;
import com.jetbrains.ml.tools.model.MLModel;
import com.jetbrains.ml.tools.model.pipeline.ModelPipeline;
import com.jetbrains.ml.tools.model.pipeline.ModelPipelineLoader;
import java.io.Closeable;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fBO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0011R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/completion/trigger/model/MLApiControlModelService;", "Lcom/intellij/ml/inline/completion/impl/control/ControlModelService;", "modelId", "", "modelStream", "Lkotlin/Function0;", "Ljava/io/InputStream;", "useDefaultNanCleaner", "", "isSilent", "randomPassProbability", "", "editorKindSuitable", "Lkotlin/Function1;", "Lcom/intellij/openapi/editor/EditorKind;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;ZLkotlin/jvm/functions/Function0;DLkotlin/jvm/functions/Function1;)V", "()Lkotlin/jvm/functions/Function0;", "getRandomPassProbability", "()D", "getEditorKindSuitable", "()Lkotlin/jvm/functions/Function1;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "_loadingState", "Lcom/intellij/ml/inline/completion/impl/control/ControlModelLoadingState;", "loadingState", "getLoadingState", "()Lcom/intellij/ml/inline/completion/impl/control/ControlModelLoadingState;", "scheduleLoading", "", "Companion", "intellij.ml.llm.completion.trigger.model"})
@ApiStatus.Internal
public final class MLApiControlModelService
implements ControlModelService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String modelId;
    @NotNull
    private final Function0<InputStream> modelStream;
    private final boolean useDefaultNanCleaner;
    @NotNull
    private final Function0<Boolean> isSilent;
    private final double randomPassProbability;
    @NotNull
    private final Function1<EditorKind, Boolean> editorKindSuitable;
    @NotNull
    private final ReentrantLock lock;
    @Nullable
    private ControlModelLoadingState _loadingState;
    @NotNull
    public static final String INFO_THRESHOLD = "threshold";
    @NotNull
    public static final String INFO_VERSION = "version";

    public MLApiControlModelService(@NotNull String modelId, @NotNull Function0<? extends InputStream> modelStream, boolean useDefaultNanCleaner, @NotNull Function0<Boolean> isSilent, double randomPassProbability, @NotNull Function1<? super EditorKind, Boolean> editorKindSuitable) {
        Intrinsics.checkNotNullParameter((Object)modelId, (String)"modelId");
        Intrinsics.checkNotNullParameter(modelStream, (String)"modelStream");
        Intrinsics.checkNotNullParameter(isSilent, (String)"isSilent");
        Intrinsics.checkNotNullParameter(editorKindSuitable, (String)"editorKindSuitable");
        this.modelId = modelId;
        this.modelStream = modelStream;
        this.useDefaultNanCleaner = useDefaultNanCleaner;
        this.isSilent = isSilent;
        this.randomPassProbability = randomPassProbability;
        this.editorKindSuitable = editorKindSuitable;
        this.lock = new ReentrantLock();
    }

    @NotNull
    public Function0<Boolean> isSilent() {
        return this.isSilent;
    }

    public double getRandomPassProbability() {
        return this.randomPassProbability;
    }

    @NotNull
    public Function1<EditorKind, Boolean> getEditorKindSuitable() {
        return this.editorKindSuitable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ControlModelLoadingState getLoadingState() {
        ControlModelLoadingState controlModelLoadingState;
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            ControlModelLoadingState controlModelLoadingState2 = this._loadingState;
            if (controlModelLoadingState2 == null) {
                ControlModelLoadingState.Loading loading;
                ControlModelLoadingState.Loading it = loading = ControlModelLoadingState.Loading.INSTANCE;
                boolean bl2 = false;
                this._loadingState = (ControlModelLoadingState)ControlModelLoadingState.Loading.INSTANCE;
                this.scheduleLoading();
                controlModelLoadingState2 = (ControlModelLoadingState)loading;
            }
            controlModelLoadingState = controlModelLoadingState2;
        }
        finally {
            lock.unlock();
        }
        return controlModelLoadingState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scheduleLoading() {
        Closeable closeable = (Closeable)this.modelStream.invoke();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            ExecutorService executorService = AppExecutorUtil.getAppExecutorService();
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"getAppExecutorService(...)");
            CompletionStage completionStage = ((CompletableFuture)ModelPipelineLoader.INSTANCE.load(it, executorService).thenAccept(arg_0 -> MLApiControlModelService.scheduleLoading$lambda$9$lambda$6(arg_0 -> MLApiControlModelService.scheduleLoading$lambda$9$lambda$5(this, arg_0), arg_0))).exceptionally(arg_0 -> MLApiControlModelService.scheduleLoading$lambda$9$lambda$8(this, arg_0));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit scheduleLoading$lambda$9$lambda$5(MLApiControlModelService this$0, ModelPipeline loadedPipeline) {
        Version version2;
        String versionString;
        ModelPipeline pipeline = this$0.useDefaultNanCleaner ? new ModelPipeline(NanAndEmptyStringCleaner.INSTANCE, loadedPipeline.getBaseModel(), loadedPipeline.getInfo()) : loadedPipeline;
        Object object = pipeline.getInfo().get(INFO_VERSION);
        String string = versionString = object instanceof String ? (String)object : null;
        if (string != null) {
            String it = string;
            boolean bl = false;
            version2 = Version.parseVersion((String)it);
            if (version2 == null) {
                boolean bl2 = false;
                String string2 = "ML API model has incorrect version format: " + versionString + ", it should be compatible with " + scheduleLoading.1.1.version.1.1.1.INSTANCE;
                throw new IllegalStateException(string2.toString());
            }
        } else {
            version2 = null;
        }
        Version version3 = version2;
        Object bl = pipeline.getInfo().get(INFO_THRESHOLD);
        Double d = bl instanceof Double ? (Double)bl : null;
        MLApiControlModel controlModel = new MLApiControlModel((MLModel<? extends ClassesProbabilities>)pipeline.predictingClasses(), this$0.getRandomPassProbability(), new ControlModelParameters(d != null ? d : 0.5, version3, this$0.modelId));
        Lock lock = this$0.lock;
        lock.lock();
        try {
            boolean bl3 = false;
            this$0._loadingState = (ControlModelLoadingState)new ControlModelLoadingState.Loaded((ControlModel)controlModel);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return Unit.INSTANCE;
    }

    private static final void scheduleLoading$lambda$9$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Void scheduleLoading$lambda$9$lambda$8(MLApiControlModelService this$0, Throwable e) {
        Void void_;
        Lock lock = this$0.lock;
        lock.lock();
        try {
            boolean bl = false;
            Intrinsics.checkNotNull((Object)e);
            this$0._loadingState = (ControlModelLoadingState)new ControlModelLoadingState.Error(e);
            void_ = null;
        }
        finally {
            lock.unlock();
        }
        return void_;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/completion/trigger/model/MLApiControlModelService$Companion;", "", "<init>", "()V", "INFO_THRESHOLD", "", "INFO_VERSION", "intellij.ml.llm.completion.trigger.model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

