/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.StringTokenizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.value.YearMonthDurationValue;

public class DurationValue
extends AtomicValue {
    protected boolean negative = false;
    protected int months = 0;
    protected long seconds = 0L;
    protected int microseconds = 0;

    protected DurationValue() {
    }

    public DurationValue(boolean positive, int years, int months, int days, int hours, int minutes, long seconds, int microseconds) throws IllegalArgumentException {
        this(positive, years, months, days, hours, minutes, seconds, microseconds, BuiltInAtomicType.DURATION);
    }

    public DurationValue(boolean positive, int years, int months, int days, int hours, int minutes, long seconds, int microseconds, AtomicType type) {
        boolean bl = this.negative = !positive;
        if (years < 0 || months < 0 || days < 0 || hours < 0 || minutes < 0 || seconds < 0L || microseconds < 0) {
            throw new IllegalArgumentException("Negative component value");
        }
        if ((double)years * 12.0 + (double)months > 2.147483647E9) {
            throw new IllegalArgumentException("Duration months limit exceeded");
        }
        if ((double)days * 86400.0 + (double)hours * 3600.0 + (double)minutes * 60.0 + (double)seconds > 9.223372036854776E18) {
            throw new IllegalArgumentException("Duration seconds limit exceeded");
        }
        this.months = years * 12 + months;
        long h = days * 24 + hours;
        long m = h * 60L + (long)minutes;
        this.seconds = m * 60L + seconds;
        this.microseconds = microseconds;
        this.normalizeZeroDuration();
        this.typeLabel = type;
    }

    protected void normalizeZeroDuration() {
        if (this.months == 0 && this.seconds == 0L && this.microseconds == 0) {
            this.negative = false;
        }
    }

    public static ConversionResult makeDuration(CharSequence s) {
        int years = 0;
        int months = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        int microseconds = 0;
        boolean negative = false;
        StringTokenizer tok = new StringTokenizer(((Object)Whitespace.trimWhitespace(s)).toString(), "-+.PYMDTHS", true);
        int components = 0;
        if (!tok.hasMoreElements()) {
            return DurationValue.badDuration("empty string", s);
        }
        String part = (String)tok.nextElement();
        if ("+".equals(part)) {
            return DurationValue.badDuration("+ sign not allowed in a duration", s);
        }
        if ("-".equals(part)) {
            negative = true;
            part = (String)tok.nextElement();
        }
        if (!"P".equals(part)) {
            return DurationValue.badDuration("missing 'P'", s);
        }
        int state = 0;
        block10: while (tok.hasMoreElements()) {
            int value;
            part = (String)tok.nextElement();
            if ("T".equals(part)) {
                state = 4;
                if (!tok.hasMoreElements()) {
                    return DurationValue.badDuration("T must be followed by time components", s);
                }
                part = (String)tok.nextElement();
            }
            if ((value = DurationValue.simpleInteger(part)) < 0) {
                if (part.length() > 8) {
                    return DurationValue.badDuration("component invalid or too large", s);
                }
                return DurationValue.badDuration("non-numeric component", s);
            }
            if (!tok.hasMoreElements()) {
                return DurationValue.badDuration("missing unit letter at end", s);
            }
            char delim = ((String)tok.nextElement()).charAt(0);
            switch (delim) {
                case 'Y': {
                    if (state > 0) {
                        return DurationValue.badDuration("Y is out of sequence", s);
                    }
                    years = value;
                    state = 1;
                    ++components;
                    continue block10;
                }
                case 'M': {
                    if (state == 4 || state == 5) {
                        minutes = value;
                        state = 6;
                        ++components;
                        continue block10;
                    }
                    if (state == 0 || state == 1) {
                        months = value;
                        state = 2;
                        ++components;
                        continue block10;
                    }
                    return DurationValue.badDuration("M is out of sequence", s);
                }
                case 'D': {
                    if (state > 2) {
                        return DurationValue.badDuration("D is out of sequence", s);
                    }
                    days = value;
                    state = 3;
                    ++components;
                    continue block10;
                }
                case 'H': {
                    if (state != 4) {
                        return DurationValue.badDuration("H is out of sequence", s);
                    }
                    hours = value;
                    state = 5;
                    ++components;
                    continue block10;
                }
                case '.': {
                    if (state < 4 || state > 6) {
                        return DurationValue.badDuration("misplaced decimal point", s);
                    }
                    seconds = value;
                    state = 7;
                    continue block10;
                }
                case 'S': {
                    if (state < 4 || state > 7) {
                        return DurationValue.badDuration("S is out of sequence", s);
                    }
                    if (state == 7) {
                        while (part.length() < 6) {
                            part = part + "0";
                        }
                        if (part.length() > 6) {
                            part = part.substring(0, 6);
                        }
                        if ((value = DurationValue.simpleInteger(part)) < 0) {
                            return DurationValue.badDuration("non-numeric fractional seconds", s);
                        }
                        microseconds = value;
                    } else {
                        seconds = value;
                    }
                    state = 8;
                    ++components;
                    continue block10;
                }
            }
            return DurationValue.badDuration("misplaced " + delim, s);
        }
        if (components == 0) {
            return DurationValue.badDuration("Duration specifies no components", s);
        }
        try {
            return new DurationValue(!negative, years, months, days, hours, minutes, seconds, microseconds, BuiltInAtomicType.DURATION);
        }
        catch (IllegalArgumentException err) {
            return new ValidationFailure(err.getMessage());
        }
    }

    protected static ValidationFailure badDuration(String msg, CharSequence s) {
        ValidationFailure err = new ValidationFailure("Invalid duration value '" + s + "' (" + msg + ')');
        err.setErrorCode("FORG0001");
        return err;
    }

    protected static int simpleInteger(String s) {
        long result = 0L;
        int len = s.length();
        if (len == 0) {
            return -1;
        }
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                if ((result = result * 10L + (long)(c - 48)) <= Integer.MAX_VALUE) continue;
                return -1;
            }
            return -1;
        }
        return (int)result;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        return new DurationValue(!this.negative, 0, this.months, 0, 0, 0, this.seconds, this.microseconds, typeLabel);
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DURATION;
    }

    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        switch (requiredType.getPrimitiveType()) {
            case 518: 
            case 632: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
            case 633: {
                return YearMonthDurationValue.fromMonths(this.months * (this.negative ? -1 : 1));
            }
            case 634: {
                return new DayTimeDurationValue(this.negative ? -1 : 1, 0, 0, 0, this.seconds, this.microseconds);
            }
        }
        ValidationFailure err = new ValidationFailure("Cannot convert duration to " + requiredType.getDisplayName());
        err.setErrorCode("XPTY0004");
        return err;
    }

    public DurationValue normalizeDuration() {
        return this;
    }

    public int signum() {
        if (this.negative) {
            return -1;
        }
        if (this.months == 0 && this.seconds == 0L && this.microseconds == 0) {
            return 0;
        }
        return 1;
    }

    public int getYears() {
        return this.months / 12;
    }

    public int getMonths() {
        return this.months % 12;
    }

    public int getDays() {
        return (int)(this.seconds / 86400L);
    }

    public int getHours() {
        return (int)(this.seconds % 86400L / 3600L);
    }

    public int getMinutes() {
        return (int)(this.seconds % 3600L / 60L);
    }

    public int getSeconds() {
        return (int)(this.seconds % 60L);
    }

    public int getMicroseconds() {
        return this.microseconds;
    }

    public String getStringValue() {
        return ((Object)this.getStringValueCS()).toString();
    }

    public CharSequence getStringValueCS() {
        if (this.months == 0 && this.seconds == 0L && this.microseconds == 0) {
            return "PT0S";
        }
        FastStringBuffer sb = new FastStringBuffer(32);
        if (this.negative) {
            sb.append('-');
        }
        int years = this.getYears();
        int months = this.getMonths();
        int days = this.getDays();
        int hours = this.getHours();
        int minutes = this.getMinutes();
        int seconds = this.getSeconds();
        sb.append("P");
        if (years != 0) {
            sb.append(years + "Y");
        }
        if (months != 0) {
            sb.append(months + "M");
        }
        if (days != 0) {
            sb.append(days + "D");
        }
        if (hours != 0 || minutes != 0 || seconds != 0 || this.microseconds != 0) {
            sb.append("T");
        }
        if (hours != 0) {
            sb.append(hours + "H");
        }
        if (minutes != 0) {
            sb.append(minutes + "M");
        }
        if (seconds != 0 || this.microseconds != 0) {
            if (seconds != 0 && this.microseconds == 0) {
                sb.append(seconds + "S");
            } else {
                long ms = seconds * 1000000 + this.microseconds;
                String mss = ms + "";
                if (seconds == 0) {
                    mss = "0000000" + mss;
                    mss = mss.substring(mss.length() - 7);
                }
                sb.append(mss.substring(0, mss.length() - 6));
                sb.append('.');
                int lastSigDigit = mss.length() - 1;
                while (mss.charAt(lastSigDigit) == '0') {
                    --lastSigDigit;
                }
                sb.append(mss.substring(mss.length() - 6, lastSigDigit + 1));
                sb.append('S');
            }
        }
        return sb;
    }

    public double getLengthInSeconds() {
        double a = (double)this.months * 30.43684991666667 * 24.0 * 60.0 * 60.0 + (double)this.seconds + (double)this.microseconds / 1000000.0;
        return this.negative ? -a : a;
    }

    public AtomicValue getComponent(int component) throws XPathException {
        switch (component) {
            case 1: {
                return Int64Value.makeIntegerValue(this.negative ? -this.getYears() : this.getYears());
            }
            case 2: {
                return Int64Value.makeIntegerValue(this.negative ? -this.getMonths() : this.getMonths());
            }
            case 3: {
                return Int64Value.makeIntegerValue(this.negative ? -this.getDays() : this.getDays());
            }
            case 4: {
                return Int64Value.makeIntegerValue(this.negative ? -this.getHours() : this.getHours());
            }
            case 5: {
                return Int64Value.makeIntegerValue(this.negative ? -this.getMinutes() : this.getMinutes());
            }
            case 6: {
                FastStringBuffer sb = new FastStringBuffer(16);
                String ms = "000000" + this.microseconds;
                ms = ms.substring(ms.length() - 6);
                sb.append((this.negative ? "-" : "") + this.getSeconds() + '.' + ms);
                return (AtomicValue)DecimalValue.makeDecimalValue(sb, false);
            }
            case 12: {
                return Int64Value.makeIntegerValue(this.negative ? -this.seconds : this.seconds);
            }
            case 11: {
                return new Int64Value(this.negative ? -this.microseconds : this.microseconds);
            }
        }
        throw new IllegalArgumentException("Unknown component for duration: " + component);
    }

    public Object getXPathComparable(boolean ordered, StringCollator collator, XPathContext context) {
        return ordered ? null : this;
    }

    public boolean equals(Object other) {
        DurationValue d1 = this;
        DurationValue d2 = (DurationValue)other;
        return d1.negative == d2.negative && d1.months == d2.months && d1.seconds == d2.seconds && d1.microseconds == d2.microseconds;
    }

    public int hashCode() {
        return new Double(this.getLengthInSeconds()).hashCode();
    }

    public DurationValue add(DurationValue other) throws XPathException {
        XPathException err = new XPathException("Only subtypes of xs:duration can be added");
        err.setErrorCode("XPTY0004");
        err.setIsTypeError(true);
        throw err;
    }

    public DurationValue subtract(DurationValue other) throws XPathException {
        XPathException err = new XPathException("Only subtypes of xs:duration can be subtracted");
        err.setErrorCode("XPTY0004");
        err.setIsTypeError(true);
        throw err;
    }

    public DurationValue negate() {
        return new DurationValue(this.negative, 0, this.months, 0, 0, 0, this.seconds, this.microseconds, this.typeLabel);
    }

    public DurationValue multiply(double factor) throws XPathException {
        XPathException err = new XPathException("Only subtypes of xs:duration can be multiplied by a number");
        err.setErrorCode("XPTY0004");
        err.setIsTypeError(true);
        throw err;
    }

    public DecimalValue divide(DurationValue other) throws XPathException {
        XPathException err = new XPathException("Only subtypes of xs:duration can be divided by another duration");
        err.setErrorCode("XPTY0004");
        err.setIsTypeError(true);
        throw err;
    }

    public Comparable getSchemaComparable() {
        return DurationValue.getSchemaComparable(this);
    }

    public static Comparable getSchemaComparable(DurationValue value) {
        int m = value.months;
        double s = (double)value.seconds + (double)value.microseconds / 1000000.0;
        if (value.negative) {
            s = -s;
            m = -m;
        }
        return new DurationComparable(m, s);
    }

    private static class DurationComparable
    implements Comparable {
        private int months;
        private double seconds;

        public DurationComparable(int m, double s) {
            this.months = m;
            this.seconds = s;
        }

        public int compareTo(Object o) {
            DurationComparable other;
            if (o instanceof DurationComparable) {
                other = (DurationComparable)o;
            } else if (o instanceof YearMonthDurationValue) {
                other = (DurationComparable)DurationValue.getSchemaComparable((YearMonthDurationValue)o);
            } else if (o instanceof DayTimeDurationValue) {
                other = (DurationComparable)DurationValue.getSchemaComparable((DayTimeDurationValue)o);
            } else {
                return Integer.MIN_VALUE;
            }
            if (this.months == other.months) {
                return Double.compare(this.seconds, other.seconds);
            }
            if (this.seconds == other.seconds) {
                return this.months == other.months ? 0 : (this.months < other.months ? -1 : 1);
            }
            double oneDay = 86400.0;
            double min0 = (double)this.monthsToDaysMinimum(this.months) * oneDay + this.seconds;
            double max0 = (double)this.monthsToDaysMaximum(this.months) * oneDay + this.seconds;
            double min1 = (double)this.monthsToDaysMinimum(other.months) * oneDay + other.seconds;
            double max1 = (double)this.monthsToDaysMaximum(other.months) * oneDay + other.seconds;
            if (max0 < min1) {
                return -1;
            }
            if (min0 > max1) {
                return 1;
            }
            return Integer.MIN_VALUE;
        }

        public boolean equals(Object o) {
            return this.compareTo(o) == 0;
        }

        public int hashCode() {
            return this.months ^ (int)this.seconds;
        }

        private int monthsToDaysMinimum(int months) {
            if (months < 0) {
                return -this.monthsToDaysMaximum(-months);
            }
            if (months < 12) {
                int[] shortest = new int[]{0, 28, 59, 89, 120, 150, 181, 212, 242, 273, 303, 334};
                return shortest[months];
            }
            int years = months / 12;
            int remainingMonths = months % 12;
            int yearDays = years * 365 + years % 4 - years % 100 + years % 400 - 1;
            return yearDays + this.monthsToDaysMinimum(remainingMonths);
        }

        private int monthsToDaysMaximum(int months) {
            if (months < 0) {
                return -this.monthsToDaysMinimum(-months);
            }
            if (months < 12) {
                int[] longest = new int[]{0, 31, 62, 92, 123, 153, 184, 215, 245, 276, 306, 337};
                return longest[months];
            }
            int years = months / 12;
            int remainingMonths = months % 12;
            int yearDays = years * 365 + years % 4 - years % 100 + years % 400 + 1;
            return yearDays + this.monthsToDaysMaximum(remainingMonths);
        }
    }
}

