/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.io;

import java.io.IOException;
import java.io.InputStream;

public class FastByteArrayInputStream
extends InputStream {
    protected int count;
    protected int pos;
    protected int mark;
    protected byte[] buf;
    protected int readlimit = -1;

    public FastByteArrayInputStream(byte[] buffer) {
        this.buf = buffer;
        this.count = this.buf.length;
        this.pos = 0;
        this.mark = 0;
    }

    public FastByteArrayInputStream(byte[] buffer, int offset, int length) {
        this.buf = buffer;
        this.pos = offset;
        this.count = length;
    }

    @Override
    public int read() throws IOException {
        if (this.pos < this.count) {
            return this.buf[this.pos++] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] toBuf, int offset, int length) throws IOException {
        int avail = this.count - this.pos;
        if (avail <= 0) {
            return -1;
        }
        if (length > avail) {
            length = avail;
        }
        System.arraycopy(this.buf, this.pos, toBuf, offset, length);
        this.pos += length;
        return length;
    }

    @Override
    public int read(byte[] toBuf) throws IOException {
        return this.read(toBuf, 0, toBuf.length);
    }

    @Override
    public long skip(long n) {
        int skip = this.count - this.pos - (int)n;
        if (skip > 0) {
            this.pos += skip;
        }
        return skip;
    }

    @Override
    public void close() {
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public void mark(int limit) {
        this.mark = this.pos;
        this.readlimit = limit;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void reset() throws IOException {
        if (this.readlimit >= 0 && this.pos <= this.mark + this.readlimit) {
            this.mark = this.pos;
            this.readlimit = -1;
            throw new IOException("Readlimit exceeded.");
        }
        this.pos = this.mark;
        this.readlimit = -1;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getPosition() {
        return this.pos;
    }

    public int size() {
        return this.count;
    }
}

