/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.KafkaAvroSerializerConfig;
import io.confluent.kafka.serializers.NonRecordContainer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.header.Headers;

public abstract class AbstractKafkaAvroSerializer
extends AbstractKafkaSchemaSerDe {
    private final EncoderFactory encoderFactory = EncoderFactory.get();
    protected boolean normalizeSchema;
    protected boolean autoRegisterSchema;
    protected boolean propagateSchemaTags;
    protected boolean removeJavaProperties;
    protected int useSchemaId = -1;
    protected boolean idCompatStrict;
    protected boolean latestCompatStrict;
    protected boolean avroReflectionAllowNull = false;
    protected boolean avroUseLogicalTypeConverters = false;
    private final Cache<Schema, DatumWriter<Object>> datumWriterCache = CacheBuilder.newBuilder().maximumSize(1000L).weakKeys().build();

    protected void configure(KafkaAvroSerializerConfig config) {
        this.configureClientProperties(config, (SchemaProvider)new AvroSchemaProvider());
        this.normalizeSchema = config.normalizeSchema();
        this.autoRegisterSchema = config.autoRegisterSchema();
        this.propagateSchemaTags = config.propagateSchemaTags();
        this.removeJavaProperties = config.getBoolean("avro.remove.java.properties");
        this.useSchemaId = config.useSchemaId();
        this.idCompatStrict = config.getIdCompatibilityStrict();
        this.latestCompatStrict = config.getLatestCompatibilityStrict();
        this.avroReflectionAllowNull = config.getBoolean("avro.reflection.allow.null");
        this.avroUseLogicalTypeConverters = config.getBoolean("avro.use.logical.type.converters");
    }

    protected KafkaAvroSerializerConfig serializerConfig(Map<String, ?> props) {
        return new KafkaAvroSerializerConfig(props);
    }

    protected KafkaAvroSerializerConfig serializerConfig(Properties props) {
        return new KafkaAvroSerializerConfig(props);
    }

    protected byte[] serializeImpl(String subject, Object object, AvroSchema schema) throws SerializationException, InvalidConfigurationException {
        return this.serializeImpl(subject, null, null, object, schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] serializeImpl(String subject, String topic, Headers headers, Object object, AvroSchema schema) throws SerializationException, InvalidConfigurationException {
        if (this.schemaRegistry == null) {
            StringBuilder userFriendlyMsgBuilder = new StringBuilder();
            userFriendlyMsgBuilder.append("You must configure() before serialize()");
            userFriendlyMsgBuilder.append(" or use serializer constructor with SchemaRegistryClient");
            throw new InvalidConfigurationException(userFriendlyMsgBuilder.toString());
        }
        if (object == null) {
            return null;
        }
        String restClientErrorMsg = "";
        try {
            AbstractKafkaSchemaSerDe.ExtendedSchema extendedSchema;
            int id;
            if (this.autoRegisterSchema) {
                Optional optSchema;
                restClientErrorMsg = "Error registering Avro schema";
                io.confluent.kafka.schemaregistry.client.rest.entities.Schema s = this.registerWithResponse(subject, (ParsedSchema)schema, this.normalizeSchema, this.propagateSchemaTags);
                if (s.getSchema() != null && (optSchema = this.schemaRegistry.parseSchema(s)).isPresent()) {
                    schema = (AvroSchema)optSchema.get();
                    schema = schema.copy(s.getVersion());
                }
                id = s.getId();
            } else if (this.useSchemaId >= 0) {
                restClientErrorMsg = "Error retrieving schema ID";
                schema = (AvroSchema)this.lookupSchemaBySubjectAndId(subject, this.useSchemaId, (ParsedSchema)schema, this.idCompatStrict);
                id = this.useSchemaId;
            } else if (this.metadata != null) {
                restClientErrorMsg = "Error retrieving latest with metadata '" + this.metadata + "'";
                extendedSchema = this.getLatestWithMetadata(subject);
                schema = (AvroSchema)extendedSchema.getSchema();
                id = extendedSchema.getId();
            } else if (this.useLatestVersion) {
                restClientErrorMsg = "Error retrieving latest version of Avro schema";
                extendedSchema = this.lookupLatestVersion(subject, (ParsedSchema)schema, this.latestCompatStrict);
                schema = (AvroSchema)extendedSchema.getSchema();
                id = extendedSchema.getId();
            } else {
                restClientErrorMsg = "Error retrieving Avro schema";
                id = this.schemaRegistry.getId(subject, (ParsedSchema)schema, this.normalizeSchema);
            }
            AvroSchemaUtils.setThreadLocalData((Schema)schema.rawSchema(), (boolean)this.avroUseLogicalTypeConverters, (boolean)this.avroReflectionAllowNull);
            try {
                object = this.executeRules(subject, topic, headers, RuleMode.WRITE, null, (ParsedSchema)schema, object);
            }
            finally {
                AvroSchemaUtils.clearThreadLocalData();
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(0);
            out.write(ByteBuffer.allocate(4).putInt(id).array());
            Object value = object instanceof NonRecordContainer ? ((NonRecordContainer)object).getValue() : object;
            Schema rawSchema = schema.rawSchema();
            if (rawSchema.getType().equals((Object)Schema.Type.BYTES)) {
                if (value instanceof byte[]) {
                    out.write((byte[])value);
                } else {
                    if (!(value instanceof ByteBuffer)) throw new SerializationException("Unrecognized bytes object of type: " + value.getClass().getName());
                    out.write(((ByteBuffer)value).array());
                }
            } else {
                this.writeDatum(out, value, rawSchema);
            }
            byte[] bytes = out.toByteArray();
            out.close();
            byte[] byArray = bytes;
            return byArray;
        }
        catch (ExecutionException ex) {
            throw new SerializationException("Error serializing Avro message", ex.getCause());
        }
        catch (InterruptedIOException e) {
            throw new TimeoutException("Error serializing Avro message", (Throwable)e);
        }
        catch (IOException | RuntimeException e) {
            throw new SerializationException("Error serializing Avro message", (Throwable)e);
        }
        catch (RestClientException e) {
            throw AbstractKafkaAvroSerializer.toKafkaException((RestClientException)e, (String)(restClientErrorMsg + schema));
        }
        finally {
            this.postOp(object);
        }
    }

    private void writeDatum(ByteArrayOutputStream out, Object value, Schema rawSchema) throws ExecutionException, IOException {
        BinaryEncoder encoder = this.encoderFactory.directBinaryEncoder((OutputStream)out, null);
        DatumWriter writer = (DatumWriter)this.datumWriterCache.get((Object)rawSchema, () -> AvroSchemaUtils.getDatumWriter((Object)value, (Schema)rawSchema, (boolean)this.avroUseLogicalTypeConverters, (boolean)this.avroReflectionAllowNull));
        writer.write(value, (Encoder)encoder);
        encoder.flush();
    }
}

