/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.objectstore.CacheStore;
import com.arjuna.ats.internal.arjuna.objectstore.ShutdownThread;
import com.arjuna.ats.internal.arjuna.objectstore.StoreElement;
import java.util.LinkedList;

class AsyncStore
extends Thread {
    public static final int NO_WORK = -1;
    public static final int COMMIT = 0;
    public static final int REMOVE = 1;
    public static final int WRITE = 2;
    public static final int IN_USE = 3;
    public static final int REMOVED = 4;
    public static final int NOT_PRESENT = 5;
    public Object _activeLock = new Object();
    private LinkedList[] _workList = null;
    private int _numberOfEntries = 0;
    private boolean _terminated = false;
    private int _currentCacheSize = 0;
    private int _maximumCacheSize = 0;
    private int _maximumWorkItems = 0;
    private int _maximumRemovedItems = 0;
    private int _scanPeriod = 0;
    private Object _overflowLock = new Object();
    private StoreElement _work = null;
    private int _removedItems = 0;
    private static final int HASH_SIZE = arjPropertyManager.getObjectStoreEnvironmentBean().getCacheStoreHash();
    private static final int _defaultCacheSize = arjPropertyManager.getObjectStoreEnvironmentBean().getCacheStoreSize();
    private static final int _defaultRemovedItems = arjPropertyManager.getObjectStoreEnvironmentBean().getCacheStoreRemovedItems();
    private static final int _defaultWorkItems = arjPropertyManager.getObjectStoreEnvironmentBean().getCacheStoreWorkItems();
    private static final int _defaultScanPeriod = arjPropertyManager.getObjectStoreEnvironmentBean().getCacheStoreScanPeriod();

    public AsyncStore() {
        super("AsyncStoreThread");
        this._maximumCacheSize = _defaultCacheSize;
        this._maximumWorkItems = _defaultWorkItems;
        this._maximumRemovedItems = _defaultRemovedItems;
        this._scanPeriod = _defaultScanPeriod;
        this._workList = new LinkedList[HASH_SIZE];
        this.setDaemon(true);
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void flush() {
        boolean stop = false;
        do {
            LinkedList[] linkedListArray = this._workList;
            // MONITORENTER : this._workList
            stop = this._numberOfEntries <= 0;
            // MONITOREXIT : linkedListArray
            if (stop) continue;
            this.doWork();
        } while (!stop);
        this._terminated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addWork(CacheStore store, int workType, Uid objUid, String tName, OutputObjectState state, int ft) {
        LinkedList[] list2;
        boolean stop = false;
        do {
            Object object = this._overflowLock;
            synchronized (object) {
                if (this.cacheIsFull()) {
                    try {
                        this._overflowLock.wait();
                    }
                    catch (Exception exception) {}
                } else {
                    stop = true;
                }
            }
        } while (!stop);
        StoreElement toAdd = new StoreElement(store, workType, objUid, tName, state, ft);
        LinkedList[] linkedListArray = list2 = this.getList(objUid);
        synchronized (list2) {
            list2.addFirst(toAdd);
            // ** MonitorExit[var10_12] (shouldn't be in output)
            linkedListArray = this._workList;
            synchronized (this._workList) {
                if (state != null) {
                    this._currentCacheSize += state.size();
                }
                ++this._numberOfEntries;
                // ** MonitorExit[var10_12] (shouldn't be in output)
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final int removeState(Uid objUid, int ft) {
        LinkedList list2;
        Object[] elements = null;
        LinkedList linkedList = list2 = this.getList(objUid);
        // MONITORENTER : linkedList
        try {
            elements = list2.toArray();
        }
        catch (Exception ex) {
            tsLogger.i18NLogger.warn_could_not_extract_array(ex);
            elements = null;
        }
        int status = 5;
        if (elements == null) {
            tsLogger.logger.trace((Object)"No elements");
            return status;
        }
        for (int i = 0; i < elements.length; ++i) {
            StoreElement element = (StoreElement)elements[i];
            if (element == null) continue;
            LinkedList[] linkedListArray = this._workList;
            // MONITORENTER : this._workList
            StoreElement storeElement = element;
            // MONITORENTER : storeElement
            if (!element.removed && element.objUid.equals(objUid)) {
                switch (element.typeOfWork) {
                    case 1: {
                        element.remove();
                        ++this._removedItems;
                        if (status == 3) break;
                        status = 4;
                        break;
                    }
                    case 2: {
                        if (element.state != null) {
                            this._currentCacheSize -= element.state.size();
                        }
                        ++this._removedItems;
                        element.remove();
                        if (status == 3) break;
                        status = 4;
                        break;
                    }
                }
            }
            // MONITOREXIT : storeElement
            // MONITOREXIT : linkedListArray
        }
        if (this.cacheIsFull()) {
            LinkedList[] linkedListArray = this._workList;
            // MONITORENTER : this._workList
            this._workList.notify();
            // MONITOREXIT : linkedListArray
        }
        if (!CacheStore._storeManager.currentWork(objUid, ft)) return status;
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final int removeWriteState(Uid objUid, int ft) {
        LinkedList list2;
        int status = 5;
        Object[] elements = null;
        LinkedList linkedList = list2 = this.getList(objUid);
        // MONITORENTER : linkedList
        try {
            elements = list2.toArray();
        }
        catch (Exception ex) {
            tsLogger.i18NLogger.warn_could_not_extract_array(ex);
            elements = null;
        }
        if (elements == null) {
            tsLogger.logger.trace((Object)"No elements");
            return status;
        }
        int i = 0;
        while (true) {
            if (i >= elements.length) {
                if (!this.cacheIsFull()) return status;
                LinkedList[] linkedListArray = this._workList;
                // MONITORENTER : this._workList
                this._workList.notify();
                // MONITOREXIT : linkedListArray
                return status;
            }
            StoreElement element = (StoreElement)elements[i];
            if (element != null) {
                LinkedList[] linkedListArray = this._workList;
                // MONITORENTER : this._workList
                StoreElement storeElement = element;
                // MONITORENTER : storeElement
                if (!element.removed && element.objUid.equals(objUid)) {
                    switch (element.typeOfWork) {
                        case 2: {
                            if (ft == element.fileType) {
                                if (element.state != null) {
                                    this._currentCacheSize -= element.state.size();
                                }
                                ++this._removedItems;
                                element.remove();
                                status = 4;
                                break;
                            }
                            if (ft != 11 || element.fileType != 10) break;
                            if (element.state != null) {
                                this._currentCacheSize -= element.state.size();
                            }
                            ++this._removedItems;
                            element.remove();
                            status = 4;
                            break;
                        }
                        case 0: {
                            if (ft != 11) break;
                            if (element.state != null) {
                                this._currentCacheSize -= element.state.size();
                            }
                            ++this._removedItems;
                            element.remove();
                            status = 4;
                            break;
                        }
                    }
                }
                // MONITOREXIT : storeElement
                // MONITOREXIT : linkedListArray
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final OutputObjectState getState(Uid objUid, int ft) {
        LinkedList[] list2;
        LinkedList[] linkedListArray = list2 = this.getList(objUid);
        synchronized (list2) {
            for (int i = 0; i < list2.size(); ++i) {
                StoreElement element = (StoreElement)list2.get(i);
                if (element == null) continue;
                StoreElement storeElement = element;
                synchronized (storeElement) {
                    if (!element.removed && element.objUid.equals(objUid) && element.fileType == ft) {
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 5, 9, 11] lbl11 : MonitorExitStatement: MONITOREXIT : var7_7
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return element.state;
                    }
                    continue;
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            linkedListArray = this._workList;
            synchronized (this._workList) {
                if (this._work != null && objUid.equals(this._work.objUid)) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return this._work.state;
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        Object object = this._workList;
        // MONITORENTER : this._workList
        try {
            this._workList.wait();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (!this._terminated) {
            object = this._activeLock;
            // MONITORENTER : object
            while (!this.queueIsEmpty()) {
                this.doWork();
            }
            Object object2 = this._overflowLock;
            // MONITORENTER : object2
            this._overflowLock.notifyAll();
            // MONITOREXIT : object2
            // MONITOREXIT : object
            object = this._workList;
            // MONITORENTER : this._workList
            if (!this.cacheIsFull()) {
                try {
                    this._workList.wait(this._scanPeriod);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            // MONITOREXIT : object
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean currentWork(Uid objUid, int ft) {
        try {
            LinkedList[] linkedListArray = this._workList;
            synchronized (this._workList) {
                if (this._work != null && this._work.objUid.equals(objUid) && this._work.fileType == ft) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return true;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void doWork() {
        LinkedList[] linkedListArray;
        LinkedList[] list2 = this.getList();
        if (list2 != null) {
            linkedListArray = list2;
            // MONITORENTER : list2
            LinkedList[] linkedListArray2 = this._workList;
            // MONITORENTER : this._workList
            if (!list2.isEmpty()) {
                this._work = (StoreElement)list2.removeLast();
                --this._numberOfEntries;
                if (this._work.state != null && !this._work.removed) {
                    this._currentCacheSize -= this._work.state.size();
                }
                if (this._work.removed) {
                    --this._removedItems;
                }
            } else {
                this._work = null;
            }
            // MONITOREXIT : linkedListArray2
            // MONITOREXIT : linkedListArray
        } else {
            linkedListArray = this._workList;
            // MONITORENTER : this._workList
            this._work = null;
            // MONITOREXIT : linkedListArray
        }
        linkedListArray = this._workList;
        // MONITORENTER : this._workList
        if (this._work != null && !this._work.removed) {
            try {
                switch (this._work.typeOfWork) {
                    case 0: {
                        if (this._work.store.commitState(this._work.objUid, this._work.tName)) break;
                        tsLogger.i18NLogger.warn_objectstore_CacheStore_1(this._work.objUid, this._work.tName);
                        break;
                    }
                    case 1: {
                        if (this._work.store.removeState(this._work.objUid, this._work.tName, this._work.fileType)) break;
                        tsLogger.i18NLogger.warn_objectstore_CacheStore_2(this._work.objUid, this._work.tName, Integer.toString(this._work.fileType));
                        break;
                    }
                    case 2: {
                        if (this._work.store.writeState(this._work.objUid, this._work.tName, this._work.state, this._work.fileType)) break;
                        tsLogger.i18NLogger.warn_objectstore_CacheStore_3(this._work.objUid, this._work.tName, this._work.state.toString(), Integer.toString(this._work.fileType));
                        break;
                    }
                    default: {
                        tsLogger.i18NLogger.warn_objectstore_CacheStore_4(Integer.toString(this._work.typeOfWork));
                        break;
                    }
                }
            }
            catch (ObjectStoreException ex) {
                tsLogger.i18NLogger.warn_could_not_handle_objectstore(ex);
            }
            catch (Exception ex) {
                tsLogger.i18NLogger.warn_could_not_handle_objectstore_generic(ex);
            }
        }
        // MONITOREXIT : linkedListArray
        linkedListArray = this._workList;
        // MONITORENTER : this._workList
        this._work = null;
        // MONITOREXIT : linkedListArray
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean queueIsEmpty() {
        LinkedList[] linkedListArray = this._workList;
        synchronized (this._workList) {
            if (this._numberOfEntries == 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean cacheIsFull() {
        LinkedList[] linkedListArray = this._workList;
        synchronized (this._workList) {
            if (this._currentCacheSize >= this._maximumCacheSize || this._removedItems >= this._maximumRemovedItems || this._numberOfEntries - this._removedItems >= this._maximumWorkItems) {
                this._workList.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LinkedList getList() {
        LinkedList[] linkedListArray = this._workList;
        synchronized (this._workList) {
            for (int i = 0; i < HASH_SIZE; ++i) {
                if (this._workList[i] == null || this._workList[i].isEmpty()) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this._workList[i];
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LinkedList getList(Uid objUid) {
        int index = objUid.hashCode() % HASH_SIZE;
        LinkedList[] linkedListArray = this._workList;
        synchronized (this._workList) {
            if (this._workList[index] == null) {
                this._workList[index] = new LinkedList();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this._workList[index];
        }
    }
}

