/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.credentialbuilder;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.OID4VCIssuerWellKnownProvider;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilder;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilderFactory;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilderUtils;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.SdJwtCredentialBuilder;
import org.keycloak.provider.ProviderConfigProperty;

public class SdJwtCredentialBuilderFactory
implements CredentialBuilderFactory {
    protected static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    @Override
    public String getSupportedFormat() {
        return "vc+sd-jwt";
    }

    public String getHelpText() {
        return "Builds verifiable credentials on the SD-JWT format (https://drafts.oauth.net/oauth-sd-jwt-vc/draft-ietf-oauth-sd-jwt-vc.html).";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public CredentialBuilder create(KeycloakSession session, ComponentModel model) {
        String credentialIssuer = CredentialBuilderUtils.getIssuerDid(session).orElse(OID4VCIssuerWellKnownProvider.getIssuer(session.getContext()));
        return new SdJwtCredentialBuilder(credentialIssuer);
    }
}

