/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.annotations.impl;

import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.reflect.annotations.AnnotationCategory;
import org.gradle.internal.reflect.annotations.PropertyAnnotationMetadata;
import org.gradle.internal.reflect.annotations.impl.AbstractHasAnnotationMetadata;

public class DefaultPropertyAnnotationMetadata
extends AbstractHasAnnotationMetadata
implements PropertyAnnotationMetadata {
    private final String propertyName;

    public DefaultPropertyAnnotationMetadata(String propertyName, Method getter, ImmutableMap<AnnotationCategory, Annotation> annotationsByCategory) {
        super(getter, annotationsByCategory);
        this.propertyName = propertyName;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public int compareTo(@Nonnull PropertyAnnotationMetadata o) {
        return this.propertyName.compareTo(o.getPropertyName());
    }

    @Override
    @Nullable
    public Object getPropertyValue(Object object) {
        try {
            return this.getMethod().invoke(object, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e.getCause());
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not call %s.%s() on %s", this.getMethod().getDeclaringClass().getSimpleName(), this.getMethod().getName(), object), (Throwable)e);
        }
    }

    public String toString() {
        return String.format("%s / %s()", this.propertyName, this.getMethod().getName());
    }
}

