/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.collect.ImmutableSortedSet;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.tasks.properties.FilePropertySpec;
import org.gradle.internal.execution.model.InputNormalizer;
import org.gradle.internal.fingerprint.FileNormalizer;
import org.gradle.internal.properties.InputFilePropertyType;

public class FileParameterUtils {
    public static FileNormalizer normalizerOrDefault(@Nullable FileNormalizer fileNormalizer) {
        return fileNormalizer == null ? InputNormalizer.ABSOLUTE_PATH : fileNormalizer;
    }

    public static <T extends FilePropertySpec> ImmutableSortedSet<T> collectFileProperties(String displayName, Iterator<? extends T> fileProperties) {
        HashSet<String> names = new HashSet<String>();
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        while (fileProperties.hasNext()) {
            FilePropertySpec propertySpec = (FilePropertySpec)fileProperties.next();
            String propertyName = propertySpec.getPropertyName();
            if (!names.add(propertyName)) {
                throw new IllegalArgumentException(String.format("Multiple %s file properties with name '%s'", displayName, propertyName));
            }
            builder.add((Object)propertySpec);
        }
        return builder.build();
    }

    public static FileCollectionInternal resolveInputFileValue(FileCollectionFactory fileCollectionFactory, InputFilePropertyType inputFilePropertyType, Object path) {
        FileCollectionInternal fileCollection = fileCollectionFactory.resolvingLeniently(path);
        return inputFilePropertyType == InputFilePropertyType.DIRECTORY ? fileCollection.getAsFileTree() : fileCollection;
    }
}

