import type { Events as AdapterEvents } from "../../adapter";
import * as Zcl from "../../zspec/zcl";
import type { TPartialClusterAttributes } from "../../zspec/zcl/definition/clusters-types";
import type { ClusterDefinition, CustomClusters } from "../../zspec/zcl/definition/tstype";
import type { ControllerEventMap } from "../controller";
import type { DeviceType, KeyValue } from "../tstype";
import Endpoint from "./endpoint";
import Entity from "./entity";
interface Lqi {
    neighbors: {
        ieeeAddr: string;
        networkAddress: number;
        linkquality: number;
        relationship: number;
        depth: number;
    }[];
}
interface RoutingTable {
    table: {
        destinationAddress: number;
        status: string;
        nextHop: number;
    }[];
}
type CustomReadResponse = (frame: Zcl.Frame, endpoint: Endpoint) => boolean;
export declare enum InterviewState {
    Pending = "PENDING",
    InProgress = "IN_PROGRESS",
    Successful = "SUCCESSFUL",
    Failed = "FAILED"
}
export declare class Device extends Entity<ControllerEventMap> {
    #private;
    private readonly ID;
    private _endpoints;
    private _ieeeAddr;
    private _interviewState;
    private _lastSeen?;
    private _manufacturerID?;
    private _networkAddress;
    private _type;
    private _linkquality?;
    private _skipDefaultResponse;
    private _customReadResponse?;
    private _lastDefaultResponseSequenceNumber?;
    private _checkinInterval?;
    private _pendingRequestTimeout;
    private _customClusters;
    private _gpSecurityKey?;
    get ieeeAddr(): string;
    set ieeeAddr(ieeeAddr: string);
    get applicationVersion(): number | undefined;
    set applicationVersion(version: number);
    get endpoints(): Endpoint[];
    get interviewState(): InterviewState;
    get lastSeen(): number | undefined;
    get manufacturerID(): number | undefined;
    get isDeleted(): boolean;
    set type(type: DeviceType);
    get type(): DeviceType;
    get dateCode(): string | undefined;
    set dateCode(code: string);
    set hardwareVersion(version: number);
    get hardwareVersion(): number | undefined;
    get manufacturerName(): string | undefined;
    set manufacturerName(name: string | undefined);
    set modelID(id: string);
    get modelID(): string | undefined;
    get networkAddress(): number;
    set networkAddress(networkAddress: number);
    get powerSource(): string | undefined;
    set powerSource(source: string | number);
    get softwareBuildID(): string | undefined;
    set softwareBuildID(id: string);
    get stackVersion(): number | undefined;
    set stackVersion(version: number);
    get zclVersion(): number | undefined;
    set zclVersion(version: number);
    get linkquality(): number | undefined;
    set linkquality(linkquality: number);
    get skipDefaultResponse(): boolean;
    set skipDefaultResponse(skipDefaultResponse: boolean);
    get customReadResponse(): CustomReadResponse | undefined;
    set customReadResponse(customReadResponse: CustomReadResponse | undefined);
    get checkinInterval(): number | undefined;
    set checkinInterval(checkinInterval: number | undefined);
    get pendingRequestTimeout(): number;
    set pendingRequestTimeout(pendingRequestTimeout: number);
    get customClusters(): CustomClusters;
    get gpSecurityKey(): number[] | undefined;
    get genBasic(): TPartialClusterAttributes<"genBasic">;
    meta: KeyValue;
    private static readonly devices;
    private static loadedFromDatabase;
    private static readonly deletedDevices;
    private static readonly nwkToIeeeCache;
    private constructor();
    createEndpoint(id: number): Endpoint;
    changeIeeeAddress(ieeeAddr: string): void;
    getEndpoint(id: number): Endpoint | undefined;
    getEndpointByDeviceType(deviceType: string): Endpoint | undefined;
    updateGenBasic(data: TPartialClusterAttributes<"genBasic">): void;
    implicitCheckin(): void;
    updateLastSeen(): void;
    private resetPendingRequestTimeout;
    private hasPendingRequests;
    onZclData(dataPayload: AdapterEvents.ZclPayload, frame: Zcl.Frame, endpoint: Endpoint): Promise<void>;
    /**
     * Reset runtime lookups.
     */
    static resetCache(): void;
    private static fromDatabaseEntry;
    private toDatabaseEntry;
    save(writeDatabase?: boolean): void;
    private static loadFromDatabaseIfNecessary;
    static find(ieeeOrNwkAddress: string | number, includeDeleted?: boolean): Device | undefined;
    static byIeeeAddr(ieeeAddr: string, includeDeleted?: boolean): Device | undefined;
    static byNetworkAddress(networkAddress: number, includeDeleted?: boolean): Device | undefined;
    static byType(type: DeviceType): Device[];
    /**
     * @deprecated use allIterator()
     */
    static all(): Device[];
    static allIterator(predicate?: (value: Device) => boolean): Generator<Device>;
    undelete(): void;
    static create(type: DeviceType, ieeeAddr: string, networkAddress: number, manufacturerID: number | undefined, manufacturerName: string | undefined, powerSource: string | undefined, modelID: string | undefined, interviewState: InterviewState, gpSecurityKey: number[] | undefined): Device;
    interview(ignoreCache?: boolean): Promise<void>;
    private interviewQuirks;
    private interviewInternal;
    updateNodeDescriptor(): Promise<void>;
    updateActiveEndpoints(): Promise<void>;
    /**
     * Request device to advertise its network address.
     * Note: This does not actually update the device property (if needed), as this is already done with `zdoResponse` event in Controller.
     */
    requestNetworkAddress(): Promise<void>;
    removeFromNetwork(): Promise<void>;
    removeFromDatabase(): void;
    lqi(): Promise<Lqi>;
    routingTable(): Promise<RoutingTable>;
    ping(disableRecovery?: boolean): Promise<void>;
    addCustomCluster(name: string, cluster: ClusterDefinition): void;
}
export default Device;
//# sourceMappingURL=device.d.ts.map