/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.swing.renderer;

import java.text.Format;
import java.text.MessageFormat;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;

public class FormattedLabelRenderer
extends LabelRenderer {
    private final Format format;

    public FormattedLabelRenderer(Format format) {
        this.format = format;
    }

    @Override
    public void setValue(Object value, int row) {
        super.setValue(this.getValueString(value, row, this.format), row);
    }

    protected String getValueString(Object value, int row, Format format) {
        if (format != null) {
            return FormattedLabelRenderer.formatImpl(format, value);
        }
        return value == null ? "null" : value.toString();
    }

    protected static String formatImpl(Format format, Object value) {
        if (format instanceof MessageFormat && !(value instanceof Object[])) {
            value = new Object[]{value};
        }
        return format.format(value);
    }
}

