/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.cache;

import java.io.Serializable;
import scala.$less$colon$less$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;

public abstract class ArtifactError
extends Exception {
    private final String type;
    private final String message;

    public String describe() {
        return this.getMessage();
    }

    public final boolean notFound() {
        ArtifactError artifactError = this;
        return artifactError instanceof NotFound;
    }

    public final boolean forbidden() {
        ArtifactError artifactError = this;
        return artifactError instanceof Forbidden;
    }

    /*
     * WARNING - void declaration
     */
    public ArtifactError(String type, String message, Option<Throwable> parentOpt) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.type = type;
        this.message = message;
        super(new StringBuilder(2).append((String)var1_1).append(": ").append((String)var2_2).toString(), (Throwable)var3_3.orNull($less$colon$less$.MODULE$.refl()));
    }

    /*
     * WARNING - void declaration
     */
    public ArtifactError(String type, String message) {
        this((String)var1_1, (String)var2_2, None$.MODULE$);
        void var2_2;
        void var1_1;
    }

    public static final class ChecksumErrors
    extends ArtifactError {
        private final Seq<Tuple2<String, String>> errors;

        /*
         * WARNING - void declaration
         */
        public ChecksumErrors(Seq<Tuple2<String, String>> errors) {
            void var1_1;
            this.errors = errors;
            super("checksum errors", ((IterableOnceOps)var1_1.map(new Serializable(){

                /*
                 * WARNING - void declaration
                 */
                public final String apply(Tuple2<String, String> x0$1) {
                    void var1_1;
                    if (x0$1 != null) {
                        void var2_2;
                        String k = x0$1._1();
                        String v = x0$1._2();
                        return new StringBuilder(2).append((String)var2_2).append(": ").append((String)var1_1).toString();
                    }
                    throw new MatchError(var1_1);
                }
            })).mkString(", "));
        }
    }

    public static final class ChecksumFormatError
    extends ArtifactError {
        private final String sumType;
        private final String file;

        /*
         * WARNING - void declaration
         */
        public ChecksumFormatError(String sumType, String file) {
            void var2_2;
            void var1_1;
            this.sumType = var1_1;
            this.file = file;
            super("checksum format error", (String)var2_2);
        }
    }

    public static final class ChecksumNotFound
    extends ArtifactError {
        private final String sumType;
        private final String file;

        /*
         * WARNING - void declaration
         */
        public ChecksumNotFound(String sumType, String file) {
            void var2_2;
            void var1_1;
            this.sumType = var1_1;
            this.file = file;
            super("checksum not found", (String)var2_2);
        }
    }

    public static final class DownloadError
    extends ArtifactError {
        /*
         * WARNING - void declaration
         */
        public DownloadError(String reason, Option<Throwable> e) {
            super("download error", (String)var1_1, (Option<Throwable>)var2_2);
            void var2_2;
            void var1_1;
        }
    }

    public static final class FileTooOldOrNotFound
    extends ArtifactError {
        private final String file;

        /*
         * WARNING - void declaration
         */
        public FileTooOldOrNotFound(String file) {
            void var1_1;
            this.file = file;
            super("file in cache not found or too old", (String)var1_1);
        }
    }

    public static final class Forbidden
    extends ArtifactError {
        private final String file;

        /*
         * WARNING - void declaration
         */
        public Forbidden(String file) {
            void var1_1;
            this.file = file;
            super("forbidden", (String)var1_1);
        }
    }

    public static final class ForbiddenChangingArtifact
    extends ArtifactError {
        private final String url;

        /*
         * WARNING - void declaration
         */
        public ForbiddenChangingArtifact(String url) {
            void var1_1;
            this.url = url;
            super("changing artifact found", (String)var1_1);
        }
    }

    public static final class NotFound
    extends ArtifactError {
        private final String file;
        private final Option<Object> permanent;

        public final Option<Object> permanent() {
            return this.permanent;
        }

        /*
         * WARNING - void declaration
         */
        public NotFound(String file, Option<Object> permanent) {
            void var1_1;
            void var2_2;
            this.file = file;
            this.permanent = var2_2;
            super("not found", (String)var1_1);
        }
    }

    public static final class Unauthorized
    extends ArtifactError {
        private final String file;
        private final Option<String> realm;

        /*
         * WARNING - void declaration
         */
        public Unauthorized(String file, Option<String> realm2) {
            void var2_2;
            void var1_1;
            this.file = file;
            this.realm = realm2;
            super("unauthorized", new StringBuilder(0).append((String)var1_1).append((Object)var2_2.fold(new Serializable(){

                public final String apply() {
                    return "";
                }
            }, new Serializable(){

                /*
                 * WARNING - void declaration
                 */
                public final String apply(String x$1) {
                    void var1_1;
                    return new StringBuilder(3).append(" (").append((String)var1_1).append(")").toString();
                }
            })).toString());
        }
    }

    public static final class WrongChecksum
    extends ArtifactError {
        private final String sumType;
        private final String got;
        private final String expected;
        private final String file;
        private final String sumFile;

        public final String sumFile() {
            return this.sumFile;
        }

        /*
         * WARNING - void declaration
         */
        public WrongChecksum(String sumType, String got, String expected, String file, String sumFile) {
            void var2_2;
            void var3_3;
            void var1_1;
            this.sumType = sumType;
            this.got = got;
            this.expected = expected;
            this.file = file;
            this.sumFile = sumFile;
            super("wrong checksum", new StringBuilder(23).append(file).append(" (expected ").append((String)var1_1).append(" ").append((String)var3_3).append(" in ").append(sumFile).append(", got ").append((String)var2_2).append(")").toString());
        }
    }

    public static final class WrongLength
    extends ArtifactError {
        private final long got;
        private final long expected;
        private final String file;

        /*
         * WARNING - void declaration
         */
        public WrongLength(long got, long expected, String file) {
            void var1_1;
            void var3_2;
            this.got = got;
            this.expected = expected;
            this.file = file;
            super("wrong length", new StringBuilder(22).append(file).append(" (expected ").append((long)var3_2).append(" B, got ").append((long)var1_1).append(" B)").toString());
        }
    }
}

