/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.assignment.contour;

import com.projectlibre1.algorithm.IntervalGenerator;
import com.projectlibre1.pm.assignment.Assignment;
import com.projectlibre1.pm.assignment.contour.AbstractContourBucket;
import com.projectlibre1.pm.assignment.contour.FillerContourBucket;
import com.projectlibre1.pm.assignment.contour.PersonalContourBucket;
import com.projectlibre1.pm.calendar.WorkCalendar;
import com.projectlibre1.pm.task.Project;

public class ContourBucketIntervalGenerator
implements IntervalGenerator {
    protected final int BEFORE_START = -1;
    protected final int AFTER_END = -2;
    protected long consumedDuration = 0L;
    protected int index = -1;
    long durationLeftUntilRemainingStartDependency = Long.MAX_VALUE;
    long start = 0L;
    long end;
    long assignmentDuration;
    long assignmentActualDuration = 0L;
    private AbstractContourBucket[] contourBuckets = null;
    WorkCalendar workCalendar;
    long splitAtDuration = Long.MAX_VALUE;
    long splitDuration = 0L;
    long remainingSplitBucketDuration = 0L;
    AbstractContourBucket specialBucket = null;
    boolean didSplit = false;
    boolean didFirstPart = false;

    public static ContourBucketIntervalGenerator getInstance(Assignment assignment, Object object) {
        return new ContourBucketIntervalGenerator(assignment, object);
    }

    protected ContourBucketIntervalGenerator(Assignment assignment, Object object) {
        long l;
        this.workCalendar = assignment.getEffectiveWorkCalendar();
        this.contourBuckets = assignment.getContour(object);
        this.assignmentDuration = assignment.getDurationMillis();
        this.assignmentActualDuration = assignment.getActualDuration();
        this.end = l = assignment.getStart();
        Project project = assignment.getTask().getProject();
        if (project != null && !project.isForward()) {
            return;
        }
        if (assignment.getDependencyStart() > l && assignment.getPercentComplete() > 0.0) {
            this.durationLeftUntilRemainingStartDependency = this.workCalendar.compare(assignment.getDependencyStart(), l, false);
            if (this.durationLeftUntilRemainingStartDependency > 0L && this.durationLeftUntilRemainingStartDependency > this.assignmentActualDuration) {
                this.splitAtDuration = this.assignmentActualDuration;
                this.splitDuration = this.durationLeftUntilRemainingStartDependency - this.assignmentActualDuration;
            }
        }
    }

    @Override
    public long currentEnd() {
        return this.end;
    }

    @Override
    public long currentStart() {
        return this.start;
    }

    @Override
    public Object current() {
        AbstractContourBucket abstractContourBucket = null;
        if (this.specialBucket != null) {
            abstractContourBucket = this.specialBucket;
        } else if (this.index >= 0) {
            abstractContourBucket = this.contourBuckets[this.index];
        }
        return abstractContourBucket;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.contourBuckets.length - 1;
    }

    @Override
    public boolean evaluate(Object object) {
        ++this.index;
        if (this.index == this.contourBuckets.length) {
            return false;
        }
        this.start = this.workCalendar.add(this.end, 0L, false);
        this.specialBucket = null;
        long l = this.contourBuckets[this.index].getBucketDuration(this.assignmentDuration);
        this.consumedDuration += l;
        if (this.consumedDuration >= this.splitAtDuration) {
            this.remainingSplitBucketDuration = this.consumedDuration - this.splitAtDuration;
            if ((l -= this.remainingSplitBucketDuration) > 0L) {
                this.specialBucket = PersonalContourBucket.getInstance(l, this.contourBuckets[this.index].getUnits());
                --this.index;
            }
            this.splitAtDuration = Long.MAX_VALUE;
            this.didFirstPart = true;
        }
        if (this.specialBucket == null && this.didFirstPart) {
            if (!this.didSplit) {
                l = this.splitDuration;
                this.specialBucket = FillerContourBucket.getInstance(this.splitDuration);
                --this.index;
                this.didSplit = true;
            } else {
                l = this.remainingSplitBucketDuration;
                double d = this.contourBuckets[this.index].getUnits();
                if (l > 0L) {
                    this.specialBucket = PersonalContourBucket.getInstance(this.remainingSplitBucketDuration, d);
                }
                this.remainingSplitBucketDuration = 0L;
                this.didFirstPart = false;
            }
        }
        this.end = this.workCalendar.add(this.end, l, true);
        return true;
    }

    public long getEnd() {
        return this.end;
    }

    public long getStart() {
        return this.start;
    }

    @Override
    public boolean isCurrentActive() {
        AbstractContourBucket abstractContourBucket = (AbstractContourBucket)this.current();
        return abstractContourBucket != null && abstractContourBucket.getUnits() != 0.0;
    }

    public WorkCalendar getWorkCalendar() {
        return this.workCalendar;
    }

    @Override
    public boolean canBeShared() {
        return false;
    }
}

