/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.rename;

import java.io.IOException;
import java.util.ArrayList;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedSupport;
import org.netbeans.modules.refactoring.php.rename.RenamePanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class PhpRenameRefactoringUI
implements RefactoringUI,
RefactoringUIBypass {
    private final AbstractRefactoring refactoring;
    private final String name;
    private final ElementKind kind;
    private RenamePanel panel;
    private final PhpElementKind phpKind;

    public PhpRenameRefactoringUI(WhereUsedSupport usage) {
        this.kind = usage.getElementKind();
        this.phpKind = usage.getPhpElementKind();
        this.name = PhpRenameRefactoringUI.getElementName(usage.getName(), this.kind);
        ArrayList<WhereUsedSupport> lookupContent = new ArrayList<WhereUsedSupport>();
        lookupContent.add(usage);
        this.refactoring = new RenameRefactoring(Lookups.fixed((Object[])lookupContent.toArray()));
        this.refactoring.getContext().add((Object)UI.Constants.REQUEST_PREVIEW);
    }

    static String getElementName(String name, ElementKind kind) {
        String retval = name;
        if (kind.equals((Object)ElementKind.VARIABLE) || kind.equals((Object)ElementKind.FIELD)) {
            while (retval.length() > 1 && retval.startsWith("$")) {
                retval = retval.substring(1);
            }
        }
        return retval;
    }

    public String getName() {
        return NbBundle.getMessage(PhpRenameRefactoringUI.class, (String)"LBL_Rename");
    }

    public String getDescription() {
        return NbBundle.getMessage(PhpRenameRefactoringUI.class, (String)"LBL_Rename_Descr");
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = new RenamePanel(this.name, this.phpKind, parent, NbBundle.getMessage(RenamePanel.class, (String)"LBL_Rename"), true, true);
        }
        return this.panel;
    }

    public Problem setParameters() {
        String newName = this.panel.getNameValue();
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(newName);
            ((RenameRefactoring)this.refactoring).getContext().add((Object)new RenameDeclarationFile(this.panel.renameDeclarationFile(), this.panel.lowerCaseFileName()));
        }
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        if (!this.panel.isUpdateReferences()) {
            return null;
        }
        boolean firstSet = false;
        if (this.refactoring instanceof RenameRefactoring) {
            RenameRefactoring renameRefactoring = (RenameRefactoring)this.refactoring;
            firstSet = renameRefactoring.getNewName() == null;
            renameRefactoring.setNewName(this.panel.getNameValue());
            renameRefactoring.getContext().add((Object)new RenameDeclarationFile(this.panel.renameDeclarationFile(), this.panel.lowerCaseFileName()));
        }
        if (firstSet) {
            return null;
        }
        return this.refactoring.checkParameters();
    }

    public boolean hasParameters() {
        return true;
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.refactoring.php.rename.PhpRenameRefactoringUI");
    }

    public boolean isRefactoringBypassRequired() {
        return false;
    }

    public void doRefactoringBypass() throws IOException {
    }

    public static final class RenameDeclarationFile {
        private final boolean renameDeclarationFile;
        private final boolean lowerCaseFileName;

        public RenameDeclarationFile(boolean renameDeclarationFile, boolean lowerCaseFileName) {
            this.renameDeclarationFile = renameDeclarationFile;
            this.lowerCaseFileName = lowerCaseFileName;
        }

        public boolean renameDeclarationFile() {
            return this.renameDeclarationFile;
        }

        public String adjustName(String newName) {
            return this.lowerCaseFileName ? newName.toLowerCase() : newName;
        }
    }
}

