/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.findusages;

import javax.swing.text.Position;
import org.netbeans.modules.refactoring.php.RefactoringUtils;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class WarningFileElement
implements RefactoringElementImplementation {
    private FileObject file;
    private PositionBounds bounds;

    public WarningFileElement(FileObject file) {
        this.file = file;
        this.bounds = null;
    }

    public String getText() {
        return NbBundle.getMessage(WarningFileElement.class, (String)"MSG_FILE_IS_NOT_OPEN");
    }

    public String getDisplayText() {
        return "<font color=\"#cc0000\">" + this.getText() + "</font>";
    }

    public boolean isEnabled() {
        return false;
    }

    public void setEnabled(boolean enabled) {
    }

    public void performChange() {
    }

    public void undoChange() {
    }

    public Lookup getLookup() {
        FileObject composite = this.file;
        return Lookups.singleton((Object)composite);
    }

    public FileObject getParentFile() {
        return this.file;
    }

    public PositionBounds getPosition() {
        if (this.bounds == null) {
            CloneableEditorSupport ces = RefactoringUtils.findCloneableEditorSupport(this.file);
            PositionRef ref1 = ces.createPositionRef(0, Position.Bias.Forward);
            PositionRef ref2 = ces.createPositionRef(0, Position.Bias.Forward);
            this.bounds = new PositionBounds(ref1, ref2);
        }
        return this.bounds;
    }

    public int getStatus() {
        return 1;
    }

    public void setStatus(int status) {
    }

    public void openInEditor() {
    }

    public void showPreview() {
    }
}

