/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.spi.IssueScheduleInfo;
import org.netbeans.modules.bugtracking.tasks.DashboardTopComponent;
import org.netbeans.modules.bugtracking.tasks.DashboardUtils;
import org.netbeans.modules.bugtracking.tasks.TaskNotificationPanel;
import org.netbeans.modules.bugtracking.tasks.TaskSchedulingManager;
import org.netbeans.modules.bugtracking.tasks.dashboard.DashboardViewer;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class NotificationManager {
    private static final ImageIcon DASHBOARD_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugtracking/tasks/resources/dashboard.png", (boolean)true);
    private static NotificationManager instance;
    private final TaskSchedulingManager schedulingManager;
    private ScheduleListener scheduleListener;
    private final DashboardViewer dashboardViewer;
    private Notification scheduleNotification = null;
    private final RequestProcessor rp = new RequestProcessor("Tasks Dashboard - Notifications");
    private List<IssueImpl> oldTasks = Collections.emptyList();
    private Calendar lastNotification;
    private final RequestProcessor.Task updateSchedule = this.rp.create(new Runnable(){

        @Override
        public void run() {
            NotificationManager.this.createScheduleNotification();
        }
    });

    private NotificationManager() {
        this.schedulingManager = TaskSchedulingManager.getInstance();
        this.dashboardViewer = DashboardViewer.getInstance();
    }

    public static NotificationManager getInstance() {
        if (instance == null) {
            instance = new NotificationManager();
        }
        return instance;
    }

    public void showNotifications() {
        this.updateSchedule.schedule(1000);
    }

    private void createScheduleNotification() {
        if (this.scheduleNotification != null) {
            this.scheduleNotification.clear();
        }
        this.removeListener();
        IssueScheduleInfo todayInfo = DashboardUtils.getToday();
        IssueImpl[] scheduledTasks = this.schedulingManager.getScheduledTasks(todayInfo, this.dashboardViewer.getRepositories(true).toArray(new RepositoryImpl[0]));
        this.addListener();
        List<IssueImpl> tasks = Arrays.asList(scheduledTasks);
        if (!this.scheduleChanged(this.oldTasks, tasks) && this.isNotFirstToday() || tasks.isEmpty()) {
            return;
        }
        NotificationDisplayer.Priority priority = NotificationDisplayer.Priority.NORMAL;
        if (this.isNotFirstToday()) {
            priority = NotificationDisplayer.Priority.SILENT;
        }
        this.oldTasks = tasks;
        this.lastNotification = Calendar.getInstance();
        TaskNotificationPanel bubblePanel = new TaskNotificationPanel(tasks, new SelectTodayCategory());
        TaskNotificationPanel notificationPanel = new TaskNotificationPanel(tasks, new SelectTodayCategory());
        String title = NbBundle.getMessage(NotificationManager.class, (String)"LBL_ScheduleTitle", (Object)tasks.size());
        this.scheduleNotification = NotificationDisplayer.getDefault().notify(title, (Icon)DASHBOARD_ICON, (JComponent)bubblePanel, (JComponent)notificationPanel, priority, NotificationDisplayer.Category.INFO);
        this.updateSchedule.schedule(DashboardUtils.getMillisToTomorrow());
    }

    private void addListener() {
        if (this.scheduleListener == null) {
            this.scheduleListener = new ScheduleListener();
        }
        this.schedulingManager.addPropertyChangeListener(this.scheduleListener);
    }

    private void removeListener() {
        if (this.scheduleListener != null) {
            this.schedulingManager.removePropertyChangeListener(this.scheduleListener);
        }
    }

    private boolean scheduleChanged(List<IssueImpl> oldTasks, List<IssueImpl> newTasks) {
        if (oldTasks.size() != newTasks.size()) {
            return true;
        }
        for (IssueImpl newTask : newTasks) {
            if (oldTasks.contains(newTask)) continue;
            return true;
        }
        return false;
    }

    private boolean isNotFirstToday() {
        Calendar todayCalendar = DashboardUtils.getTodayCalendar();
        return this.lastNotification != null && this.lastNotification.get(1) == todayCalendar.get(1) && this.lastNotification.get(6) == todayCalendar.get(6);
    }

    private class SelectTodayCategory
    extends AbstractAction {
        private SelectTodayCategory() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DashboardTopComponent tc = DashboardTopComponent.findInstance();
            tc.open();
            tc.requestActive();
            NotificationManager.this.dashboardViewer.showTodayCategory();
        }
    }

    private class ScheduleListener
    implements PropertyChangeListener {
        private ScheduleListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("TaskSchedulingManager.scheduledTasksChanged")) {
                NotificationManager.this.updateSchedule.schedule(1000);
            }
        }
    }
}

