/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.util;

import java.io.File;
import java.net.URI;
import java.util.regex.Pattern;
import org.openide.filesystems.FileUtil;

public class ConfigFiles {
    private static final Pattern RELATIVE_SLASH_SEPARATED_PATH = Pattern.compile("[^:/\\\\.][^:/\\\\]*(/[^:/\\\\.][^:/\\\\]*)*");

    private ConfigFiles() {
    }

    public static String getRelativePath(File basedir, File file) {
        String result = ConfigFiles.relativizeFile(basedir, file);
        if (result == null) {
            result = file.getAbsolutePath();
        }
        return result;
    }

    public static File resolveFile(File basedir, String filename) throws IllegalArgumentException {
        File f;
        if (basedir == null) {
            throw new NullPointerException("null basedir passed to resolveFile");
        }
        if (filename == null) {
            throw new NullPointerException("null filename passed to resolveFile");
        }
        if (!basedir.isAbsolute()) {
            throw new IllegalArgumentException("nonabsolute basedir passed to resolveFile: " + basedir);
        }
        if (RELATIVE_SLASH_SEPARATED_PATH.matcher(filename).matches()) {
            f = new File(basedir, filename.replace('/', File.separatorChar));
        } else {
            String machinePath = filename.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            f = new File(machinePath);
            if (!f.isAbsolute()) {
                f = new File(basedir, machinePath);
            }
            assert (f.isAbsolute());
        }
        return FileUtil.normalizeFile((File)f);
    }

    private static String relativizeFile(File basedir, File file) {
        if (basedir.isFile()) {
            throw new IllegalArgumentException("Cannot relative w.r.t. a data file " + basedir);
        }
        if (basedir.equals(file)) {
            return ".";
        }
        StringBuffer b = new StringBuffer();
        File base = basedir;
        String filepath = file.getAbsolutePath();
        while (!filepath.startsWith(ConfigFiles.slashify(base.getAbsolutePath()))) {
            if ((base = base.getParentFile()) == null) {
                return null;
            }
            if (base.equals(file)) {
                b.append("..");
                return b.toString();
            }
            b.append("../");
        }
        URI u = base.toURI().relativize(file.toURI());
        assert (!u.isAbsolute()) : u + " from " + basedir + " and " + file + " with common root " + base;
        b.append(u.getPath());
        if (b.charAt(b.length() - 1) == '/') {
            b.setLength(b.length() - 1);
        }
        return b.toString();
    }

    private static String slashify(String path) {
        if (path.endsWith(File.separator)) {
            return path;
        }
        return path + File.separatorChar;
    }
}

