/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.EventQueue;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.php.api.testing.PhpTesting;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.modules.php.project.ui.PathUiSupport;
import org.netbeans.modules.php.project.ui.customizer.Bundle;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.TestDirectoriesPathSupport;
import org.netbeans.modules.php.project.ui.customizer.TestingProviderPanel;
import org.netbeans.modules.php.spi.testing.PhpTestingProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class CustomizerTesting
extends JPanel {
    private static final long serialVersionUID = -654768735165768L;
    private final ProjectCustomizer.Category category;
    private final PhpProjectProperties uiProps;
    private final DefaultListModel<BasePathSupport.Item> testDirectoriesPathListModel;
    final Map<String, TestingProviderPanel> testingPanels;
    final Set<String> selectedTestingProviders = new TreeSet<String>();
    private JButton addFolderButton;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JLabel providersLabel;
    private JPanel providersPanel;
    private JButton removeButton;
    private JLabel testDirsLabel;
    private JList<BasePathSupport.Item> testDirsList;
    private JScrollPane testDirsScrollPane;

    CustomizerTesting(ProjectCustomizer.Category category, PhpProjectProperties uiProps, Map<String, TestingProviderPanel> testingPanels) {
        assert (category != null);
        assert (uiProps != null);
        assert (testingPanels != null);
        this.category = category;
        this.uiProps = uiProps;
        this.testingPanels = testingPanels;
        this.testDirectoriesPathListModel = uiProps.getTestDirectoriesListModel();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.initTestDirectories();
        this.initProvidersPanel();
    }

    private void initTestDirectories() {
        PathUiSupport.EditMediator.FileChooserDirectoryHandler directoryHandler = new PathUiSupport.EditMediator.FileChooserDirectoryHandler(){

            @Override
            public String getDirKey() {
                return CustomizerTesting.class.getName();
            }

            @Override
            public File getCurrentDirectory() {
                return FileUtil.toFile((FileObject)CustomizerTesting.this.uiProps.getProject().getProjectDirectory());
            }
        };
        this.testDirsList.setModel(this.testDirectoriesPathListModel);
        this.testDirsList.setCellRenderer(this.uiProps.getTestDirectoriesListRenderer());
        this.testDirectoriesPathListModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                CustomizerTesting.this.validateAndStore();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                CustomizerTesting.this.validateAndStore();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                CustomizerTesting.this.validateAndStore();
            }
        });
        PathUiSupport.EditMediator.register(this.uiProps.getProject(), this.testDirsList, this.addFolderButton.getModel(), this.removeButton.getModel(), this.moveUpButton.getModel(), this.moveDownButton.getModel(), directoryHandler);
    }

    private void initProvidersPanel() {
        List allTestingProviders = PhpTesting.getTestingProviders();
        if (allTestingProviders.isEmpty()) {
            this.category.setErrorMessage(Bundle.CustomizerTesting_testingProviders_noneInstalled());
            this.category.setValid(true);
            return;
        }
        List<String> currentTestingProviders = this.uiProps.getTestingProviders();
        GroupLayout providersPanelLayout = new GroupLayout(this.providersPanel);
        GroupLayout.ParallelGroup horizontalGroup = providersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.SequentialGroup verticalGroup = providersPanelLayout.createSequentialGroup();
        final Collator collator = Collator.getInstance();
        allTestingProviders.sort(new Comparator<PhpTestingProvider>(){

            @Override
            public int compare(PhpTestingProvider provider1, PhpTestingProvider provider2) {
                return collator.compare(provider1.getDisplayName(), provider2.getDisplayName());
            }
        });
        for (PhpTestingProvider testingProvider : allTestingProviders) {
            String identifier = testingProvider.getIdentifier();
            JCheckBox checkBox = new JCheckBox(testingProvider.getDisplayName());
            checkBox.addItemListener(new TestingProviderListener(identifier));
            if (currentTestingProviders.contains(identifier)) {
                checkBox.setSelected(true);
            }
            horizontalGroup.addComponent(checkBox);
            verticalGroup.addComponent(checkBox);
            verticalGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
        }
        this.providersPanel.setLayout(providersPanelLayout);
        providersPanelLayout.setHorizontalGroup(providersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(providersPanelLayout.createSequentialGroup().addContainerGap().addGroup(horizontalGroup).addContainerGap(-1, Short.MAX_VALUE)));
        providersPanelLayout.setVerticalGroup(providersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(verticalGroup));
        this.validateAndStore();
    }

    void validateAndStore() {
        this.validateData();
        this.storeData();
    }

    private void validateData() {
        assert (EventQueue.isDispatchThread());
        ValidationResult result = new TestDirectoriesPathSupport.Validator().validatePaths(this.uiProps.getProject(), this.convertToList(this.testDirectoriesPathListModel)).getResult();
        if (result.hasErrors()) {
            this.category.setErrorMessage(((ValidationResult.Message)result.getErrors().get(0)).getMessage());
            this.category.setValid(false);
            return;
        }
        if (result.hasWarnings()) {
            this.category.setErrorMessage(((ValidationResult.Message)result.getWarnings().get(0)).getMessage());
            this.category.setValid(true);
            return;
        }
        if (this.selectedTestingProviders.isEmpty()) {
            this.category.setErrorMessage(Bundle.CustomizerTesting_error_none());
            this.category.setValid(true);
            return;
        }
        this.category.setErrorMessage(" ");
        this.category.setValid(true);
    }

    private void storeData() {
        assert (EventQueue.isDispatchThread());
        this.uiProps.setTestingProviders(new ArrayList<String>(this.selectedTestingProviders));
    }

    private List<BasePathSupport.Item> convertToList(DefaultListModel<BasePathSupport.Item> listModel) {
        ArrayList<BasePathSupport.Item> items = new ArrayList<BasePathSupport.Item>(listModel.getSize());
        for (int i = 0; i < listModel.getSize(); ++i) {
            items.add(listModel.get(i));
        }
        return items;
    }

    private void initComponents() {
        this.testDirsLabel = new JLabel();
        this.testDirsScrollPane = new JScrollPane();
        this.testDirsList = new JList();
        this.addFolderButton = new JButton();
        this.removeButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.providersLabel = new JLabel();
        this.providersPanel = new JPanel();
        Mnemonics.setLocalizedText((JLabel)this.testDirsLabel, (String)NbBundle.getMessage(CustomizerTesting.class, (String)"CustomizerTesting.testDirsLabel.text"));
        this.testDirsScrollPane.setViewportView(this.testDirsList);
        Mnemonics.setLocalizedText((AbstractButton)this.addFolderButton, (String)NbBundle.getMessage(CustomizerTesting.class, (String)"CustomizerTesting.addFolderButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(CustomizerTesting.class, (String)"CustomizerTesting.removeButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)NbBundle.getMessage(CustomizerTesting.class, (String)"CustomizerTesting.moveUpButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)NbBundle.getMessage(CustomizerTesting.class, (String)"CustomizerTesting.moveDownButton.text"));
        Mnemonics.setLocalizedText((JLabel)this.providersLabel, (String)NbBundle.getMessage(CustomizerTesting.class, (String)"CustomizerTesting.providersLabel.text"));
        GroupLayout providersPanelLayout = new GroupLayout(this.providersPanel);
        this.providersPanel.setLayout(providersPanelLayout);
        providersPanelLayout.setHorizontalGroup(providersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 407, Short.MAX_VALUE));
        providersPanelLayout.setVerticalGroup(providersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 46, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.providersPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.testDirsScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addFolderButton, GroupLayout.Alignment.TRAILING).addComponent(this.removeButton, GroupLayout.Alignment.TRAILING).addComponent(this.moveUpButton, GroupLayout.Alignment.TRAILING).addComponent(this.moveDownButton, GroupLayout.Alignment.TRAILING))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.testDirsLabel).addComponent(this.providersLabel)).addGap(0, 0, Short.MAX_VALUE)));
        layout.linkSize(0, this.addFolderButton, this.moveDownButton, this.moveUpButton, this.removeButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.testDirsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.testDirsScrollPane, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.addFolderButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.moveUpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveDownButton))).addGap(18, 18, 18).addComponent(this.providersLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.providersPanel, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
    }

    private final class TestingProviderListener
    implements ItemListener {
        private final String testingProvider;

        public TestingProviderListener(String testingProvider) {
            this.testingProvider = testingProvider;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            assert (EventQueue.isDispatchThread());
            if (e.getStateChange() == 1) {
                boolean added = CustomizerTesting.this.selectedTestingProviders.add(this.testingProvider);
                assert (added) : "Provider " + this.testingProvider + " already present in " + CustomizerTesting.this.selectedTestingProviders;
                TestingProviderPanel panel = CustomizerTesting.this.testingPanels.get(this.testingProvider);
                if (panel != null) {
                    panel.showProviderPanel();
                }
            } else {
                boolean removed = CustomizerTesting.this.selectedTestingProviders.remove(this.testingProvider);
                assert (removed) : "Provider " + this.testingProvider + " not present in " + CustomizerTesting.this.selectedTestingProviders;
                TestingProviderPanel panel = CustomizerTesting.this.testingPanels.get(this.testingProvider);
                if (panel != null) {
                    panel.hideProviderPanel();
                }
            }
            CustomizerTesting.this.validateAndStore();
        }
    }
}

