/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.runconfigs.validation;

import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.netbeans.modules.php.project.connections.common.RemoteValidator;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.runconfigs.RunConfigRemote;
import org.netbeans.modules.php.project.runconfigs.validation.BaseRunConfigValidator;
import org.netbeans.modules.php.project.runconfigs.validation.Bundle;
import org.netbeans.modules.php.project.runconfigs.validation.RunConfigWebValidator;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsRemoteWeb;
import org.openide.util.NbBundle;

public final class RunConfigRemoteValidator {
    private RunConfigRemoteValidator() {
    }

    public static String validateNewProject(RunConfigRemote config) {
        return RunConfigRemoteValidator.validate(config, false);
    }

    public static String validateCustomizer(RunConfigRemote config) {
        return RunConfigRemoteValidator.validate(config, true);
    }

    public static String validateRemoteTransfer(RunConfigRemote config) {
        String error = RunConfigRemoteValidator.validateRemoteConfiguration(config.getRemoteConfiguration());
        if (error != null) {
            return error;
        }
        String uploadDirectory = config.getUploadDirectory();
        if (StringUtils.hasText((String)uploadDirectory) && (error = RunConfigRemoteValidator.validateUploadDirectory(uploadDirectory)) != null) {
            return error;
        }
        return null;
    }

    public static String validateConfigAction(RunConfigRemote config, boolean validateIndex) {
        return RunConfigRemoteValidator.validate(config, validateIndex);
    }

    private static String validate(RunConfigRemote config, boolean validateIndex) {
        String indexRelativePath;
        String error = RunConfigWebValidator.validateUrl(config.getUrl());
        if (error != null) {
            return error;
        }
        if (validateIndex && StringUtils.hasText((String)(indexRelativePath = config.getIndexRelativePath())) && (error = BaseRunConfigValidator.validateIndexFile(config.getIndexParentDir(), indexRelativePath)) != null) {
            return error;
        }
        error = RunConfigRemoteValidator.validateRemoteConfiguration(config.getRemoteConfiguration());
        if (error != null) {
            return error;
        }
        String uploadDirectory = config.getUploadDirectory();
        if (StringUtils.hasText((String)uploadDirectory) && (error = RunConfigRemoteValidator.validateUploadDirectory(uploadDirectory)) != null) {
            return error;
        }
        error = RunConfigRemoteValidator.validateUploadFilesType(config.getUploadFilesType());
        if (error != null) {
            return error;
        }
        return null;
    }

    static String validateRemoteConfiguration(RemoteConfiguration remoteConfiguration) {
        if (remoteConfiguration == null || remoteConfiguration == RunConfigRemote.NO_REMOTE_CONFIGURATION) {
            return NbBundle.getMessage(RunAsRemoteWeb.class, (String)"MSG_NoConfigurationSelected");
        }
        if (remoteConfiguration == RunConfigRemote.MISSING_REMOTE_CONFIGURATION) {
            return NbBundle.getMessage(RunAsRemoteWeb.class, (String)"MSG_NonExistingConfigurationSelected");
        }
        ValidationResult validationResult = RemoteConnections.get().validateRemoteConfiguration(remoteConfiguration);
        if (validationResult != null && validationResult.hasErrors()) {
            return Bundle.RunConfigRemoteValidator_error_remoteConnection(((ValidationResult.Message)validationResult.getErrors().get(0)).getMessage());
        }
        return null;
    }

    static String validateUploadDirectory(String uploadDirectory) {
        return RemoteValidator.validateUploadDirectory(uploadDirectory);
    }

    static String validateUploadFilesType(PhpProjectProperties.UploadFiles uploadFilesType) {
        if (uploadFilesType == null) {
            return Bundle.RunConfigRemoteValidator_error_uploadFilesType_none();
        }
        return null;
    }
}

