/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.runconfigs;

import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.netbeans.modules.php.project.connections.common.RemoteUtils;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.runconfigs.RunConfigWeb;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsRemoteWeb;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public final class RunConfigRemote
extends RunConfigWeb<RunConfigRemote> {
    public static final String NO_CONFIG_NAME = "no-config";
    public static final String MISSING_CONFIG_NAME = "missing-config";
    public static final RemoteConfiguration NO_REMOTE_CONFIGURATION = new RemoteConfiguration.Empty("no-config", NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_NoRemoteConfiguration"));
    public static final RemoteConfiguration MISSING_REMOTE_CONFIGURATION = new RemoteConfiguration.Empty("missing-config", NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_MissingRemoteConfiguration"));
    private RemoteConfiguration remoteConfiguration;
    private String uploadDirectory;
    private PhpProjectProperties.UploadFiles uploadFilesType;
    private boolean permissionsPreserved;
    private boolean uploadDirectly;

    private RunConfigRemote() {
    }

    public static PhpProjectProperties.RunAsType getRunAsType() {
        return PhpProjectProperties.RunAsType.REMOTE;
    }

    public static String getDisplayName() {
        return RunConfigRemote.getRunAsType().getLabel();
    }

    public static RunConfigRemote create() {
        return new RunConfigRemote();
    }

    public static RunConfigRemote forProject(final PhpProject project) {
        return (RunConfigRemote)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<RunConfigRemote>(){

            public RunConfigRemote run() {
                return ((RunConfigRemote)((RunConfigRemote)((RunConfigRemote)((RunConfigRemote)new RunConfigRemote().setUrl(ProjectPropertiesSupport.getUrl(project))).setIndexParentDir(FileUtil.toFile((FileObject)ProjectPropertiesSupport.getWebRootDirectory(project)))).setIndexRelativePath(ProjectPropertiesSupport.getIndexFile(project))).setArguments(ProjectPropertiesSupport.getArguments(project))).setRemoteConfiguration(RemoteConnections.get().remoteConfigurationForName(ProjectPropertiesSupport.getRemoteConnection(project))).setUploadDirectory(ProjectPropertiesSupport.getRemoteDirectory(project)).setUploadFilesType(ProjectPropertiesSupport.getRemoteUpload(project)).setPermissionsPreserved(ProjectPropertiesSupport.areRemotePermissionsPreserved(project)).setUploadDirectly(ProjectPropertiesSupport.isRemoteUploadDirectly(project));
            }
        });
    }

    public String getRemoteConnectionHint() {
        if (this.remoteConfiguration == null || this.remoteConfiguration == NO_REMOTE_CONFIGURATION || this.remoteConfiguration == MISSING_REMOTE_CONFIGURATION) {
            return null;
        }
        return this.remoteConfiguration.getUrl(RemoteUtils.sanitizeUploadDirectory(this.uploadDirectory, true));
    }

    public String getSanitizedUploadDirectory() {
        return RemoteUtils.sanitizeUploadDirectory(this.uploadDirectory, true);
    }

    public PhpProjectProperties.UploadFiles getUploadFilesType() {
        return this.uploadFilesType;
    }

    public RunConfigRemote setUploadFilesType(PhpProjectProperties.UploadFiles uploadFilesType) {
        this.uploadFilesType = uploadFilesType;
        return this;
    }

    public RemoteConfiguration getRemoteConfiguration() {
        return this.remoteConfiguration;
    }

    public RunConfigRemote setRemoteConfiguration(RemoteConfiguration remoteConfiguration) {
        this.remoteConfiguration = remoteConfiguration;
        return this;
    }

    public String getUploadDirectory() {
        return this.uploadDirectory;
    }

    public RunConfigRemote setUploadDirectory(String uploadDirectory) {
        this.uploadDirectory = uploadDirectory;
        return this;
    }

    public boolean arePermissionsPreserved() {
        return this.permissionsPreserved;
    }

    public RunConfigRemote setPermissionsPreserved(boolean permissionsPreserved) {
        this.permissionsPreserved = permissionsPreserved;
        return this;
    }

    public boolean getUploadDirectly() {
        return this.uploadDirectly;
    }

    public RunConfigRemote setUploadDirectly(boolean uploadDirectly) {
        this.uploadDirectly = uploadDirectly;
        return this;
    }
}

