/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.spi.project.support.ant.EditableProperties;

public final class ProjectUpgrader {
    private static final Map<String, String> UPGRADE_KEYS = new HashMap<String, String>();
    private final PhpProject project;
    private static final String PHP_UNIT_BOOTSTRAP = "phpunit.bootstrap";
    private static final String PHP_UNIT_CONFIGURATION = "phpunit.configuration";
    private static final String PHP_UNIT_SUITE = "phpunit.suite";
    private static final String PHP_UNIT_SCRIPT = "phpunit.script";

    public ProjectUpgrader(PhpProject project) {
        this.project = project;
    }

    public void upgrade() {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                ProjectUpgrader.this.upgradeProjectProperties();
            }
        });
    }

    void upgradeProjectProperties() {
        EditableProperties properties = this.project.getHelper().getProperties("nbproject/project.properties");
        this.upgradePhpUnit(properties);
        for (Map.Entry<String, String> entry : UPGRADE_KEYS.entrySet()) {
            String property = properties.getProperty(entry.getKey());
            if (property == null) continue;
            properties.remove((Object)entry.getKey());
            properties.put(entry.getValue(), property);
        }
        this.project.getHelper().putProperties("nbproject/project.properties", properties);
    }

    private static void setPhpUnitKeys() {
        UPGRADE_KEYS.put(PHP_UNIT_BOOTSTRAP, "auxiliary.org-netbeans-modules-php-phpunit.bootstrap_2e_path");
        UPGRADE_KEYS.put("phpunit.bootstrap.create.tests", "auxiliary.org-netbeans-modules-php-phpunit.bootstrap_2e_create_2e_tests");
        UPGRADE_KEYS.put(PHP_UNIT_CONFIGURATION, "auxiliary.org-netbeans-modules-php-phpunit.configuration_2e_path");
        UPGRADE_KEYS.put(PHP_UNIT_SUITE, "auxiliary.org-netbeans-modules-php-phpunit.customSuite_2e_path");
        UPGRADE_KEYS.put(PHP_UNIT_SCRIPT, "auxiliary.org-netbeans-modules-php-phpunit.phpUnit_2e_path");
        UPGRADE_KEYS.put("phpunit.run.test.files", "auxiliary.org-netbeans-modules-php-phpunit.test_2e_run_2e_all");
        UPGRADE_KEYS.put("phpunit.test.groups.ask", "auxiliary.org-netbeans-modules-php-phpunit.test_2e_groups_2e_ask");
        UPGRADE_KEYS.put("phpunit.test.groups.last.used", "auxiliary.org-netbeans-modules-php-phpunit.test_2e_groups");
    }

    private void upgradePhpUnit(EditableProperties properties) {
        HashMap<String, String> newlyEnabledProperties = new HashMap<String, String>();
        newlyEnabledProperties.put(PHP_UNIT_BOOTSTRAP, "auxiliary.org-netbeans-modules-php-phpunit.bootstrap_2e_enabled");
        newlyEnabledProperties.put(PHP_UNIT_CONFIGURATION, "auxiliary.org-netbeans-modules-php-phpunit.configuration_2e_enabled");
        newlyEnabledProperties.put(PHP_UNIT_SUITE, "auxiliary.org-netbeans-modules-php-phpunit.customSuite_2e_enabled");
        newlyEnabledProperties.put(PHP_UNIT_SCRIPT, "auxiliary.org-netbeans-modules-php-phpunit.phpUnit_2e_enabled");
        for (Map.Entry entry : newlyEnabledProperties.entrySet()) {
            if (!StringUtils.hasText((String)properties.get(entry.getKey()))) continue;
            properties.setProperty((String)entry.getValue(), "true");
        }
    }

    static {
        ProjectUpgrader.setPhpUnitKeys();
    }
}

