/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.jtreg;

import java.io.File;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.openjdk.common.BuildUtils;
import org.netbeans.modules.java.openjdk.common.ShortcutUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class Utilities {
    public static boolean isJDKRepository(FileObject root) {
        if (root == null) {
            return false;
        }
        FileObject srcDir = BuildUtils.getFileObject(root, "src");
        if (srcDir == null) {
            return false;
        }
        if (BuildUtils.getFileObject(srcDir, "share/classes") != null) {
            return true;
        }
        for (FileObject mod : srcDir.getChildren()) {
            if (BuildUtils.getFileObject(mod, "share/classes") == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isLangtoolsRepository(FileObject root) {
        return (BuildUtils.getFileObject(root, "src/share/classes/com/sun/tools/javac/main/Main.java") != null || BuildUtils.getFileObject(root, "src/jdk.compiler/share/classes/com/sun/tools/javac/main/Main.java") != null) && BuildUtils.getFileObject(root, "src/java.base/share/classes/java/lang/Object.java") == null;
    }

    public static FileObject getLangtoolsKeyRoot(FileObject root) {
        FileObject jdkCompiler = BuildUtils.getFileObject(root, "src/jdk.compiler/share/classes");
        if (jdkCompiler != null) {
            return jdkCompiler;
        }
        jdkCompiler = root.getFileObject("src/jdk.compiler/share/classes");
        if (jdkCompiler != null) {
            return jdkCompiler;
        }
        return BuildUtils.getFileObject(root, "src/share/classes");
    }

    public static File jtregOutputDir(FileObject testFile) {
        File buildDir = BuildUtils.getBuildTargetDir(testFile);
        Project prj = FileOwnerQuery.getOwner((FileObject)testFile);
        if (buildDir != null) {
            FileObject repo = prj.getProjectDirectory().getParent().getParent();
            if (repo.getNameExt().equals("langtools") && ShortcutUtils.getDefault().shouldUseCustomTest(repo.getNameExt(), FileUtil.getRelativePath((FileObject)repo, (FileObject)testFile))) {
                buildDir = new File(FileUtil.toFile((FileObject)prj.getProjectDirectory()), "../../build");
            } else if ("langtools".equals(ShortcutUtils.getDefault().inferLegacyRepository(prj)) && ShortcutUtils.getDefault().shouldUseCustomTest(repo.getNameExt(), FileUtil.getRelativePath((FileObject)repo, (FileObject)testFile))) {
                buildDir = new File(FileUtil.toFile((FileObject)prj.getProjectDirectory()), "../../build/langtools");
            }
        } else {
            buildDir = new File(FileUtil.toFile((FileObject)prj.getProjectDirectory()), "../../../build");
        }
        return new File(buildDir, "nb-jtreg").toPath().normalize().toFile();
    }
}

