/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SVNRevisionRange
implements Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    private SVNRevision from;
    private SVNRevision to;

    public SVNRevisionRange(SVNRevision from, SVNRevision to) {
        this.from = from;
        this.to = to;
    }

    public SVNRevisionRange(SVNRevision.Number from, SVNRevision.Number to, boolean convertToNMinusOne) {
        this.from = convertToNMinusOne ? new SVNRevision.Number(from.getNumber() - 1L) : from;
        this.to = to;
    }

    public SVNRevisionRange(String revisionElement) {
        if (revisionElement == null) {
            return;
        }
        int hyphen = revisionElement.indexOf(45);
        if (hyphen > 0) {
            try {
                long fromRev = Long.parseLong(revisionElement.substring(0, hyphen));
                long toRev = Long.parseLong(revisionElement.substring(hyphen + 1));
                this.from = new SVNRevision.Number(fromRev);
                this.to = new SVNRevision.Number(toRev);
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        try {
            long revNum = Long.parseLong(revisionElement.trim());
            this.to = this.from = new SVNRevision.Number(revNum);
        }
        catch (NumberFormatException e) {
            return;
        }
    }

    public SVNRevision getFromRevision() {
        return this.from;
    }

    public SVNRevision getToRevision() {
        return this.to;
    }

    public String toString() {
        if (this.from != null && this.to != null) {
            if (this.from.equals(this.to)) {
                return this.from.toString();
            }
            return this.from.toString() + '-' + this.to.toString();
        }
        return super.toString();
    }

    public static Long getRevisionAsLong(SVNRevision rev) {
        long val = 0L;
        if (rev != null && rev instanceof SVNRevision.Number) {
            val = ((SVNRevision.Number)rev).getNumber();
        }
        return new Long(val);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        return result;
    }

    public boolean equals(Object range) {
        if (this == range) {
            return true;
        }
        if (!super.equals(range)) {
            return false;
        }
        if (this.getClass() != range.getClass()) {
            return false;
        }
        SVNRevisionRange other = (SVNRevisionRange)range;
        if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
            return false;
        }
        return !(this.to == null ? other.to != null : !this.to.equals(other.to));
    }

    public int compareTo(Object range) {
        if (this == range) {
            return 0;
        }
        SVNRevision other = ((SVNRevisionRange)range).getFromRevision();
        return SVNRevisionRange.getRevisionAsLong(this.getFromRevision()).compareTo(SVNRevisionRange.getRevisionAsLong(other));
    }

    public static SVNRevisionRange[] getRevisions(SVNRevision.Number[] selectedRevisions, SVNRevision.Number[] allRevisions) {
        Arrays.sort(selectedRevisions);
        Arrays.sort(allRevisions);
        ArrayList<SVNRevisionRange> svnRevisionRanges = new ArrayList<SVNRevisionRange>();
        SVNRevision.Number fromRevision = null;
        SVNRevision.Number toRevision = null;
        int j = 0;
        for (int i = 0; i < selectedRevisions.length; ++i) {
            if (fromRevision == null) {
                fromRevision = selectedRevisions[i];
                while (allRevisions[j++].getNumber() != selectedRevisions[i].getNumber()) {
                }
            } else if (selectedRevisions[i].getNumber() != allRevisions[j++].getNumber()) {
                SVNRevisionRange revisionRange = new SVNRevisionRange(fromRevision, toRevision, true);
                svnRevisionRanges.add(revisionRange);
                fromRevision = selectedRevisions[i];
                while (allRevisions[j++].getNumber() != selectedRevisions[i].getNumber()) {
                }
            }
            toRevision = selectedRevisions[i];
        }
        if (toRevision != null) {
            SVNRevisionRange revisionRange = new SVNRevisionRange(fromRevision, toRevision, true);
            svnRevisionRanges.add(revisionRange);
        }
        SVNRevisionRange[] revisionRangeArray = new SVNRevisionRange[svnRevisionRanges.size()];
        svnRevisionRanges.toArray(revisionRangeArray);
        return revisionRangeArray;
    }

    public boolean contains(SVNRevision revision, boolean inclusiveFromRev) {
        long fromRev = SVNRevisionRange.getRevisionAsLong(this.from);
        long toRev = SVNRevisionRange.getRevisionAsLong(this.to);
        long rev = SVNRevisionRange.getRevisionAsLong(revision);
        if (inclusiveFromRev) {
            return rev >= fromRev && (this.to.equals(SVNRevision.HEAD) || rev <= toRev);
        }
        return rev > fromRev && (this.to.equals(SVNRevision.HEAD) || rev <= toRev);
    }

    public String toMergeString() {
        long toRev;
        long fromRev = SVNRevisionRange.getRevisionAsLong(this.from);
        if (fromRev + 1L == (toRev = SVNRevisionRange.getRevisionAsLong(this.to).longValue())) {
            return "-c " + toRev;
        }
        return "-r " + fromRev + ":" + toRev;
    }
}

