/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.awt.Dialog;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.j2ee.dd.api.common.SecurityRole;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.ddloaders.multiview.InnerTableModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.EjbRefsTablePanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityRolePanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityRoleTablePanel;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class EjbJarSecurityRolesTableModel
extends InnerTableModel {
    private static final String[] COLUMN_NAMES = new String[]{Utils.getBundleMessage("LBL_RoleName"), Utils.getBundleMessage("LBL_Description")};
    private static final int[] COLUMN_WIDTHS = new int[]{170, 250};
    private AssemblyDescriptor assemblyDesc;
    private EjbJar ejbJar;

    public EjbJarSecurityRolesTableModel(XmlMultiViewDataSynchronizer synchronizer, EjbJar ejbJar) {
        super(synchronizer, COLUMN_NAMES, COLUMN_WIDTHS);
        this.ejbJar = ejbJar;
        this.assemblyDesc = ejbJar.getSingleAssemblyDescriptor();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        SecurityRole role = this.assemblyDesc.getSecurityRole(rowIndex);
        switch (columnIndex) {
            case 0: {
                role.setRoleName((String)value);
                break;
            }
            case 1: {
                role.setDescription((String)value);
            }
        }
        this.modelUpdatedFromUI();
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public int getRowCount() {
        if (this.assemblyDesc == null) {
            return 0;
        }
        return this.assemblyDesc.getSecurityRole().length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SecurityRole role = this.assemblyDesc.getSecurityRole(rowIndex);
        switch (columnIndex) {
            case 0: {
                return role.getRoleName();
            }
            case 1: {
                return role.getDefaultDescription();
            }
        }
        return null;
    }

    @Override
    public int addRow() {
        if (this.assemblyDesc == null) {
            this.assemblyDesc = this.getAssemblyDesc();
        }
        final SecurityRolePanel dialogPanel = new SecurityRolePanel();
        Object currentRoleName = null;
        EditDialog dialog = new EditDialog(dialogPanel, NbBundle.getMessage(EjbRefsTablePanel.class, (String)"TTL_SecurityRole"), true){

            protected String validate() {
                String name = dialogPanel.getRoleName().trim();
                if (name.length() == 0) {
                    return NbBundle.getMessage(SecurityRoleTablePanel.class, (String)"TXT_EmptySecurityRoleName");
                }
                SecurityRole[] roles = EjbJarSecurityRolesTableModel.this.assemblyDesc.getSecurityRole();
                boolean exists = false;
                for (int i = 0; i < roles.length; ++i) {
                    if (!name.equals(roles[i].getRoleName())) continue;
                    return NbBundle.getMessage(SecurityRoleTablePanel.class, (String)"TXT_SecurityRoleNameExists", (Object)name);
                }
                return null;
            }
        };
        dialog.setValid(false);
        EditDialog.DocListener docListener = new EditDialog.DocListener(dialog);
        dialogPanel.getRoleNameTF().getDocument().addDocumentListener((DocumentListener)docListener);
        dialogPanel.getDescriptionTA().getDocument().addDocumentListener((DocumentListener)docListener);
        Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
        d.setVisible(true);
        dialogPanel.getRoleNameTF().getDocument().removeDocumentListener((DocumentListener)docListener);
        dialogPanel.getDescriptionTA().getDocument().removeDocumentListener((DocumentListener)docListener);
        if (dialog.getValue().equals(EditDialog.OK_OPTION)) {
            SecurityRole role = this.assemblyDesc.newSecurityRole();
            role.setRoleName(dialogPanel.getRoleName());
            role.setDescription(dialogPanel.getDescription());
            this.assemblyDesc.addSecurityRole(role);
            this.modelUpdatedFromUI();
        }
        return this.getRowCount() - 1;
    }

    @Override
    public void removeRow(int row) {
        SecurityRole role = this.assemblyDesc.getSecurityRole(row);
        this.assemblyDesc.removeSecurityRole(role);
        this.modelUpdatedFromUI();
    }

    private AssemblyDescriptor getAssemblyDesc() {
        AssemblyDescriptor assemblyDesc = this.ejbJar.getSingleAssemblyDescriptor();
        if (assemblyDesc == null) {
            assemblyDesc = this.ejbJar.newAssemblyDescriptor();
            this.ejbJar.setAssemblyDescriptor(assemblyDesc);
        }
        return assemblyDesc;
    }
}

