/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.builder.event;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.event.DocumentBuilderEvent;

public class BeginSpanEvent
extends DocumentBuilderEvent {
    private final DocumentBuilder.SpanType type;
    private final Attributes attributes;

    public BeginSpanEvent(DocumentBuilder.SpanType type, Attributes attributes) {
        this.type = (DocumentBuilder.SpanType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"Must provide type"));
        this.attributes = ((Attributes)Preconditions.checkNotNull((Object)attributes, (Object)"Must provide attributes")).clone();
    }

    @Override
    public void invoke(DocumentBuilder builder) {
        builder.beginSpan(this.type, this.attributes);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BeginSpanEvent)) {
            return false;
        }
        BeginSpanEvent other = (BeginSpanEvent)obj;
        return this.type == other.type;
    }

    public String toString() {
        return String.format("beginSpan(%s)", new Object[]{this.type});
    }
}

