/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.parse.compact;

import com.thaiopensource.relaxng.parse.BuildException;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.IncludedGrammar;
import com.thaiopensource.relaxng.parse.ParsedPattern;
import com.thaiopensource.relaxng.parse.SchemaBuilder;
import com.thaiopensource.relaxng.parse.Scope;
import com.thaiopensource.relaxng.parse.SubParseable;
import com.thaiopensource.relaxng.parse.compact.CompactSyntax;
import com.thaiopensource.relaxng.parse.compact.UriOpener;
import com.thaiopensource.util.Uri;
import com.thaiopensource.xml.util.EncodingMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class CompactParseable
implements SubParseable {
    private final InputSource in;
    private final UriOpener opener;
    private final ErrorHandler eh;
    private static final String UTF8 = EncodingMap.getJavaName("UTF-8");
    private static final String UTF16 = EncodingMap.getJavaName("UTF-16");

    public CompactParseable(InputSource inputSource, UriOpener uriOpener, ErrorHandler errorHandler) {
        this.in = inputSource;
        this.opener = uriOpener;
        this.eh = errorHandler;
    }

    public ParsedPattern parse(SchemaBuilder schemaBuilder, Scope scope) throws BuildException, IllegalSchemaException {
        return new CompactSyntax(this.makeReader(this.in), this.in.getSystemId(), schemaBuilder, this.eh).parse(scope);
    }

    public SubParseable createSubParseable(String string, String string2) throws BuildException {
        return new CompactParseable(this.opener.resolve(string, string2), this.opener, this.eh);
    }

    public ParsedPattern parseAsInclude(SchemaBuilder schemaBuilder, IncludedGrammar includedGrammar) throws BuildException, IllegalSchemaException {
        return new CompactSyntax(this.makeReader(this.in), this.in.getSystemId(), schemaBuilder, this.eh).parseInclude(includedGrammar);
    }

    public String getUri() {
        return Uri.escapeDisallowedChars(this.in.getSystemId());
    }

    private Reader makeReader(InputSource inputSource) throws BuildException {
        inputSource = this.opener.open(inputSource);
        try {
            Reader reader = inputSource.getCharacterStream();
            if (reader == null) {
                InputStream inputStream = inputSource.getByteStream();
                String string = inputSource.getEncoding();
                if (string == null) {
                    PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 2);
                    string = CompactParseable.detectEncoding(pushbackInputStream);
                    inputStream = pushbackInputStream;
                }
                reader = new InputStreamReader(inputStream, string);
            }
            return reader;
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    private static String detectEncoding(PushbackInputStream pushbackInputStream) throws IOException {
        String string = UTF8;
        int n = pushbackInputStream.read();
        if (n != -1) {
            int n2 = pushbackInputStream.read();
            if (n2 != -1) {
                pushbackInputStream.unread(n2);
                if (n == 255 && n2 == 254 || n == 254 && n2 == 255) {
                    string = UTF16;
                }
            }
            pushbackInputStream.unread(n);
        }
        return string;
    }
}

