/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.GroupTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.InputDialog;
import org.openide.util.NbBundle;

public class SecurityEditGroupPanel
extends JPanel {
    private final ResourceBundle customizerBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.Bundle");
    private final GroupTableModel groupModel;
    private final String originalGroupName;
    private String groupName;
    private JLabel jLblGroupName;
    private JTextField jTxtGroupName;

    public SecurityEditGroupPanel(String entry, GroupTableModel gml) {
        this.groupModel = gml;
        this.originalGroupName = this.groupName = entry;
        this.initComponents();
        this.initUserComponents();
        this.initFields();
    }

    protected String getGroupName() {
        return this.groupName;
    }

    protected String getOriginalGroupName() {
        return this.originalGroupName;
    }

    private void initComponents() {
        this.jLblGroupName = new JLabel();
        this.jTxtGroupName = new JTextField();
        this.setLayout(new GridBagLayout());
        this.jLblGroupName.setLabelFor(this.jTxtGroupName);
        this.jLblGroupName.setText(this.customizerBundle.getString("LBL_GroupName_1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 11, 0, 0);
        this.add((Component)this.jLblGroupName, gridBagConstraints);
        this.jTxtGroupName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SecurityEditGroupPanel.this.jTxtGroupNameKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 11);
        this.add((Component)this.jTxtGroupName, gridBagConstraints);
        this.jTxtGroupName.getAccessibleContext().setAccessibleName(this.customizerBundle.getString("ACSN_GroupName"));
        this.jTxtGroupName.getAccessibleContext().setAccessibleDescription(this.customizerBundle.getString("ACSD_GroupName"));
    }

    private void jTxtGroupNameKeyReleased(KeyEvent evt) {
        this.groupName = this.jTxtGroupName.getText();
        this.firePropertyChange("UserDataChanged", null, null);
    }

    private void initUserComponents() {
        this.getAccessibleContext().setAccessibleName(this.customizerBundle.getString("ACSN_EditGroupName"));
        this.getAccessibleContext().setAccessibleDescription(this.customizerBundle.getString("ACSD_EditGroupName"));
    }

    private void initFields() {
        this.jTxtGroupName.setText(this.groupName);
    }

    Collection getErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        String newGroupName = this.getGroupName();
        if (!Utils.notEmpty(newGroupName)) {
            errors.add(this.customizerBundle.getString("ERR_BlankGroupName"));
        }
        if (newGroupName != null && !newGroupName.equals(this.getOriginalGroupName()) && this.groupModel.contains(newGroupName)) {
            errors.add(MessageFormat.format(this.customizerBundle.getString("ERR_GroupExists"), newGroupName));
        }
        return errors;
    }

    static void editGroupName(JPanel parent, String entry, GroupTableModel model) {
        SecurityEditGroupPanel editGroupPanel = new SecurityEditGroupPanel(entry, model);
        editGroupPanel.displayDialog(parent, NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.configbean.customizers.Bundle").getString("TITLE_EditGroup"), "AS_CFG_SecurityRoleEditGroup");
    }

    private void displayDialog(JPanel parent, String title, String helpId) {
        BetterInputDialog dialog = new BetterInputDialog(parent, title, helpId, this);
        do {
            int dialogChoice = dialog.display();
            if (dialogChoice == 0) break;
            if (dialogChoice != 1) continue;
            Collection errors = this.getErrors();
            String newGrouplName = this.getGroupName();
            String oldGroupName = this.getOriginalGroupName();
            if (dialog.hasErrors()) {
                dialog.showErrors();
                continue;
            }
            if (Utils.strEquals(newGrouplName, oldGroupName)) continue;
            this.groupModel.replaceElement(oldGroupName, newGrouplName);
        } while (dialog.hasErrors());
    }

    private static class BetterInputDialog
    extends InputDialog {
        private final SecurityEditGroupPanel dialogPanel;
        private final String panelHelpId;

        public BetterInputDialog(JPanel parent, String title, String helpId, SecurityEditGroupPanel childPanel) {
            super(parent, title);
            this.dialogPanel = childPanel;
            this.panelHelpId = helpId;
            this.dialogPanel.setPreferredSize(new Dimension(parent.getWidth() * 3 / 4, this.dialogPanel.getPreferredSize().height));
            this.getAccessibleContext().setAccessibleName(this.dialogPanel.getAccessibleContext().getAccessibleName());
            this.getAccessibleContext().setAccessibleDescription(this.dialogPanel.getAccessibleContext().getAccessibleDescription());
            this.getContentPane().add((Component)childPanel, "Center");
            this.addListeners();
            this.pack();
            this.setLocationInside(parent);
            this.handleErrorDisplay();
        }

        private void addListeners() {
            this.dialogPanel.addPropertyChangeListener("UserDataChanged", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    this.handleErrorDisplay();
                }
            });
        }

        private void handleErrorDisplay() {
            ArrayList errors = new ArrayList();
            errors.addAll(this.dialogPanel.getErrors());
            this.setErrors(errors);
        }

        @Override
        protected String getHelpId() {
            return this.panelHelpId;
        }
    }
}

