/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.expr.InvocationExceptionTranslated;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.visual.JavaComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.RemoteAWTScreenshot;
import org.netbeans.modules.debugger.jpda.visual.RemoteServices;
import org.netbeans.modules.debugger.jpda.visual.breakpoints.AWTComponentBreakpointImpl;
import org.netbeans.modules.debugger.jpda.visual.options.Options;
import org.netbeans.modules.debugger.jpda.visual.ui.ScreenshotComponent;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class VisualDebuggerListener
extends DebuggerManagerAdapter {
    private static final Logger logger = Logger.getLogger(VisualDebuggerListener.class.getName());
    private static final Map<JPDADebugger, Map<ObjectReference, JavaComponentInfo.Stack>> componentsAndStackTraces = new WeakHashMap<JPDADebugger, Map<ObjectReference, JavaComponentInfo.Stack>>();
    private final Map<DebuggerEngine, Collection<Breakpoint>> helperComponentBreakpointsMap = new HashMap<DebuggerEngine, Collection<Breakpoint>>();
    private final Properties properties;
    private volatile Boolean isTrackComponentChanges = null;

    public VisualDebuggerListener() {
        final RequestProcessor rp = new RequestProcessor(VisualDebuggerListener.class);
        this.properties = Options.getProperties();
        if (RemoteAWTScreenshot.FAST_SNAPSHOT_RETRIEVAL) {
            this.properties.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String pName = evt.getPropertyName();
                    if ("TrackComponentChanges".equals(pName)) {
                        final Object newValue = evt.getNewValue();
                        if (VisualDebuggerListener.this.isTrackComponentChanges != null && !VisualDebuggerListener.this.isTrackComponentChanges.equals(newValue)) {
                            rp.post(new Runnable(){

                                @Override
                                public void run() {
                                    RemoteServices.attachHierarchyListeners(Boolean.TRUE.equals(newValue), RemoteServices.ServiceType.AWT);
                                }
                            });
                            VisualDebuggerListener.this.isTrackComponentChanges = Boolean.TRUE.equals(newValue);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineAdded(DebuggerEngine engine) {
        MethodBreakpoint[] mb;
        final JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
        if (debugger == null) {
            return;
        }
        boolean uploadAgent = Options.isUploadAgent();
        logger.log(Level.FINE, "engineAdded({0}), debugger = {1}, uploadAgent = {2}", new Object[]{engine, debugger, uploadAgent});
        ArrayList<Object> helperComponentBreakpoints = new ArrayList<Object>();
        if (debugger != null && uploadAgent) {
            final AtomicBoolean[] inited = new AtomicBoolean[]{new AtomicBoolean(false), new AtomicBoolean(false)};
            mb = new MethodBreakpoint[]{MethodBreakpoint.create((String)"java.awt.EventQueue", (String)"getNextEvent"), MethodBreakpoint.create((String)"com.sun.javafx.tk.quantum.QuantumToolkit", (String)"pulse")};
            mb[0].setBreakpointType(1);
            mb[0].setSuspend(1);
            mb[0].setHidden(true);
            mb[0].addJPDABreakpointListener(new JPDABreakpointListener(){

                public void breakpointReached(JPDABreakpointEvent event) {
                    if (debugger.equals(event.getDebugger())) {
                        RemoteServiceInit initRet;
                        DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)mb[0]);
                        if (inited[0].compareAndSet(false, true) && (initRet = VisualDebuggerListener.this.initDebuggerRemoteService(event.getThread(), RemoteServices.ServiceType.AWT)) == RemoteServiceInit.FAIL_RETRY) {
                            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb[0]);
                            inited[0].set(false);
                        }
                    }
                    event.resume();
                }
            });
            mb[1].setBreakpointType(1);
            mb[1].setSuspend(1);
            mb[1].setHidden(true);
            mb[1].addJPDABreakpointListener(new JPDABreakpointListener(){

                public void breakpointReached(JPDABreakpointEvent event) {
                    if (debugger.equals(event.getDebugger())) {
                        RemoteServiceInit initRet;
                        DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)mb[1]);
                        if (inited[1].compareAndSet(false, true) && (initRet = VisualDebuggerListener.this.initDebuggerRemoteService(event.getThread(), RemoteServices.ServiceType.FX)) == RemoteServiceInit.FAIL_RETRY) {
                            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb[1]);
                            inited[1].set(false);
                        }
                    }
                    event.resume();
                }
            });
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb[0]);
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb[1]);
            helperComponentBreakpoints.add(mb[0]);
            helperComponentBreakpoints.add(mb[1]);
        }
        if (debugger != null) {
            boolean trackComponentChanges = Options.isTrackComponentChanges();
            this.isTrackComponentChanges = trackComponentChanges;
            if (trackComponentChanges) {
                if (!RemoteAWTScreenshot.FAST_SNAPSHOT_RETRIEVAL) {
                    MethodBreakpoint cmb = MethodBreakpoint.create((String)"java.awt.Component", (String)"createHierarchyEvents");
                    cmb.setHidden(true);
                    cmb.addJPDABreakpointListener(new JPDABreakpointListener(){

                        public void breakpointReached(JPDABreakpointEvent event) {
                            VisualDebuggerListener.componentParentChanged(debugger, event, RemoteServices.ServiceType.AWT);
                            event.resume();
                        }
                    });
                    DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)cmb);
                    helperComponentBreakpoints.add(cmb);
                }
                mb = MethodBreakpoint.create((String)"javafx.scene.Node", (String)"setParent");
                mb.setHidden(true);
                mb.addJPDABreakpointListener(new JPDABreakpointListener(){

                    public void breakpointReached(JPDABreakpointEvent event) {
                        VisualDebuggerListener.componentParentChanged(debugger, event, RemoteServices.ServiceType.FX);
                        event.resume();
                    }
                });
                DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb);
                helperComponentBreakpoints.add(mb);
            }
        }
        Map<DebuggerEngine, Collection<Breakpoint>> map = this.helperComponentBreakpointsMap;
        synchronized (map) {
            this.helperComponentBreakpointsMap.put(engine, helperComponentBreakpoints);
        }
    }

    /*
     * Exception decompiling
     */
    private RemoteServiceInit initDebuggerRemoteService(JPDAThread thread, RemoteServices.ServiceType sType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void initException(InvocationExceptionTranslated iextr, JPDAThreadImpl t) {
        iextr.setPreferredThread(t);
        iextr.getMessage();
        iextr.getLocalizedMessage();
        Throwable cause = iextr.getCause();
        iextr.getStackTrace();
        if (cause instanceof InvocationExceptionTranslated) {
            this.initException((InvocationExceptionTranslated)cause, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineRemoved(DebuggerEngine engine) {
        Collection<Breakpoint> helperComponentBreakpoints;
        ScreenshotComponent.closeScreenshots(engine);
        JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
        if (debugger == null) {
            return;
        }
        logger.log(Level.FINE, "engineRemoved({0}), debugger = {1}", new Object[]{engine, debugger});
        this.stopDebuggerRemoteService(debugger);
        Map<Object, Object> map = this.helperComponentBreakpointsMap;
        synchronized (map) {
            helperComponentBreakpoints = this.helperComponentBreakpointsMap.remove(engine);
        }
        if (helperComponentBreakpoints != null && !helperComponentBreakpoints.isEmpty()) {
            Iterator<Breakpoint> it = helperComponentBreakpoints.iterator();
            while (it.hasNext()) {
                DebuggerManager.getDebuggerManager().removeBreakpoint(it.next());
            }
            helperComponentBreakpoints.clear();
        }
        map = componentsAndStackTraces;
        synchronized (map) {
            componentsAndStackTraces.remove(debugger);
        }
    }

    private void stopDebuggerRemoteService(JPDADebugger d) {
        ClassObjectReference serviceClass = RemoteServices.getServiceClass(d, RemoteServices.ServiceType.AWT);
        if (serviceClass == null) {
            return;
        }
        try {
            ReferenceType serviceType = serviceClass.reflectedType();
            Field awtAccessLoop = serviceType.fieldByName("awtAccessLoop");
            if (awtAccessLoop != null) {
                ((ClassType)serviceType).setValue(awtAccessLoop, serviceClass.virtualMachine().mirrorOf(false));
            }
            serviceClass.enableCollection();
        }
        catch (VMDisconnectedException serviceType) {
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaComponentInfo.Stack getStackOf(JPDADebugger debugger, ObjectReference component) {
        Map<JPDADebugger, Map<ObjectReference, JavaComponentInfo.Stack>> map = componentsAndStackTraces;
        synchronized (map) {
            Map<ObjectReference, JavaComponentInfo.Stack> cs = componentsAndStackTraces.get(debugger);
            if (cs != null) {
                return cs.get(component);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void componentParentChanged(JPDADebugger debugger, JPDABreakpointEvent event, RemoteServices.ServiceType serviceType) {
        Object t2;
        ObjectReference component = null;
        ObjectReference[] parentPtr = null;
        try {
            if (RemoteServices.ServiceType.AWT.equals((Object)serviceType)) {
                parentPtr = new ObjectReference[]{null};
                component = AWTComponentBreakpointImpl.getComponentOfParentChanged(event, parentPtr);
            } else {
                t2 = event.getThread();
                JDIVariable v = (JDIVariable)t2.getCallStack(0, 1)[0].getThisVariable();
                component = (ObjectReference)v.getJDIValue();
            }
        }
        catch (Exception t2) {
            // empty catch block
        }
        if (component != null) {
            JavaComponentInfo.Stack stack;
            if (parentPtr != null && parentPtr[0] == null) {
                t2 = componentsAndStackTraces;
                synchronized (t2) {
                    Map<ObjectReference, JavaComponentInfo.Stack> componentAndStackTrace = componentsAndStackTraces.get(debugger);
                    if (componentAndStackTrace != null) {
                        componentAndStackTrace.remove(component);
                    }
                }
                return;
            }
            try {
                stack = new JavaComponentInfo.Stack(event.getThread().getCallStack());
            }
            catch (AbsentInformationException ex) {
                return;
            }
            Map<JPDADebugger, Map<ObjectReference, JavaComponentInfo.Stack>> map = componentsAndStackTraces;
            synchronized (map) {
                Map<ObjectReference, JavaComponentInfo.Stack> componentAndStackTrace = componentsAndStackTraces.get(debugger);
                if (componentAndStackTrace == null) {
                    componentAndStackTrace = new HashMap<ObjectReference, JavaComponentInfo.Stack>();
                    componentsAndStackTraces.put(debugger, componentAndStackTrace);
                }
                componentAndStackTrace.put(component, stack);
            }
        }
    }

    private static void setFxDebug(VirtualMachine vm, ThreadReference tr) {
        ClassType sysPropClass = VisualDebuggerListener.getClass(vm, tr, "com.sun.javafx.runtime.SystemProperties");
        if (sysPropClass == null) {
            return;
        }
        try {
            Field debugFld = ReferenceTypeWrapper.fieldByName((ReferenceType)sysPropClass, (String)"isDebug");
            sysPropClass.setValue(debugFld, VirtualMachineWrapper.mirrorOf((VirtualMachine)vm, (boolean)true));
        }
        catch (VMDisconnectedExceptionWrapper debugFld) {
        }
        catch (InternalExceptionWrapper debugFld) {
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static ClassType getClass(VirtualMachine vm, ThreadReference tr, String name) {
        ReferenceType t = VisualDebuggerListener.getType(vm, tr, name);
        if (t instanceof ClassType) {
            return (ClassType)t;
        }
        return null;
    }

    private static ReferenceType getType(VirtualMachine vm, ThreadReference tr, String name) {
        try {
            List classList = VirtualMachineWrapper.classesByName((VirtualMachine)vm, (String)name);
            if (!classList.isEmpty()) {
                return (ReferenceType)classList.iterator().next();
            }
            List classClassList = VirtualMachineWrapper.classesByName((VirtualMachine)vm, (String)"java.lang.Class");
            if (classClassList.isEmpty()) {
                throw new IllegalStateException("Cannot load class Class");
            }
            ClassType cls = (ClassType)classClassList.iterator().next();
            Method m = ClassTypeWrapper.concreteMethodByName((ClassType)cls, (String)"forName", (String)"(Ljava/lang/String;)Ljava/lang/Class;");
            StringReference mirrorOfName = VirtualMachineWrapper.mirrorOf((VirtualMachine)vm, (String)name);
            try {
                cls.invokeMethod(tr, m, Collections.singletonList(mirrorOfName), 1);
                List classList2 = VirtualMachineWrapper.classesByName((VirtualMachine)vm, (String)name);
                if (!classList2.isEmpty()) {
                    return (ReferenceType)classList2.iterator().next();
                }
            }
            catch (InvalidTypeException ex) {
                logger.log(Level.FINE, "Cannot load class " + name, ex);
            }
            catch (ClassNotLoadedException ex) {
                logger.log(Level.FINE, "Cannot load class " + name, ex);
            }
            catch (IncompatibleThreadStateException ex) {
                logger.log(Level.FINE, "Cannot load class " + name, ex);
            }
            catch (InvocationException ex) {
                logger.log(Level.FINE, "Cannot load class " + name, ex);
            }
        }
        catch (ClassNotPreparedExceptionWrapper ex) {
            logger.log(Level.FINE, "Not prepared class ", ex);
        }
        catch (UnsupportedOperationExceptionWrapper unsupportedOperationExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
        return null;
    }

    private static enum RemoteServiceInit {
        SUCCESS,
        FAIL,
        FAIL_RETRY;

    }
}

