/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.prefs;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.multitabs.impl.ProjectSupport;
import org.netbeans.core.multitabs.prefs.MultiTabsOptionsPanelController;
import org.netbeans.core.multitabs.prefs.SettingsImpl;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class InnerTabsPanel
extends JPanel {
    private final SettingsImpl settings = new SettingsImpl();
    private final MultiTabsOptionsPanelController controller;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    JCheckBox checkMultiRow;
    JCheckBox checkProjectColors;
    JCheckBox checkShowFolderName;
    JCheckBox checkShowFullPath;
    JCheckBox checkSortDocumentList;
    JLabel jLabel1;
    JRadioButton radioPlacementBottom;
    JRadioButton radioPlacementLeft;
    JRadioButton radioPlacementRight;
    JRadioButton radioPlacementTop;
    JRadioButton radioRowCount;
    JRadioButton radioRowPerProject;
    JSpinner spinRowCount;

    public InnerTabsPanel(MultiTabsOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InnerTabsPanel.this.fireChanged();
                InnerTabsPanel.this.enableControls();
            }
        };
        this.radioPlacementBottom.addItemListener(listener);
        this.radioPlacementLeft.addItemListener(listener);
        this.radioPlacementRight.addItemListener(listener);
        this.radioPlacementTop.addItemListener(listener);
        this.checkShowFolderName.addItemListener(listener);
        this.checkShowFullPath.addItemListener(listener);
        this.checkProjectColors.addItemListener(listener);
        this.checkSortDocumentList.addItemListener(listener);
        this.checkMultiRow.addItemListener(listener);
        this.radioRowCount.addItemListener(listener);
        this.radioRowPerProject.addItemListener(listener);
        this.spinRowCount.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                InnerTabsPanel.this.fireChanged();
            }
        });
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.radioRowCount = new JRadioButton();
        this.spinRowCount = new JSpinner();
        this.radioRowPerProject = new JRadioButton();
        this.checkSortDocumentList = new JCheckBox();
        this.checkMultiRow = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.checkProjectColors = new JCheckBox();
        this.radioPlacementRight = new JRadioButton();
        this.radioPlacementBottom = new JRadioButton();
        this.radioPlacementLeft = new JRadioButton();
        this.radioPlacementTop = new JRadioButton();
        this.checkShowFullPath = new JCheckBox();
        this.checkShowFolderName = new JCheckBox();
        this.buttonGroup2.add(this.radioRowCount);
        this.radioRowCount.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.radioRowCount, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.radioRowCount.text"));
        this.spinRowCount.setModel(new SpinnerNumberModel(3, 2, 10, 1));
        this.buttonGroup2.add(this.radioRowPerProject);
        Mnemonics.setLocalizedText((AbstractButton)this.radioRowPerProject, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.radioRowPerProject.text"));
        this.radioRowPerProject.setActionCommand(NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.radioRowPerProject.actionCommand"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkSortDocumentList, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.checkSortDocumentList.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkMultiRow, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.checkMultiRow.text"));
        this.checkMultiRow.setActionCommand(NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.checkMultiRow.actionCommand"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkProjectColors, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.checkProjectColors.text"));
        this.checkProjectColors.setActionCommand(NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.checkProjectColors.actionCommand"));
        this.buttonGroup1.add(this.radioPlacementRight);
        Mnemonics.setLocalizedText((AbstractButton)this.radioPlacementRight, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.radioPlacementRight.text"));
        this.buttonGroup1.add(this.radioPlacementBottom);
        Mnemonics.setLocalizedText((AbstractButton)this.radioPlacementBottom, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.radioPlacementBottom.text"));
        this.buttonGroup1.add(this.radioPlacementLeft);
        Mnemonics.setLocalizedText((AbstractButton)this.radioPlacementLeft, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.radioPlacementLeft.text"));
        this.buttonGroup1.add(this.radioPlacementTop);
        this.radioPlacementTop.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.radioPlacementTop, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.radioPlacementTop.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkShowFullPath, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.checkShowFullPath.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkShowFolderName, (String)NbBundle.getMessage(InnerTabsPanel.class, (String)"InnerTabsPanel.checkShowFolderName.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radioPlacementLeft).addComponent(this.radioPlacementTop).addComponent(this.radioPlacementBottom).addComponent(this.radioPlacementRight)))).addGap(161, 161, 161)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkShowFolderName).addComponent(this.checkShowFullPath)).addGap(18, 18, 18))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkMultiRow).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radioRowPerProject).addGroup(layout.createSequentialGroup().addComponent(this.radioRowCount).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinRowCount, -2, -1, -2)))).addComponent(this.checkProjectColors).addComponent(this.checkSortDocumentList)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.radioPlacementTop).addGap(0, 0, 0).addComponent(this.radioPlacementLeft).addGap(0, 0, 0).addComponent(this.radioPlacementBottom).addGap(0, 0, 0).addComponent(this.radioPlacementRight)).addGroup(layout.createSequentialGroup().addComponent(this.checkMultiRow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spinRowCount, -2, -1, -2).addComponent(this.radioRowCount)).addGap(0, 0, 0).addComponent(this.radioRowPerProject))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.checkProjectColors).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkSortDocumentList)).addGroup(layout.createSequentialGroup().addComponent(this.checkShowFolderName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkShowFullPath))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void fireChanged() {
        boolean isChanged = false;
        if (this.checkShowFolderName.isSelected() != this.settings.isShowFolderName() || this.checkShowFullPath.isSelected() != this.settings.isShowFullPath() || this.checkProjectColors.isSelected() != this.settings.isSameProjectSameColor() || this.checkSortDocumentList.isSelected() != this.settings.isSortDocumentListByProject()) {
            isChanged = true;
        }
        int rowCount = this.settings.getRowCount();
        if (this.checkMultiRow.isSelected() && this.radioRowCount.isSelected()) {
            rowCount = ((Number)this.spinRowCount.getValue()).intValue();
        }
        if (this.checkMultiRow.isSelected() != (rowCount > 1 || this.settings.isTabRowPerProject())) {
            isChanged = true;
        }
        if (rowCount != this.settings.getRowCount()) {
            isChanged = true;
        }
        if (this.radioRowPerProject.isSelected() != this.settings.isTabRowPerProject()) {
            isChanged = true;
        }
        if (this.radioPlacementBottom.isSelected() && this.settings.getTabsLocation() != 3 || this.radioPlacementLeft.isSelected() && this.settings.getTabsLocation() != 2 || this.radioPlacementRight.isSelected() && this.settings.getTabsLocation() != 4 || this.radioPlacementTop.isSelected() && this.settings.getTabsLocation() != 1) {
            isChanged = true;
        }
        this.controller.changed(null, isChanged);
    }

    void load() {
        ProjectSupport projectSupport = ProjectSupport.getDefault();
        switch (this.settings.getTabsLocation()) {
            case 2: {
                this.radioPlacementLeft.setSelected(true);
                break;
            }
            case 4: {
                this.radioPlacementRight.setSelected(true);
                break;
            }
            case 3: {
                this.radioPlacementBottom.setSelected(true);
                break;
            }
            default: {
                this.radioPlacementTop.setSelected(true);
            }
        }
        this.checkShowFolderName.setSelected(this.settings.isShowFolderName());
        this.checkShowFullPath.setSelected(this.settings.isShowFullPath());
        this.checkProjectColors.setSelected(this.settings.isSameProjectSameColor());
        this.checkSortDocumentList.setSelected(this.settings.isSortDocumentListByProject());
        int rowCount = this.settings.getRowCount();
        this.checkMultiRow.setSelected(rowCount > 1 || this.settings.isTabRowPerProject());
        if (rowCount > 1) {
            this.spinRowCount.getModel().setValue(rowCount);
        }
        this.radioRowPerProject.setSelected(this.settings.isTabRowPerProject());
        this.radioRowCount.setSelected(rowCount > 1);
        this.radioRowPerProject.setVisible(projectSupport.isEnabled());
        this.checkProjectColors.setVisible(projectSupport.isEnabled());
        this.checkSortDocumentList.setVisible(projectSupport.isEnabled());
        this.enableControls();
    }

    boolean store() {
        boolean changed = false;
        int placement = 1;
        if (this.radioPlacementBottom.isSelected()) {
            placement = 3;
        } else if (this.radioPlacementLeft.isSelected()) {
            placement = 2;
        } else if (this.radioPlacementRight.isSelected()) {
            placement = 4;
        }
        changed |= this.settings.setTabsLocation(placement);
        changed |= this.settings.setShowFullPath(this.checkShowFullPath.isSelected());
        changed |= this.settings.setSameProjectSameColor(this.checkProjectColors.isSelected());
        int rowCount = 1;
        if (this.checkMultiRow.isSelected() && this.radioRowCount.isSelected()) {
            rowCount = ((Number)this.spinRowCount.getValue()).intValue();
        }
        changed |= this.settings.setRowCount(rowCount);
        changed |= this.settings.setTabRowPerProject(this.radioRowPerProject.isSelected() && this.checkMultiRow.isSelected());
        changed |= this.settings.setShowFolderName(this.checkShowFolderName.isSelected());
        return changed |= this.settings.setSortDocumentListByProject(this.checkSortDocumentList.isSelected());
    }

    private void enableControls() {
        boolean horizontalOrientation = this.radioPlacementTop.isSelected() || this.radioPlacementBottom.isSelected();
        this.checkShowFullPath.setEnabled(horizontalOrientation);
        this.checkMultiRow.setEnabled(horizontalOrientation);
        if (!horizontalOrientation) {
            this.checkMultiRow.setSelected(false);
            this.checkShowFullPath.setSelected(false);
        }
        this.radioRowCount.setEnabled(this.checkMultiRow.isSelected());
        this.radioRowPerProject.setEnabled(this.checkMultiRow.isSelected());
        this.spinRowCount.setEnabled(this.checkMultiRow.isSelected() && horizontalOrientation && this.radioRowCount.isSelected());
    }
}

