/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.nodes;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.hudson.api.HudsonFolder;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.ui.OpenableInBrowser;
import org.netbeans.modules.hudson.ui.actions.OpenUrlAction;
import org.netbeans.modules.hudson.ui.nodes.HudsonJobNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Union2;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

class HudsonFolderNode
extends AbstractNode {
    private static final Node iconDelegate = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
    private final HudsonFolder folder;

    HudsonFolderNode(HudsonFolder folder) {
        super(Children.create((ChildFactory)new HudsonFolderChildren(folder), (boolean)true), Lookups.singleton((Object)folder));
        this.folder = folder;
        String name = folder.getName();
        this.setName(name);
        this.setDisplayName(!name.contains("/") ? name : name.substring(name.lastIndexOf("/") + 1, name.length()));
    }

    public Image getIcon(int type) {
        return iconDelegate.getIcon(type);
    }

    public Image getOpenedIcon(int type) {
        return iconDelegate.getOpenedIcon(type);
    }

    public Action[] getActions(boolean context) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (this.folder instanceof OpenableInBrowser) {
            actions.add(OpenUrlAction.forOpenable((OpenableInBrowser)this.folder));
        }
        return actions.toArray(new Action[0]);
    }

    private static final class HudsonFolderChildren
    extends ChildFactory.Detachable<Union2<HudsonJob, HudsonFolder>>
    implements ChangeListener {
        private final HudsonFolder folder;

        HudsonFolderChildren(HudsonFolder folder) {
            this.folder = folder;
        }

        protected boolean createKeys(List<Union2<HudsonJob, HudsonFolder>> toPopulate) {
            for (HudsonFolder subfolder : this.folder.getFolders()) {
                toPopulate.add((Union2<HudsonJob, HudsonFolder>)Union2.createSecond((Object)subfolder));
            }
            for (HudsonJob job : this.folder.getJobs()) {
                toPopulate.add((Union2<HudsonJob, HudsonFolder>)Union2.createFirst((Object)job));
            }
            return true;
        }

        protected Node createNodeForKey(Union2<HudsonJob, HudsonFolder> key) {
            return key.hasFirst() ? new HudsonJobNode((HudsonJob)key.first()) : new HudsonFolderNode((HudsonFolder)key.second());
        }

        protected void addNotify() {
            this.folder.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.folder));
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh(false);
        }
    }
}

