/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.commons.ScheduledTaskManager;
import com.sun.xml.ws.rx.rm.runtime.DestinationMessageHandler;
import com.sun.xml.ws.rx.rm.runtime.OutboundDeliveredHandler;
import com.sun.xml.ws.rx.rm.runtime.RmConfiguration;
import com.sun.xml.ws.rx.rm.runtime.RmRuntimeVersion;
import com.sun.xml.ws.rx.rm.runtime.SourceMessageHandler;
import com.sun.xml.ws.rx.rm.runtime.WsrmProtocolHandler;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManagerFactory;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import com.sun.xml.ws.rx.rm.runtime.transaction.TransactionHandler;
import com.sun.xml.ws.rx.rm.runtime.transaction.TransactionHandlerImpl;
import com.sun.xml.ws.rx.util.Communicator;
import com.sun.xml.ws.rx.util.SuspendedFiberStorage;
import java.util.concurrent.atomic.AtomicBoolean;

public final class RuntimeContext {
    public final RmConfiguration configuration;
    public final AddressingVersion addressingVersion;
    public final SOAPVersion soapVersion;
    public final RmRuntimeVersion rmVersion;
    private volatile SequenceManager sequenceManager;
    public final Communicator communicator;
    public final SuspendedFiberStorage suspendedFiberStorage;
    public final WsrmProtocolHandler protocolHandler;
    public final ScheduledTaskManager scheduledTaskManager;
    final SourceMessageHandler sourceMessageHandler;
    final DestinationMessageHandler destinationMessageHandler;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    public final TransactionHandler transactionHandler;
    public final OutboundDeliveredHandler outboundDeliveredHandler;
    private volatile String userStateID;

    public static Builder builder(@NotNull RmConfiguration configuration, @NotNull Communicator communicator) {
        return new Builder(configuration, communicator);
    }

    private RuntimeContext(RmConfiguration configuration, SequenceManager sequenceManager, Communicator communicator, SuspendedFiberStorage suspendedFiberStorage, ScheduledTaskManager scheduledTaskManager, SourceMessageHandler srcMsgHandler, DestinationMessageHandler dstMsgHandler, TransactionHandler txHandler, OutboundDeliveredHandler outboundDeliveredHandler) {
        this.configuration = configuration;
        this.sequenceManager = sequenceManager;
        this.communicator = communicator;
        this.suspendedFiberStorage = suspendedFiberStorage;
        this.scheduledTaskManager = scheduledTaskManager;
        this.sourceMessageHandler = srcMsgHandler;
        this.destinationMessageHandler = dstMsgHandler;
        this.addressingVersion = configuration.getAddressingVersion();
        this.soapVersion = configuration.getSoapVersion();
        this.rmVersion = configuration.getRuntimeVersion();
        this.protocolHandler = WsrmProtocolHandler.getInstance(configuration, communicator, this);
        this.transactionHandler = txHandler;
        this.outboundDeliveredHandler = outboundDeliveredHandler;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.scheduledTaskManager.shutdown();
            this.communicator.close();
            if (this.sequenceManager != null) {
                SequenceManagerFactory.INSTANCE.dispose(this.sequenceManager, this.configuration);
            }
        }
    }

    public String getBoundSequenceId(String sequenceId) throws UnknownSequenceException {
        assert (this.sequenceManager != null);
        Sequence boundSequence = this.sequenceManager.getBoundSequence(sequenceId);
        return boundSequence != null ? boundSequence.getId() : null;
    }

    public SequenceManager sequenceManager() {
        assert (this.sequenceManager != null);
        return this.sequenceManager;
    }

    public void setSequenceManager(@NotNull SequenceManager newValue) {
        assert (newValue != null);
        this.sequenceManager = newValue;
        this.sourceMessageHandler.setSequenceManager(newValue);
        this.destinationMessageHandler.setSequenceManager(newValue);
    }

    public String getUserStateID() {
        return this.userStateID;
    }

    public void setUserStateID(String userStateId) {
        assert (userStateId != null && userStateId.length() <= 256);
        this.userStateID = userStateId;
    }

    public static final class Builder {
        @NotNull
        private final RmConfiguration configuration;
        @NotNull
        private final Communicator communicator;
        @Nullable
        private SequenceManager sequenceManager;
        @Nullable
        private SourceMessageHandler sourceMessageHandler;
        @Nullable
        private DestinationMessageHandler destinationMessageHandler;
        @Nullable
        private TransactionHandler transactionHandler;
        @Nullable
        OutboundDeliveredHandler outboundDeliveredHandler;

        public Builder(@NotNull RmConfiguration configuration, @NotNull Communicator communicator) {
            assert (configuration != null);
            assert (communicator != null);
            this.configuration = configuration;
            this.communicator = communicator;
            this.sourceMessageHandler = new SourceMessageHandler(null);
            this.destinationMessageHandler = new DestinationMessageHandler(null);
            this.transactionHandler = new TransactionHandlerImpl();
            this.outboundDeliveredHandler = new OutboundDeliveredHandler();
        }

        public Builder sequenceManager(SequenceManager sequenceManager) {
            this.sequenceManager = sequenceManager;
            this.sourceMessageHandler.setSequenceManager(sequenceManager);
            this.destinationMessageHandler.setSequenceManager(sequenceManager);
            return this;
        }

        public RuntimeContext build() {
            return new RuntimeContext(this.configuration, this.sequenceManager, this.communicator, new SuspendedFiberStorage(), new ScheduledTaskManager("RM Runtime Context", this.communicator.getContainer()), this.sourceMessageHandler, this.destinationMessageHandler, this.transactionHandler, this.outboundDeliveredHandler);
        }
    }
}

