/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.soap;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.soap.SOAPRequestSerializer;
import com.sun.xml.rpc.encoding.soap.SOAPResponseStructure;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPEncodingConstants;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class SOAPResponseSerializer
extends SOAPRequestSerializer
implements Initializable {
    private static final QName RETURN_VALUE_QNAME = new QName("return");
    private static final QName[] EMPTY_QNAME_ARRAY = new QName[0];
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    protected QName returnXmlType;
    protected Class returnJavaType;
    protected JAXRPCSerializer returnSerializer;
    protected JAXRPCDeserializer returnDeserializer;
    protected boolean isReturnVoid;
    private SOAPEncodingConstants soapEncodingConstants = null;

    private void init(SOAPVersion ver) {
        this.soapEncodingConstants = SOAPConstantsFactory.getSOAPEncodingConstants(ver);
    }

    public SOAPResponseSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, QName[] parameterNames, QName[] parameterXmlTypes, Class[] parameterClasses, QName returnXmlType, Class returnJavaType) {
        this(type, encodeType, isNullable, encodingStyle, parameterNames, parameterXmlTypes, parameterClasses, returnXmlType, returnJavaType, SOAPVersion.SOAP_11);
    }

    public SOAPResponseSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, QName[] parameterNames, QName[] parameterXmlTypes, Class[] parameterClasses, QName returnXmlType, Class returnJavaType, SOAPVersion ver) {
        super(type, encodeType, isNullable, encodingStyle, parameterNames, parameterXmlTypes, parameterClasses);
        this.init(ver);
        this.isReturnVoid = returnJavaType == null && returnXmlType == null;
        this.returnXmlType = returnXmlType;
        this.returnJavaType = returnJavaType;
    }

    public SOAPResponseSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, QName returnXmlType, Class returnJavaType) {
        this(type, encodeType, isNullable, encodingStyle, returnXmlType, returnJavaType, SOAPVersion.SOAP_11);
    }

    public SOAPResponseSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, QName returnXmlType, Class returnJavaType, SOAPVersion ver) {
        this(type, encodeType, isNullable, encodingStyle, EMPTY_QNAME_ARRAY, EMPTY_QNAME_ARRAY, EMPTY_CLASS_ARRAY, returnXmlType, returnJavaType, ver);
    }

    public SOAPResponseSerializer(QName type, QName[] parameterNames, QName[] parameterXmlTypes, Class[] parameterClasses, QName returnXmlType, Class returnJavaType) {
        this(type, parameterNames, parameterXmlTypes, parameterClasses, returnXmlType, returnJavaType, SOAPVersion.SOAP_11);
    }

    public SOAPResponseSerializer(QName type, QName[] parameterNames, QName[] parameterXmlTypes, Class[] parameterClasses, QName returnXmlType, Class returnJavaType, SOAPVersion ver) {
        this(type, false, true, SOAPResponseSerializer.getURIEncoding(ver), parameterNames, parameterXmlTypes, parameterClasses, returnXmlType, returnJavaType, ver);
    }

    public SOAPResponseSerializer(QName type, QName returnXmlType, Class returnJavaType) {
        this(type, returnXmlType, returnJavaType, SOAPVersion.SOAP_11);
    }

    public SOAPResponseSerializer(QName type, QName returnXmlType, Class returnJavaType, SOAPVersion ver) {
        this(type, EMPTY_QNAME_ARRAY, EMPTY_QNAME_ARRAY, EMPTY_CLASS_ARRAY, returnXmlType, returnJavaType, ver);
    }

    private static String getURIEncoding(SOAPVersion ver) {
        if (ver == SOAPVersion.SOAP_11) {
            return "http://schemas.xmlsoap.org/soap/encoding/";
        }
        if (ver == SOAPVersion.SOAP_11) {
            return "http://schemas.xmlsoap.org/soap/encoding/";
        }
        return null;
    }

    @Override
    public void initialize(InternalTypeMappingRegistry registry) throws Exception {
        if (this.typeRegistry != null) {
            return;
        }
        super.initialize(registry);
        if (this.returnJavaType != null && this.returnXmlType != null) {
            this.returnSerializer = (JAXRPCSerializer)registry.getSerializer(this.encodingStyle, this.returnJavaType, this.returnXmlType);
            this.returnDeserializer = (JAXRPCDeserializer)registry.getDeserializer(this.encodingStyle, this.returnJavaType, this.returnXmlType);
        }
    }

    @Override
    protected void doSerializeInstance(Object instance, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        SOAPResponseStructure response = (SOAPResponseStructure)instance;
        this.getReturnSerializer(response.returnValue).serialize(response.returnValue, RETURN_VALUE_QNAME, null, writer, context);
        for (int i = 0; i < this.parameterXmlTypes.length; ++i) {
            QName parameterName = this.parameterNames[i];
            Object parameter = response.outParameters.get(parameterName);
            this.getParameterSerializer(i, parameter).serialize(parameter, parameterName, null, writer, context);
        }
    }

    @Override
    protected Object doDeserialize(SOAPDeserializationState existingState, XMLReader reader, SOAPDeserializationContext context) throws Exception {
        Object returnedObject;
        SOAPResponseStructure instance = new SOAPResponseStructure();
        SOAPResponseStructureBuilder builder = null;
        boolean isComplete = true;
        SOAPDeserializationState state = existingState;
        reader.nextElementContent();
        int responseMemberIndex = 0;
        if (!this.isReturnVoid) {
            returnedObject = this.getReturnDeserializer(reader).deserialize(null, reader, context);
            if (returnedObject instanceof SOAPDeserializationState) {
                if (builder == null) {
                    builder = new SOAPResponseStructureBuilder(instance);
                }
                state = SOAPResponseSerializer.registerWithMemberState(instance, state, returnedObject, responseMemberIndex, builder);
                isComplete = false;
            } else {
                instance.returnValue = returnedObject;
            }
            if (this.parameterXmlTypes.length > 0) {
                reader.nextElementContent();
            }
        }
        for (int i = 0; i < this.parameterXmlTypes.length; ++i) {
            QName parameterName = this.parameterNames[i];
            if (reader.getName().equals(parameterName)) {
                returnedObject = this.getParameterDeserializer(i, reader).deserialize(parameterName, reader, context);
                if (returnedObject instanceof SOAPDeserializationState) {
                    if (builder == null) {
                        builder = new SOAPResponseStructureBuilder(instance);
                    }
                    responseMemberIndex = i + 1;
                    builder.setOutParameterName(responseMemberIndex, parameterName);
                    state = SOAPResponseSerializer.registerWithMemberState(instance, state, returnedObject, responseMemberIndex, builder);
                    isComplete = false;
                } else {
                    instance.outParameters.put(parameterName, returnedObject);
                }
            } else {
                throw new DeserializationException("soap.unexpectedElementName", new Object[]{parameterName, reader.getName()});
            }
            instance.outParametersStringKeys.put(parameterName.getLocalPart(), returnedObject);
        }
        reader.nextElementContent();
        return isComplete ? instance : state;
    }

    protected JAXRPCSerializer getReturnSerializer(Object returnValue) throws Exception {
        JAXRPCSerializer serializer = this.returnSerializer;
        if (serializer == null) {
            serializer = (JAXRPCSerializer)this.typeRegistry.getSerializer(this.encodingStyle, returnValue.getClass(), this.returnXmlType);
        }
        return serializer;
    }

    protected JAXRPCDeserializer getReturnDeserializer(XMLReader reader) throws Exception {
        JAXRPCDeserializer deserializer = this.returnDeserializer;
        if (deserializer == null) {
            QName xmlType = this.returnXmlType != null ? this.returnXmlType : SerializerBase.getType(reader);
            deserializer = (JAXRPCDeserializer)this.typeRegistry.getDeserializer(this.encodingStyle, this.returnJavaType, xmlType);
        }
        return deserializer;
    }

    protected static class SOAPResponseStructureBuilder
    implements SOAPInstanceBuilder {
        SOAPResponseStructure instance = null;
        List outParameterNames = new ArrayList();

        public void setOutParameterName(int index, QName name) {
            this.outParameterNames.set(index, name);
        }

        SOAPResponseStructureBuilder(SOAPResponseStructure instance) {
            this.instance = instance;
        }

        @Override
        public int memberGateType(int memberIndex) {
            return 6;
        }

        @Override
        public void construct() {
        }

        @Override
        public void setMember(int index, Object memberValue) {
            try {
                if (index == 0) {
                    this.instance.returnValue = memberValue;
                } else {
                    this.instance.outParameters.put(this.outParameterNames.get(index), memberValue);
                    this.instance.outParametersStringKeys.put(((QName)this.outParameterNames.get(index)).getLocalPart(), memberValue);
                }
            }
            catch (Exception e) {
                throw new DeserializationException("nestedSerializationError", new LocalizableExceptionAdapter(e));
            }
        }

        @Override
        public void initialize() {
        }

        @Override
        public void setInstance(Object instance) {
            instance = (SOAPResponseStructure)instance;
        }

        @Override
        public Object getInstance() {
            return this.instance;
        }
    }
}

