/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.webclient.ui.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.selenium2.webclient.api.SeleniumTestingProvider;
import org.netbeans.modules.selenium2.webclient.api.SeleniumTestingProviders;
import org.netbeans.modules.selenium2.webclient.ui.actions.Bundle;
import org.netbeans.spi.project.ui.support.FileSensitiveActions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class RunSeleniumAction
extends AbstractAction
implements ContextAwareAction {
    private static final RequestProcessor RP = new RequestProcessor(RunSeleniumAction.class.getName(), 1);
    private FileObject[] activatedFOs;

    public RunSeleniumAction() {
        this(Utilities.actionsGlobalContext());
    }

    private RunSeleniumAction(Lookup actionContext) {
        this.activatedFOs = this.lookupSeleniumTestOnly(actionContext);
        if (this.activatedFOs != null) {
            if (this.activatedFOs.length == 1) {
                if (this.activatedFOs[0].isData()) {
                    this.putValue("Name", Bundle.SeleniumTestFileAction_name());
                } else if (this.activatedFOs[0].isFolder()) {
                    this.putValue("Name", Bundle.RunSeleniumTestsAction_name());
                }
            } else {
                boolean onlyFiles = true;
                for (int i = 0; i < this.activatedFOs.length; ++i) {
                    FileObject activatedFO = this.activatedFOs[i];
                    if (!activatedFO.isFolder()) continue;
                    onlyFiles = false;
                    break;
                }
                if (onlyFiles) {
                    this.putValue("Name", Bundle.SeleniumTestFilesAction_name());
                } else {
                    this.putValue("Name", Bundle.RunSeleniumTestsAction_name());
                }
            }
        }
        this.putValue("hideWhenDisabled", true);
        this.setEnabled(this.activatedFOs != null);
    }

    @Override
    public boolean isEnabled() {
        return this.activatedFOs != null;
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                Project p = FileOwnerQuery.getOwner((FileObject)RunSeleniumAction.this.activatedFOs[0]);
                if (p == null) {
                    return;
                }
                FileSensitiveActions.fileCommandAction((String)"test.single", (String)Bundle.SeleniumTestFileAction_name(), null).actionPerformed(e);
                SeleniumTestingProvider provider = SeleniumTestingProviders.getDefault().getSeleniumTestingProvider(p, true);
                if (provider != null) {
                    provider.runTests(RunSeleniumAction.this.activatedFOs);
                }
            }
        });
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new RunSeleniumAction(actionContext);
    }

    @CheckForNull
    private FileObject[] lookupSeleniumTestOnly(Lookup context) {
        Collection fileObjects = context.lookupAll(FileObject.class);
        if (fileObjects.isEmpty()) {
            return null;
        }
        Project p = null;
        for (FileObject fo : fileObjects) {
            Project project = FileOwnerQuery.getOwner((FileObject)fo);
            if (project == null) {
                return null;
            }
            if (p == null) {
                p = project;
            }
            if (!p.equals(project)) {
                return null;
            }
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroups = sources.getSourceGroups("HTML5-Tests-Selenium");
            if (sourceGroups.length != 1) {
                return null;
            }
            FileObject rootFolder = sourceGroups[0].getRootFolder();
            if (FileUtil.isParentOf((FileObject)rootFolder, (FileObject)fo)) continue;
            return null;
        }
        return fileObjects.toArray(new FileObject[0]);
    }
}

