/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetAutonomousContainerDatabaseResourceUsageRequest
extends BmcRequest<Void> {
    private String autonomousContainerDatabaseId;
    private String opcRequestId;

    public String getAutonomousContainerDatabaseId() {
        return this.autonomousContainerDatabaseId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().autonomousContainerDatabaseId(this.autonomousContainerDatabaseId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",autonomousContainerDatabaseId=").append(String.valueOf(this.autonomousContainerDatabaseId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAutonomousContainerDatabaseResourceUsageRequest)) {
            return false;
        }
        GetAutonomousContainerDatabaseResourceUsageRequest other = (GetAutonomousContainerDatabaseResourceUsageRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.autonomousContainerDatabaseId, other.autonomousContainerDatabaseId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.autonomousContainerDatabaseId == null ? 43 : this.autonomousContainerDatabaseId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAutonomousContainerDatabaseResourceUsageRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String autonomousContainerDatabaseId = null;
        private String opcRequestId = null;

        public Builder autonomousContainerDatabaseId(String autonomousContainerDatabaseId) {
            this.autonomousContainerDatabaseId = autonomousContainerDatabaseId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAutonomousContainerDatabaseResourceUsageRequest o) {
            this.autonomousContainerDatabaseId(o.getAutonomousContainerDatabaseId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAutonomousContainerDatabaseResourceUsageRequest build() {
            GetAutonomousContainerDatabaseResourceUsageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAutonomousContainerDatabaseResourceUsageRequest buildWithoutInvocationCallback() {
            GetAutonomousContainerDatabaseResourceUsageRequest request = new GetAutonomousContainerDatabaseResourceUsageRequest();
            request.autonomousContainerDatabaseId = this.autonomousContainerDatabaseId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

