/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.UpdateGroupDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateGroupRequest
extends BmcRequest<UpdateGroupDetails> {
    private String groupId;
    private UpdateGroupDetails updateGroupDetails;
    private String ifMatch;

    public String getGroupId() {
        return this.groupId;
    }

    public UpdateGroupDetails getUpdateGroupDetails() {
        return this.updateGroupDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateGroupDetails getBody$() {
        return this.updateGroupDetails;
    }

    public Builder toBuilder() {
        return new Builder().groupId(this.groupId).updateGroupDetails(this.updateGroupDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",groupId=").append(String.valueOf(this.groupId));
        sb.append(",updateGroupDetails=").append(String.valueOf((Object)this.updateGroupDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateGroupRequest)) {
            return false;
        }
        UpdateGroupRequest other = (UpdateGroupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.groupId, other.groupId) && Objects.equals((Object)this.updateGroupDetails, (Object)other.updateGroupDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.groupId == null ? 43 : this.groupId.hashCode());
        result = result * 59 + (this.updateGroupDetails == null ? 43 : this.updateGroupDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateGroupRequest, UpdateGroupDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String groupId = null;
        private UpdateGroupDetails updateGroupDetails = null;
        private String ifMatch = null;

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder updateGroupDetails(UpdateGroupDetails updateGroupDetails) {
            this.updateGroupDetails = updateGroupDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateGroupRequest o) {
            this.groupId(o.getGroupId());
            this.updateGroupDetails(o.getUpdateGroupDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateGroupRequest build() {
            UpdateGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateGroupDetails body) {
            this.updateGroupDetails(body);
            return this;
        }

        public UpdateGroupRequest buildWithoutInvocationCallback() {
            UpdateGroupRequest request = new UpdateGroupRequest();
            request.groupId = this.groupId;
            request.updateGroupDetails = this.updateGroupDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

